#ifndef PARAMSCONTROLLER_H
#define PARAMSCONTROLLER_H

#include <QWidget>
#include <QKeyEvent>
#include <QDebug>


namespace Ui {
class ParamsController;
}

class ParamsController : public QWidget
{
    Q_OBJECT

public:
    explicit ParamsController(QWidget *parent = 0);
    ~ParamsController();

    double getValue() const;
    double getGeometricSubdivisionThresholdValue() const;
    double getSimilaritySubdivisionThresholdValue() const;
    double getMinSegmentLengthValue() const;

private slots:
    void on_horizontalSlider_valueChanged(int value);
    void on_horizontalSlider_sliderReleased();

signals:
    void paramValueChanged();

private:
    Ui::ParamsController *ui;

    void keyReleaseEvent(QKeyEvent *e);
};

#endif // PARAMSCONTROLLER_H
