#ifndef VIDEOCONTROLS_H
#define VIDEOCONTROLS_H

#include <QWidget>
#include <QDebug>

namespace Ui {
class VideoControls;
}

class VideoControls : public QWidget
{
    Q_OBJECT

private:
    static const QString TOOLTIP_PLAY;
    static const QString TOOLTIP_STOP;
    static const QString TOOLTIP_FORWARDS;
    static const QString TOOLTIP_FORWARDS_FAST;
    static const QString TOOLTIP_BACKWARDS;
    static const QString TOOLTIP_BACKWARDS_FAST;
    static const QString TOOLTIP_GOTO_START;
    static const QString TOOLTIP_GOTO_END;

public:
    typedef enum
    {
        STATE_IDLE,
        STATE_PLAYING
    } State;

private:
    Ui::VideoControls *ui;
    State state;

public:
    explicit VideoControls(QWidget *parent = 0);
    ~VideoControls();
    void setAutoRepeatDelay(int delay);
    void setAutoRepeat(bool autoRepeat);
    State getState() const;
    void setState(State state);
    
private:
    void setStateIdle();
    void setStatePlaying();

signals:
    void play();
    void stop();
    void goToStart();
    void goToEnd();
    void goBackwards();
    void goBackwardsFast();
    void goForwards();
    void goForwardsFast();

private slots:
    void on_btnGoToStart_clicked();
    void on_btnGoBackwardsFast_clicked();
    void on_btnGoBackwards_clicked();
    void on_btnPlay_clicked();
    void on_btnGoForwards_clicked();
    void on_btnGoForwardsFast_clicked();
    void on_btnGoToEnd_clicked();
};

#endif // VIDEOCONTROLS_H
