<?php

/**
  File: heapSort.php
  Desc: Sort list contains numbers
  Author: Jan Drazil
*/

function heapSort($data)
{
  $size=count($data);
  for($i = round($size/2) - 1; $i >= 0; $i--)
    $data=makeHeap($data, $size - 1, $i);
  for($i = $size - 1; $i > 0; $i--)
  {
    $tmp=$data[0];
    $data[0]=$data[$i];
    $data[$i]=$tmp;
    $data=makeHeap($data, $i - 1, 0);
  }
  return $data;
}
  
function makeHeap($data, $bottom, $topIndex)
{
  $tmp = $data[$topIndex];
  $succ = $topIndex*2 + 1;
  if ($succ < $bottom and $data[$succ] < $data[$succ+1])
    $succ++;
    
  while ($succ <= $bottom and $tmp < $data[$succ])
  {
    $data[$topIndex] = $data[$succ];
    $topIndex = $succ;
    $succ = $succ*2 + 1;
    if ($succ < $bottom and $data[$succ] < $data[$succ+1])
      $succ++;
  $data[$topIndex] = $tmp; 
  }
  return $data;
}



###Generated###

/**
  File: printItems.php
  Desc: Print items in array
  Author: Jan Drazil
*/

function printItems($data)
{
  for($i=0;$i<count($data);$i++)
    echo $data[$i]."\n";
}



$data = array(561362,966260,222520,126928,533305,380561,462493,974844,762518,179079,630587,33988,709186,615976,805042,707424,649230,52471,883394,36390,523350,50972,477029,602629,31388,336786,915177,597080,60343,589033,216945,279282,842913,83029,875540,248926,37149,359406,296384,489169,975908,51626,266083,468989,745735,260039,469021,554252,993206,517143,700447,642314,807442,966279,787899,704132,844082,465108,52156,427504,142116,298806,861207,245539,538233,203057,700275,32209,861217,487343,670649,682465,401078,144330,369051,61751,389546,628423,621159,999833,420141,433134,581985,264578,68743,648238,599580,316786,276070,466639,993797,36648,422168,866371,499517,45386,615057,230916,700751,209054,458690,572272,466143,748675,889417,733150,844875,714520,548627,450360,816947,42153,505842,147465,301481,898884,182016,477003,846009,731268,471362,425860,83085,639949,563502,294903,359705,295570,367646,131526,253528,321844,890353,303376,934125,399544,27412,971979,982076,498762,985756,728654,581241,545383,229391,706279,52486,741980,448403,153300,892019,993986,34520,303047,306393,906153,218513,449294,344397,626021,918773,205547,869607,491933,981938,230307,69510,298882,511221,680816,391289,825618,918982,921706,299460,92806,421764,951498,409923,348406,439604,760177,950220,863806,88563,315643,821219,426855,346244,489814,609835,513171,783658,443766,461285,307349,101787,228387,378990,60342,984764,902036,951518,31004,388439,827463,863769,582715,159210,386833,694092,993553,537065,980234,388396,92108,595389,212274,365270,884749,770092,560726,546003,214362,40950,226413,494164,954496,67065,301883,534930,973937,397748,549256,908387,921825,14662,782188,559591,200773,62481,427503,452558,350352,292422,860933,158313,856417,994294,135086,247959,125865,261204,224483,396796,328372,657741,939050,66064,792830,947309,946547,854865,814763,466439,934132,914378,616061,262125,955898,505630,580398,280025,199850,459203,664695,362243,279535,536843,424892,400562,545335,473775,664830,401417,24149,691312,566652,991709,171349,444947,789159,532769,832832,684089,540739,858391,180485,78642,956596);
printItems(heapSort($data));
?>