<?php
$executionTime=microtime(true);

/**
  File: DFS.py
  Desc: Depth first search in tree
  Author: Jan Drazil
*/

function DFS($find, $tree)
{
  if(is_null($tree))
    return false;
  $stack=array($tree);
  while(count($stack))
  {
    $activeTree=array_pop($stack);
    if($activeTree['value'] == $find)
      return true;
    else
      foreach($activeTree['tree'] as $i)
        array_push($stack,$i);
  }
  return false;
}

//require "../support/readItems.php";
//require "arrayToTree.php";
//var_dump(DFS(614,arrayToTree(readItems("../../data/tree/scriptTestTree2"))));



###Generated###
$data = array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 923677),array("tree" => array() ,"value" => 324012),array("tree" => array() ,"value" => 965885),array("tree" => array() ,"value" => 175981)) ,"value" => 786069),array("tree" => array(array("tree" => array() ,"value" => 372796),array("tree" => array() ,"value" => 344434),array("tree" => array() ,"value" => 854201),array("tree" => array() ,"value" => 555277)) ,"value" => 684810),array("tree" => array(array("tree" => array() ,"value" => 154078),array("tree" => array() ,"value" => 662765),array("tree" => array() ,"value" => 178578),array("tree" => array() ,"value" => 927091)) ,"value" => 646066),array("tree" => array(array("tree" => array() ,"value" => 883442),array("tree" => array() ,"value" => 367348),array("tree" => array() ,"value" => 772098),array("tree" => array() ,"value" => 582771)) ,"value" => 685204)) ,"value" => 739956),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 867356),array("tree" => array() ,"value" => 863287),array("tree" => array() ,"value" => 299066),array("tree" => array() ,"value" => 693573)) ,"value" => 178084),array("tree" => array(array("tree" => array() ,"value" => 636543),array("tree" => array() ,"value" => 15078),array("tree" => array() ,"value" => 923176),array("tree" => array() ,"value" => 918908)) ,"value" => 548352),array("tree" => array(array("tree" => array() ,"value" => 794148),array("tree" => array() ,"value" => 894477),array("tree" => array() ,"value" => 487410),array("tree" => array() ,"value" => 229957)) ,"value" => 689684),array("tree" => array(array("tree" => array() ,"value" => 166256),array("tree" => array() ,"value" => 435980),array("tree" => array() ,"value" => 28049),array("tree" => array() ,"value" => 366526)) ,"value" => 873007)) ,"value" => 500961),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 161735),array("tree" => array() ,"value" => 522123),array("tree" => array() ,"value" => 198678),array("tree" => array() ,"value" => 97104)) ,"value" => 694279),array("tree" => array(array("tree" => array() ,"value" => 710611),array("tree" => array() ,"value" => 420421),array("tree" => array() ,"value" => 695025),array("tree" => array() ,"value" => 34196)) ,"value" => 612718),array("tree" => array(array("tree" => array() ,"value" => 809531),array("tree" => array() ,"value" => 669310),array("tree" => array() ,"value" => 483702),array("tree" => array() ,"value" => 979278)) ,"value" => 773091),array("tree" => array(array("tree" => array() ,"value" => 528274),array("tree" => array() ,"value" => 195035),array("tree" => array() ,"value" => 956429),array("tree" => array() ,"value" => 841481)) ,"value" => 726595)) ,"value" => 187736),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 308663),array("tree" => array() ,"value" => 367685),array("tree" => array() ,"value" => 211749),array("tree" => array() ,"value" => 596093)) ,"value" => 876799),array("tree" => array(array("tree" => array() ,"value" => 719875),array("tree" => array() ,"value" => 122135),array("tree" => array() ,"value" => 112646),array("tree" => array() ,"value" => 245368)) ,"value" => 513122),array("tree" => array(array("tree" => array() ,"value" => 412004),array("tree" => array() ,"value" => 117171),array("tree" => array() ,"value" => 529813),array("tree" => array() ,"value" => 118310)) ,"value" => 225269),array("tree" => array(array("tree" => array() ,"value" => 170067),array("tree" => array() ,"value" => 810610),array("tree" => array() ,"value" => 408812),array("tree" => array() ,"value" => 310090)) ,"value" => 214879)) ,"value" => 661053)) ,"value" => 201588),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 24240),array("tree" => array() ,"value" => 252379),array("tree" => array() ,"value" => 452662),array("tree" => array() ,"value" => 843050)) ,"value" => 303675),array("tree" => array(array("tree" => array() ,"value" => 333774),array("tree" => array() ,"value" => 669478),array("tree" => array() ,"value" => 762051),array("tree" => array() ,"value" => 343963)) ,"value" => 71416),array("tree" => array(array("tree" => array() ,"value" => 160790),array("tree" => array() ,"value" => 846522),array("tree" => array() ,"value" => 921749),array("tree" => array() ,"value" => 953341)) ,"value" => 62732),array("tree" => array(array("tree" => array() ,"value" => 181916),array("tree" => array() ,"value" => 814765),array("tree" => array() ,"value" => 868382),array("tree" => array() ,"value" => 957971)) ,"value" => 457874)) ,"value" => 961973),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 650665),array("tree" => array() ,"value" => 247170),array("tree" => array() ,"value" => 628615),array("tree" => array() ,"value" => 489327)) ,"value" => 587631),array("tree" => array(array("tree" => array() ,"value" => 266734),array("tree" => array() ,"value" => 241555),array("tree" => array() ,"value" => 768714),array("tree" => array() ,"value" => 766948)) ,"value" => 581172),array("tree" => array(array("tree" => array() ,"value" => 288313),array("tree" => array() ,"value" => 73663),array("tree" => array() ,"value" => 912988),array("tree" => array() ,"value" => 356910)) ,"value" => 248354),array("tree" => array(array("tree" => array() ,"value" => 126714),array("tree" => array() ,"value" => 967159),array("tree" => array() ,"value" => 483681),array("tree" => array() ,"value" => 169000)) ,"value" => 907379)) ,"value" => 636523),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 426011),array("tree" => array() ,"value" => 325272),array("tree" => array() ,"value" => 977064),array("tree" => array() ,"value" => 765701)) ,"value" => 863166),array("tree" => array(array("tree" => array() ,"value" => 483036),array("tree" => array() ,"value" => 340710),array("tree" => array() ,"value" => 48181),array("tree" => array() ,"value" => 941975)) ,"value" => 635729),array("tree" => array(array("tree" => array() ,"value" => 700901),array("tree" => array() ,"value" => 622669),array("tree" => array() ,"value" => 93439),array("tree" => array() ,"value" => 729391)) ,"value" => 706480),array("tree" => array(array("tree" => array() ,"value" => 296828),array("tree" => array() ,"value" => 537492),array("tree" => array() ,"value" => 73988),array("tree" => array() ,"value" => 863302)) ,"value" => 535936)) ,"value" => 443918),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 558108),array("tree" => array() ,"value" => 581664),array("tree" => array() ,"value" => 990309),array("tree" => array() ,"value" => 332837)) ,"value" => 595031),array("tree" => array(array("tree" => array() ,"value" => 395510),array("tree" => array() ,"value" => 500051),array("tree" => array() ,"value" => 944049),array("tree" => array() ,"value" => 64242)) ,"value" => 232258),array("tree" => array(array("tree" => array() ,"value" => 769075),array("tree" => array() ,"value" => 453757),array("tree" => array() ,"value" => 897270),array("tree" => array() ,"value" => 180581)) ,"value" => 878791),array("tree" => array(array("tree" => array() ,"value" => 665874),array("tree" => array() ,"value" => 306935),array("tree" => array() ,"value" => 497016),array("tree" => array() ,"value" => 222502)) ,"value" => 993808)) ,"value" => 815774)) ,"value" => 751224),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 40571),array("tree" => array() ,"value" => 632343),array("tree" => array() ,"value" => 845469),array("tree" => array() ,"value" => 691844)) ,"value" => 317277),array("tree" => array(array("tree" => array() ,"value" => 780888),array("tree" => array() ,"value" => 261400),array("tree" => array() ,"value" => 726900),array("tree" => array() ,"value" => 372844)) ,"value" => 816177),array("tree" => array(array("tree" => array() ,"value" => 254565),array("tree" => array() ,"value" => 792667),array("tree" => array() ,"value" => 99987),array("tree" => array() ,"value" => 579906)) ,"value" => 891809),array("tree" => array(array("tree" => array() ,"value" => 580505),array("tree" => array() ,"value" => 441981),array("tree" => array() ,"value" => 886235),array("tree" => array() ,"value" => 179795)) ,"value" => 957089)) ,"value" => 726494),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 559311),array("tree" => array() ,"value" => 846674),array("tree" => array() ,"value" => 77847),array("tree" => array() ,"value" => 972327)) ,"value" => 177947),array("tree" => array(array("tree" => array() ,"value" => 998404),array("tree" => array() ,"value" => 119207),array("tree" => array() ,"value" => 368633),array("tree" => array() ,"value" => 347110)) ,"value" => 497976),array("tree" => array(array("tree" => array() ,"value" => 380464),array("tree" => array() ,"value" => 450430),array("tree" => array() ,"value" => 824735),array("tree" => array() ,"value" => 112023)) ,"value" => 641831),array("tree" => array(array("tree" => array() ,"value" => 724998),array("tree" => array() ,"value" => 248344),array("tree" => array() ,"value" => 158795),array("tree" => array() ,"value" => 718142)) ,"value" => 626460)) ,"value" => 945552),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 665368),array("tree" => array() ,"value" => 259259),array("tree" => array() ,"value" => 64511),array("tree" => array() ,"value" => 879791)) ,"value" => 946663),array("tree" => array(array("tree" => array() ,"value" => 863292),array("tree" => array() ,"value" => 583010),array("tree" => array() ,"value" => 901442),array("tree" => array() ,"value" => 301126)) ,"value" => 438568),array("tree" => array(array("tree" => array() ,"value" => 61402),array("tree" => array() ,"value" => 591716),array("tree" => array() ,"value" => 694076),array("tree" => array() ,"value" => 780221)) ,"value" => 476934),array("tree" => array(array("tree" => array() ,"value" => 14364),array("tree" => array() ,"value" => 473908),array("tree" => array() ,"value" => 981571),array("tree" => array() ,"value" => 877727)) ,"value" => 481412)) ,"value" => 563339),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 132421),array("tree" => array() ,"value" => 806742),array("tree" => array() ,"value" => 700926),array("tree" => array() ,"value" => 258855)) ,"value" => 828573),array("tree" => array(array("tree" => array() ,"value" => 741544),array("tree" => array() ,"value" => 245477),array("tree" => array() ,"value" => 393968),array("tree" => array() ,"value" => 758669)) ,"value" => 756559),array("tree" => array(array("tree" => array() ,"value" => 833477),array("tree" => array() ,"value" => 729662),array("tree" => array() ,"value" => 673344),array("tree" => array() ,"value" => 333675)) ,"value" => 438862),array("tree" => array(array("tree" => array() ,"value" => 55751),array("tree" => array() ,"value" => 69157),array("tree" => array() ,"value" => 356168),array("tree" => array() ,"value" => 359022)) ,"value" => 319378)) ,"value" => 327416)) ,"value" => 481554),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 682548),array("tree" => array() ,"value" => 175740),array("tree" => array() ,"value" => 739501),array("tree" => array() ,"value" => 489513)) ,"value" => 744470),array("tree" => array(array("tree" => array() ,"value" => 610969),array("tree" => array() ,"value" => 950340),array("tree" => array() ,"value" => 517084),array("tree" => array() ,"value" => 743153)) ,"value" => 936653),array("tree" => array(array("tree" => array() ,"value" => 811907),array("tree" => array() ,"value" => 109670),array("tree" => array() ,"value" => 865511),array("tree" => array() ,"value" => 202871)) ,"value" => 364990),array("tree" => array(array("tree" => array() ,"value" => 718506),array("tree" => array() ,"value" => 678674),array("tree" => array() ,"value" => 900971),array("tree" => array() ,"value" => 353701)) ,"value" => 529701)) ,"value" => 454968),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 608252),array("tree" => array() ,"value" => 83209),array("tree" => array() ,"value" => 425097),array("tree" => array() ,"value" => 466400)) ,"value" => 472781),array("tree" => array(array("tree" => array() ,"value" => 429182),array("tree" => array() ,"value" => 361859),array("tree" => array() ,"value" => 918604),array("tree" => array() ,"value" => 680869)) ,"value" => 384033),array("tree" => array(array("tree" => array() ,"value" => 47530),array("tree" => array() ,"value" => 391765),array("tree" => array() ,"value" => 991052),array("tree" => array() ,"value" => 420544)) ,"value" => 15946),array("tree" => array(array("tree" => array() ,"value" => 672132),array("tree" => array() ,"value" => 129588),array("tree" => array() ,"value" => 883977),array("tree" => array() ,"value" => 347628)) ,"value" => 590092)) ,"value" => 970905),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 835833),array("tree" => array() ,"value" => 539565),array("tree" => array() ,"value" => 995097),array("tree" => array() ,"value" => 896511)) ,"value" => 780316),array("tree" => array(array("tree" => array() ,"value" => 547332),array("tree" => array() ,"value" => 352270),array("tree" => array() ,"value" => 222097),array("tree" => array() ,"value" => 241833)) ,"value" => 60753),array("tree" => array(array("tree" => array() ,"value" => 549904),array("tree" => array() ,"value" => 811080),array("tree" => array() ,"value" => 1284),array("tree" => array() ,"value" => 964531)) ,"value" => 209738),array("tree" => array(array("tree" => array() ,"value" => 910819),array("tree" => array() ,"value" => 987740),array("tree" => array() ,"value" => 374176),array("tree" => array() ,"value" => 215581)) ,"value" => 709784)) ,"value" => 39962),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 737245),array("tree" => array() ,"value" => 537867),array("tree" => array() ,"value" => 901228),array("tree" => array() ,"value" => 361161)) ,"value" => 663141),array("tree" => array(array("tree" => array() ,"value" => 465971),array("tree" => array() ,"value" => 848499),array("tree" => array() ,"value" => 135036),array("tree" => array() ,"value" => 806452)) ,"value" => 884924),array("tree" => array(array("tree" => array() ,"value" => 690529),array("tree" => array() ,"value" => 161472),array("tree" => array() ,"value" => 930158),array("tree" => array() ,"value" => 89647)) ,"value" => 151723),array("tree" => array(array("tree" => array() ,"value" => 295029),array("tree" => array() ,"value" => 586161),array("tree" => array() ,"value" => 384375),array("tree" => array() ,"value" => 208480)) ,"value" => 441113)) ,"value" => 424012)) ,"value" => 336467)) ,"value" => 792292),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 293338),array("tree" => array() ,"value" => 556368),array("tree" => array() ,"value" => 782882),array("tree" => array() ,"value" => 975242)) ,"value" => 935533),array("tree" => array(array("tree" => array() ,"value" => 30669),array("tree" => array() ,"value" => 439794),array("tree" => array() ,"value" => 328014),array("tree" => array() ,"value" => 364656)) ,"value" => 180029),array("tree" => array(array("tree" => array() ,"value" => 898154),array("tree" => array() ,"value" => 621785),array("tree" => array() ,"value" => 557580),array("tree" => array() ,"value" => 522698)) ,"value" => 956456),array("tree" => array(array("tree" => array() ,"value" => 881481),array("tree" => array() ,"value" => 931215),array("tree" => array() ,"value" => 637405),array("tree" => array() ,"value" => 556772)) ,"value" => 682954)) ,"value" => 743844),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 99479),array("tree" => array() ,"value" => 901554),array("tree" => array() ,"value" => 746424),array("tree" => array() ,"value" => 401904)) ,"value" => 329632),array("tree" => array(array("tree" => array() ,"value" => 578173),array("tree" => array() ,"value" => 747582),array("tree" => array() ,"value" => 354962),array("tree" => array() ,"value" => 537648)) ,"value" => 803478),array("tree" => array(array("tree" => array() ,"value" => 620900),array("tree" => array() ,"value" => 537013),array("tree" => array() ,"value" => 945254),array("tree" => array() ,"value" => 989091)) ,"value" => 287840),array("tree" => array(array("tree" => array() ,"value" => 14674),array("tree" => array() ,"value" => 603468),array("tree" => array() ,"value" => 894693),array("tree" => array() ,"value" => 611494)) ,"value" => 594743)) ,"value" => 499749),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 720273),array("tree" => array() ,"value" => 769521),array("tree" => array() ,"value" => 826372),array("tree" => array() ,"value" => 745669)) ,"value" => 323800),array("tree" => array(array("tree" => array() ,"value" => 444494),array("tree" => array() ,"value" => 893149),array("tree" => array() ,"value" => 114907),array("tree" => array() ,"value" => 635585)) ,"value" => 718664),array("tree" => array(array("tree" => array() ,"value" => 658353),array("tree" => array() ,"value" => 341483),array("tree" => array() ,"value" => 857675),array("tree" => array() ,"value" => 595665)) ,"value" => 590503),array("tree" => array(array("tree" => array() ,"value" => 517077),array("tree" => array() ,"value" => 86374),array("tree" => array() ,"value" => 125627),array("tree" => array() ,"value" => 92254)) ,"value" => 654900)) ,"value" => 587089),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 499996),array("tree" => array() ,"value" => 734055),array("tree" => array() ,"value" => 121501),array("tree" => array() ,"value" => 690945)) ,"value" => 244963),array("tree" => array(array("tree" => array() ,"value" => 77921),array("tree" => array() ,"value" => 347437),array("tree" => array() ,"value" => 911780),array("tree" => array() ,"value" => 978201)) ,"value" => 75679),array("tree" => array(array("tree" => array() ,"value" => 396189),array("tree" => array() ,"value" => 787211),array("tree" => array() ,"value" => 593700),array("tree" => array() ,"value" => 653388)) ,"value" => 350892),array("tree" => array(array("tree" => array() ,"value" => 461305),array("tree" => array() ,"value" => 206395),array("tree" => array() ,"value" => 57592),array("tree" => array() ,"value" => 50210)) ,"value" => 511953)) ,"value" => 162042)) ,"value" => 119794),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 464735),array("tree" => array() ,"value" => 910353),array("tree" => array() ,"value" => 786833),array("tree" => array() ,"value" => 136924)) ,"value" => 121285),array("tree" => array(array("tree" => array() ,"value" => 909941),array("tree" => array() ,"value" => 930294),array("tree" => array() ,"value" => 416024),array("tree" => array() ,"value" => 843966)) ,"value" => 758556),array("tree" => array(array("tree" => array() ,"value" => 48595),array("tree" => array() ,"value" => 488925),array("tree" => array() ,"value" => 488080),array("tree" => array() ,"value" => 121006)) ,"value" => 297128),array("tree" => array(array("tree" => array() ,"value" => 995938),array("tree" => array() ,"value" => 244438),array("tree" => array() ,"value" => 637988),array("tree" => array() ,"value" => 525275)) ,"value" => 392532)) ,"value" => 103633),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 731153),array("tree" => array() ,"value" => 620267),array("tree" => array() ,"value" => 847581),array("tree" => array() ,"value" => 801271)) ,"value" => 581806),array("tree" => array(array("tree" => array() ,"value" => 808260),array("tree" => array() ,"value" => 312507),array("tree" => array() ,"value" => 385969),array("tree" => array() ,"value" => 162376)) ,"value" => 1914),array("tree" => array(array("tree" => array() ,"value" => 990460),array("tree" => array() ,"value" => 580292),array("tree" => array() ,"value" => 289682),array("tree" => array() ,"value" => 849103)) ,"value" => 739454),array("tree" => array(array("tree" => array() ,"value" => 16265),array("tree" => array() ,"value" => 710204),array("tree" => array() ,"value" => 833741),array("tree" => array() ,"value" => 798254)) ,"value" => 307757)) ,"value" => 852355),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 574843),array("tree" => array() ,"value" => 280389),array("tree" => array() ,"value" => 355790),array("tree" => array() ,"value" => 227781)) ,"value" => 200040),array("tree" => array(array("tree" => array() ,"value" => 301642),array("tree" => array() ,"value" => 70663),array("tree" => array() ,"value" => 34377),array("tree" => array() ,"value" => 56121)) ,"value" => 480980),array("tree" => array(array("tree" => array() ,"value" => 201176),array("tree" => array() ,"value" => 320051),array("tree" => array() ,"value" => 186514),array("tree" => array() ,"value" => 591739)) ,"value" => 852375),array("tree" => array(array("tree" => array() ,"value" => 310671),array("tree" => array() ,"value" => 278911),array("tree" => array() ,"value" => 762009),array("tree" => array() ,"value" => 993388)) ,"value" => 986807)) ,"value" => 586656),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 356967),array("tree" => array() ,"value" => 6375),array("tree" => array() ,"value" => 943675),array("tree" => array() ,"value" => 557741)) ,"value" => 18560),array("tree" => array(array("tree" => array() ,"value" => 333612),array("tree" => array() ,"value" => 532946),array("tree" => array() ,"value" => 797775),array("tree" => array() ,"value" => 488784)) ,"value" => 238576),array("tree" => array(array("tree" => array() ,"value" => 170540),array("tree" => array() ,"value" => 469524),array("tree" => array() ,"value" => 109833),array("tree" => array() ,"value" => 621111)) ,"value" => 994349),array("tree" => array(array("tree" => array() ,"value" => 621213),array("tree" => array() ,"value" => 122454),array("tree" => array() ,"value" => 140595),array("tree" => array() ,"value" => 541925)) ,"value" => 583879)) ,"value" => 343434)) ,"value" => 415411),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 569422),array("tree" => array() ,"value" => 110550),array("tree" => array() ,"value" => 769650),array("tree" => array() ,"value" => 785356)) ,"value" => 511839),array("tree" => array(array("tree" => array() ,"value" => 892085),array("tree" => array() ,"value" => 189027),array("tree" => array() ,"value" => 431766),array("tree" => array() ,"value" => 59733)) ,"value" => 12374),array("tree" => array(array("tree" => array() ,"value" => 489902),array("tree" => array() ,"value" => 177877),array("tree" => array() ,"value" => 863033),array("tree" => array() ,"value" => 263376)) ,"value" => 279067),array("tree" => array(array("tree" => array() ,"value" => 84200),array("tree" => array() ,"value" => 780615),array("tree" => array() ,"value" => 509596),array("tree" => array() ,"value" => 418684)) ,"value" => 794894)) ,"value" => 686573),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 656275),array("tree" => array() ,"value" => 13167),array("tree" => array() ,"value" => 604001),array("tree" => array() ,"value" => 945013)) ,"value" => 9419),array("tree" => array(array("tree" => array() ,"value" => 28531),array("tree" => array() ,"value" => 667293),array("tree" => array() ,"value" => 521337),array("tree" => array() ,"value" => 23626)) ,"value" => 465549),array("tree" => array(array("tree" => array() ,"value" => 285241),array("tree" => array() ,"value" => 270651),array("tree" => array() ,"value" => 344181),array("tree" => array() ,"value" => 466937)) ,"value" => 847283),array("tree" => array(array("tree" => array() ,"value" => 413993),array("tree" => array() ,"value" => 512601),array("tree" => array() ,"value" => 19863),array("tree" => array() ,"value" => 469180)) ,"value" => 162646)) ,"value" => 461388),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 192116),array("tree" => array() ,"value" => 360054),array("tree" => array() ,"value" => 922079),array("tree" => array() ,"value" => 242928)) ,"value" => 58871),array("tree" => array(array("tree" => array() ,"value" => 830475),array("tree" => array() ,"value" => 908372),array("tree" => array() ,"value" => 389176),array("tree" => array() ,"value" => 668959)) ,"value" => 905132),array("tree" => array(array("tree" => array() ,"value" => 239772),array("tree" => array() ,"value" => 927922),array("tree" => array() ,"value" => 9365),array("tree" => array() ,"value" => 551587)) ,"value" => 830126),array("tree" => array(array("tree" => array() ,"value" => 286235),array("tree" => array() ,"value" => 415632),array("tree" => array() ,"value" => 69593),array("tree" => array() ,"value" => 746987)) ,"value" => 353437)) ,"value" => 920424),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 269703),array("tree" => array() ,"value" => 781079),array("tree" => array() ,"value" => 590120),array("tree" => array() ,"value" => 647476)) ,"value" => 141655),array("tree" => array(array("tree" => array() ,"value" => 447510),array("tree" => array() ,"value" => 558795),array("tree" => array() ,"value" => 684079),array("tree" => array() ,"value" => 857534)) ,"value" => 415187),array("tree" => array(array("tree" => array() ,"value" => 62658),array("tree" => array() ,"value" => 304840),array("tree" => array() ,"value" => 201546),array("tree" => array() ,"value" => 927235)) ,"value" => 360126),array("tree" => array(array("tree" => array() ,"value" => 722519),array("tree" => array() ,"value" => 370732),array("tree" => array() ,"value" => 438766),array("tree" => array() ,"value" => 837000)) ,"value" => 962874)) ,"value" => 279685)) ,"value" => 870319),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 164736),array("tree" => array() ,"value" => 42051),array("tree" => array() ,"value" => 899981),array("tree" => array() ,"value" => 809811)) ,"value" => 276180),array("tree" => array(array("tree" => array() ,"value" => 350958),array("tree" => array() ,"value" => 826343),array("tree" => array() ,"value" => 333798),array("tree" => array() ,"value" => 762934)) ,"value" => 329578),array("tree" => array(array("tree" => array() ,"value" => 661527),array("tree" => array() ,"value" => 957789),array("tree" => array() ,"value" => 343042),array("tree" => array() ,"value" => 360921)) ,"value" => 978272),array("tree" => array(array("tree" => array() ,"value" => 301775),array("tree" => array() ,"value" => 263091),array("tree" => array() ,"value" => 551376),array("tree" => array() ,"value" => 107842)) ,"value" => 984276)) ,"value" => 160810),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 298753),array("tree" => array() ,"value" => 763593),array("tree" => array() ,"value" => 430165),array("tree" => array() ,"value" => 426597)) ,"value" => 386876),array("tree" => array(array("tree" => array() ,"value" => 395412),array("tree" => array() ,"value" => 863537),array("tree" => array() ,"value" => 814009),array("tree" => array() ,"value" => 412898)) ,"value" => 489825),array("tree" => array(array("tree" => array() ,"value" => 545071),array("tree" => array() ,"value" => 765338),array("tree" => array() ,"value" => 870659),array("tree" => array() ,"value" => 658275)) ,"value" => 242468),array("tree" => array(array("tree" => array() ,"value" => 997468),array("tree" => array() ,"value" => 833825),array("tree" => array() ,"value" => 9887),array("tree" => array() ,"value" => 164151)) ,"value" => 726498)) ,"value" => 294243),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 620599),array("tree" => array() ,"value" => 343064),array("tree" => array() ,"value" => 916607),array("tree" => array() ,"value" => 841012)) ,"value" => 334080),array("tree" => array(array("tree" => array() ,"value" => 888655),array("tree" => array() ,"value" => 774845),array("tree" => array() ,"value" => 152782),array("tree" => array() ,"value" => 15986)) ,"value" => 11758),array("tree" => array(array("tree" => array() ,"value" => 105519),array("tree" => array() ,"value" => 226187),array("tree" => array() ,"value" => 989635),array("tree" => array() ,"value" => 62305)) ,"value" => 66133),array("tree" => array(array("tree" => array() ,"value" => 995359),array("tree" => array() ,"value" => 766472),array("tree" => array() ,"value" => 754495),array("tree" => array() ,"value" => 744123)) ,"value" => 575996)) ,"value" => 152568),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 289330),array("tree" => array() ,"value" => 827558),array("tree" => array() ,"value" => 692259),array("tree" => array() ,"value" => 707025)) ,"value" => 237339),array("tree" => array(array("tree" => array() ,"value" => 656129),array("tree" => array() ,"value" => 687940),array("tree" => array() ,"value" => 248133),array("tree" => array() ,"value" => 695231)) ,"value" => 778280),array("tree" => array(array("tree" => array() ,"value" => 241735),array("tree" => array() ,"value" => 473586),array("tree" => array() ,"value" => 918117),array("tree" => array() ,"value" => 734794)) ,"value" => 259237),array("tree" => array(array("tree" => array() ,"value" => 954518),array("tree" => array() ,"value" => 372640),array("tree" => array() ,"value" => 166938),array("tree" => array() ,"value" => 525054)) ,"value" => 737744)) ,"value" => 964088)) ,"value" => 688558)) ,"value" => 708261),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 857087),array("tree" => array() ,"value" => 375867),array("tree" => array() ,"value" => 600022),array("tree" => array() ,"value" => 651232)) ,"value" => 209486),array("tree" => array(array("tree" => array() ,"value" => 640674),array("tree" => array() ,"value" => 556702),array("tree" => array() ,"value" => 540612),array("tree" => array() ,"value" => 39081)) ,"value" => 324412),array("tree" => array(array("tree" => array() ,"value" => 329168),array("tree" => array() ,"value" => 457539),array("tree" => array() ,"value" => 967549),array("tree" => array() ,"value" => 227246)) ,"value" => 844696),array("tree" => array(array("tree" => array() ,"value" => 644657),array("tree" => array() ,"value" => 670535),array("tree" => array() ,"value" => 105495),array("tree" => array() ,"value" => 769159)) ,"value" => 429132)) ,"value" => 553932),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 299195),array("tree" => array() ,"value" => 350209),array("tree" => array() ,"value" => 296302),array("tree" => array() ,"value" => 12569)) ,"value" => 202232),array("tree" => array(array("tree" => array() ,"value" => 883671),array("tree" => array() ,"value" => 922873),array("tree" => array() ,"value" => 287655),array("tree" => array() ,"value" => 899957)) ,"value" => 711098),array("tree" => array(array("tree" => array() ,"value" => 406736),array("tree" => array() ,"value" => 816916),array("tree" => array() ,"value" => 807330),array("tree" => array() ,"value" => 484876)) ,"value" => 31869),array("tree" => array(array("tree" => array() ,"value" => 89583),array("tree" => array() ,"value" => 631806),array("tree" => array() ,"value" => 906702),array("tree" => array() ,"value" => 346621)) ,"value" => 2062)) ,"value" => 785266),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 430660),array("tree" => array() ,"value" => 56273),array("tree" => array() ,"value" => 768591),array("tree" => array() ,"value" => 778697)) ,"value" => 216904),array("tree" => array(array("tree" => array() ,"value" => 818217),array("tree" => array() ,"value" => 130893),array("tree" => array() ,"value" => 30406),array("tree" => array() ,"value" => 245184)) ,"value" => 924475),array("tree" => array(array("tree" => array() ,"value" => 49097),array("tree" => array() ,"value" => 414566),array("tree" => array() ,"value" => 304),array("tree" => array() ,"value" => 770738)) ,"value" => 796597),array("tree" => array(array("tree" => array() ,"value" => 247328),array("tree" => array() ,"value" => 994801),array("tree" => array() ,"value" => 129994),array("tree" => array() ,"value" => 67731)) ,"value" => 100730)) ,"value" => 399365),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 766453),array("tree" => array() ,"value" => 110668),array("tree" => array() ,"value" => 77818),array("tree" => array() ,"value" => 639849)) ,"value" => 579139),array("tree" => array(array("tree" => array() ,"value" => 618226),array("tree" => array() ,"value" => 352749),array("tree" => array() ,"value" => 987426),array("tree" => array() ,"value" => 845753)) ,"value" => 809457),array("tree" => array(array("tree" => array() ,"value" => 58235),array("tree" => array() ,"value" => 734432),array("tree" => array() ,"value" => 438378),array("tree" => array() ,"value" => 201574)) ,"value" => 732497),array("tree" => array(array("tree" => array() ,"value" => 704068),array("tree" => array() ,"value" => 444592),array("tree" => array() ,"value" => 648422),array("tree" => array() ,"value" => 871458)) ,"value" => 587112)) ,"value" => 738834)) ,"value" => 983845),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 148346),array("tree" => array() ,"value" => 621753),array("tree" => array() ,"value" => 79808),array("tree" => array() ,"value" => 382263)) ,"value" => 738003),array("tree" => array(array("tree" => array() ,"value" => 511801),array("tree" => array() ,"value" => 258872),array("tree" => array() ,"value" => 279353),array("tree" => array() ,"value" => 696228)) ,"value" => 457594),array("tree" => array(array("tree" => array() ,"value" => 155941),array("tree" => array() ,"value" => 310432),array("tree" => array() ,"value" => 920524),array("tree" => array() ,"value" => 705714)) ,"value" => 627305),array("tree" => array(array("tree" => array() ,"value" => 842860),array("tree" => array() ,"value" => 621389),array("tree" => array() ,"value" => 254384),array("tree" => array() ,"value" => 866409)) ,"value" => 611652)) ,"value" => 139590),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 267717),array("tree" => array() ,"value" => 912695),array("tree" => array() ,"value" => 385535),array("tree" => array() ,"value" => 584456)) ,"value" => 223820),array("tree" => array(array("tree" => array() ,"value" => 554628),array("tree" => array() ,"value" => 91135),array("tree" => array() ,"value" => 341719),array("tree" => array() ,"value" => 854143)) ,"value" => 652138),array("tree" => array(array("tree" => array() ,"value" => 395007),array("tree" => array() ,"value" => 240990),array("tree" => array() ,"value" => 281980),array("tree" => array() ,"value" => 27122)) ,"value" => 986148),array("tree" => array(array("tree" => array() ,"value" => 504603),array("tree" => array() ,"value" => 701005),array("tree" => array() ,"value" => 850533),array("tree" => array() ,"value" => 938765)) ,"value" => 622401)) ,"value" => 20134),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 558295),array("tree" => array() ,"value" => 962529),array("tree" => array() ,"value" => 32891),array("tree" => array() ,"value" => 229396)) ,"value" => 916383),array("tree" => array(array("tree" => array() ,"value" => 877618),array("tree" => array() ,"value" => 146083),array("tree" => array() ,"value" => 710352),array("tree" => array() ,"value" => 196681)) ,"value" => 927525),array("tree" => array(array("tree" => array() ,"value" => 771496),array("tree" => array() ,"value" => 358388),array("tree" => array() ,"value" => 995719),array("tree" => array() ,"value" => 556933)) ,"value" => 667367),array("tree" => array(array("tree" => array() ,"value" => 19668),array("tree" => array() ,"value" => 478595),array("tree" => array() ,"value" => 359456),array("tree" => array() ,"value" => 209059)) ,"value" => 542632)) ,"value" => 419253),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 678813),array("tree" => array() ,"value" => 919992),array("tree" => array() ,"value" => 820008),array("tree" => array() ,"value" => 593822)) ,"value" => 370457),array("tree" => array(array("tree" => array() ,"value" => 756899),array("tree" => array() ,"value" => 850165),array("tree" => array() ,"value" => 722207),array("tree" => array() ,"value" => 661860)) ,"value" => 276864),array("tree" => array(array("tree" => array() ,"value" => 846692),array("tree" => array() ,"value" => 391557),array("tree" => array() ,"value" => 72111),array("tree" => array() ,"value" => 290203)) ,"value" => 440045),array("tree" => array(array("tree" => array() ,"value" => 164108),array("tree" => array() ,"value" => 946896),array("tree" => array() ,"value" => 868978),array("tree" => array() ,"value" => 58523)) ,"value" => 562735)) ,"value" => 480193)) ,"value" => 87160),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 321968),array("tree" => array() ,"value" => 896049),array("tree" => array() ,"value" => 518303),array("tree" => array() ,"value" => 541146)) ,"value" => 480882),array("tree" => array(array("tree" => array() ,"value" => 947810),array("tree" => array() ,"value" => 531009),array("tree" => array() ,"value" => 973476),array("tree" => array() ,"value" => 269223)) ,"value" => 330932),array("tree" => array(array("tree" => array() ,"value" => 401646),array("tree" => array() ,"value" => 316870),array("tree" => array() ,"value" => 834498),array("tree" => array() ,"value" => 236263)) ,"value" => 99215),array("tree" => array(array("tree" => array() ,"value" => 395501),array("tree" => array() ,"value" => 873899),array("tree" => array() ,"value" => 405481),array("tree" => array() ,"value" => 115915)) ,"value" => 554848)) ,"value" => 413679),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 62574),array("tree" => array() ,"value" => 865958),array("tree" => array() ,"value" => 63177),array("tree" => array() ,"value" => 990116)) ,"value" => 918965),array("tree" => array(array("tree" => array() ,"value" => 364649),array("tree" => array() ,"value" => 661764),array("tree" => array() ,"value" => 568956),array("tree" => array() ,"value" => 213789)) ,"value" => 709722),array("tree" => array(array("tree" => array() ,"value" => 40606),array("tree" => array() ,"value" => 535256),array("tree" => array() ,"value" => 23064),array("tree" => array() ,"value" => 492586)) ,"value" => 729653),array("tree" => array(array("tree" => array() ,"value" => 254665),array("tree" => array() ,"value" => 149408),array("tree" => array() ,"value" => 907515),array("tree" => array() ,"value" => 19926)) ,"value" => 595107)) ,"value" => 599377),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 753523),array("tree" => array() ,"value" => 307362),array("tree" => array() ,"value" => 772866),array("tree" => array() ,"value" => 257019)) ,"value" => 955654),array("tree" => array(array("tree" => array() ,"value" => 129325),array("tree" => array() ,"value" => 230677),array("tree" => array() ,"value" => 391970),array("tree" => array() ,"value" => 103036)) ,"value" => 80360),array("tree" => array(array("tree" => array() ,"value" => 642430),array("tree" => array() ,"value" => 568800),array("tree" => array() ,"value" => 160024),array("tree" => array() ,"value" => 639258)) ,"value" => 429641),array("tree" => array(array("tree" => array() ,"value" => 787027),array("tree" => array() ,"value" => 442269),array("tree" => array() ,"value" => 566940),array("tree" => array() ,"value" => 28360)) ,"value" => 319238)) ,"value" => 172096),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 807590),array("tree" => array() ,"value" => 135544),array("tree" => array() ,"value" => 323071),array("tree" => array() ,"value" => 941021)) ,"value" => 598004),array("tree" => array(array("tree" => array() ,"value" => 405506),array("tree" => array() ,"value" => 284581),array("tree" => array() ,"value" => 705898),array("tree" => array() ,"value" => 955121)) ,"value" => 345202),array("tree" => array(array("tree" => array() ,"value" => 467136),array("tree" => array() ,"value" => 17585),array("tree" => array() ,"value" => 95085),array("tree" => array() ,"value" => 307612)) ,"value" => 144906),array("tree" => array(array("tree" => array() ,"value" => 727530),array("tree" => array() ,"value" => 477329),array("tree" => array() ,"value" => 274122),array("tree" => array() ,"value" => 12141)) ,"value" => 763111)) ,"value" => 43258)) ,"value" => 54003),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 329713),array("tree" => array() ,"value" => 685605),array("tree" => array() ,"value" => 939064),array("tree" => array() ,"value" => 534778)) ,"value" => 550734),array("tree" => array(array("tree" => array() ,"value" => 469318),array("tree" => array() ,"value" => 678536),array("tree" => array() ,"value" => 356343),array("tree" => array() ,"value" => 940115)) ,"value" => 23168),array("tree" => array(array("tree" => array() ,"value" => 882240),array("tree" => array() ,"value" => 302265),array("tree" => array() ,"value" => 173653),array("tree" => array() ,"value" => 345393)) ,"value" => 170038),array("tree" => array(array("tree" => array() ,"value" => 387870),array("tree" => array() ,"value" => 938782),array("tree" => array() ,"value" => 998847),array("tree" => array() ,"value" => 57740)) ,"value" => 549525)) ,"value" => 741616),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 661188),array("tree" => array() ,"value" => 762004),array("tree" => array() ,"value" => 57548),array("tree" => array() ,"value" => 848084)) ,"value" => 69402),array("tree" => array(array("tree" => array() ,"value" => 994125),array("tree" => array() ,"value" => 231689),array("tree" => array() ,"value" => 33493),array("tree" => array() ,"value" => 104766)) ,"value" => 737221),array("tree" => array(array("tree" => array() ,"value" => 508776),array("tree" => array() ,"value" => 180020),array("tree" => array() ,"value" => 688283),array("tree" => array() ,"value" => 701177)) ,"value" => 942200),array("tree" => array(array("tree" => array() ,"value" => 292796),array("tree" => array() ,"value" => 651867),array("tree" => array() ,"value" => 662325),array("tree" => array() ,"value" => 369853)) ,"value" => 675193)) ,"value" => 641060),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 589545),array("tree" => array() ,"value" => 885041),array("tree" => array() ,"value" => 400830),array("tree" => array() ,"value" => 299451)) ,"value" => 957295),array("tree" => array(array("tree" => array() ,"value" => 84643),array("tree" => array() ,"value" => 202775),array("tree" => array() ,"value" => 683025),array("tree" => array() ,"value" => 919492)) ,"value" => 738805),array("tree" => array(array("tree" => array() ,"value" => 934754),array("tree" => array() ,"value" => 997200),array("tree" => array() ,"value" => 79808),array("tree" => array() ,"value" => 325889)) ,"value" => 320467),array("tree" => array(array("tree" => array() ,"value" => 471222),array("tree" => array() ,"value" => 75402),array("tree" => array() ,"value" => 245522),array("tree" => array() ,"value" => 622404)) ,"value" => 797917)) ,"value" => 102990),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 724221),array("tree" => array() ,"value" => 282582),array("tree" => array() ,"value" => 693004),array("tree" => array() ,"value" => 709883)) ,"value" => 65225),array("tree" => array(array("tree" => array() ,"value" => 588058),array("tree" => array() ,"value" => 551032),array("tree" => array() ,"value" => 857361),array("tree" => array() ,"value" => 127766)) ,"value" => 317861),array("tree" => array(array("tree" => array() ,"value" => 284893),array("tree" => array() ,"value" => 308312),array("tree" => array() ,"value" => 524709),array("tree" => array() ,"value" => 346474)) ,"value" => 893767),array("tree" => array(array("tree" => array() ,"value" => 784513),array("tree" => array() ,"value" => 445350),array("tree" => array() ,"value" => 808214),array("tree" => array() ,"value" => 588602)) ,"value" => 664185)) ,"value" => 275778)) ,"value" => 128530)) ,"value" => 780086),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 359318),array("tree" => array() ,"value" => 554948),array("tree" => array() ,"value" => 824030),array("tree" => array() ,"value" => 119209)) ,"value" => 270615),array("tree" => array(array("tree" => array() ,"value" => 62705),array("tree" => array() ,"value" => 460094),array("tree" => array() ,"value" => 332835),array("tree" => array() ,"value" => 230212)) ,"value" => 712359),array("tree" => array(array("tree" => array() ,"value" => 369034),array("tree" => array() ,"value" => 691515),array("tree" => array() ,"value" => 278647),array("tree" => array() ,"value" => 751849)) ,"value" => 216212),array("tree" => array(array("tree" => array() ,"value" => 975925),array("tree" => array() ,"value" => 678826),array("tree" => array() ,"value" => 212039),array("tree" => array() ,"value" => 37529)) ,"value" => 933484)) ,"value" => 592725),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 405420),array("tree" => array() ,"value" => 991737),array("tree" => array() ,"value" => 878308),array("tree" => array() ,"value" => 293950)) ,"value" => 726548),array("tree" => array(array("tree" => array() ,"value" => 340291),array("tree" => array() ,"value" => 522588),array("tree" => array() ,"value" => 974718),array("tree" => array() ,"value" => 557059)) ,"value" => 330261),array("tree" => array(array("tree" => array() ,"value" => 800897),array("tree" => array() ,"value" => 302554),array("tree" => array() ,"value" => 148009),array("tree" => array() ,"value" => 377261)) ,"value" => 407784),array("tree" => array(array("tree" => array() ,"value" => 180782),array("tree" => array() ,"value" => 221459),array("tree" => array() ,"value" => 587132),array("tree" => array() ,"value" => 369644)) ,"value" => 746885)) ,"value" => 589364),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 813344),array("tree" => array() ,"value" => 465337),array("tree" => array() ,"value" => 990369),array("tree" => array() ,"value" => 530915)) ,"value" => 350015),array("tree" => array(array("tree" => array() ,"value" => 477550),array("tree" => array() ,"value" => 159303),array("tree" => array() ,"value" => 871855),array("tree" => array() ,"value" => 594009)) ,"value" => 325507),array("tree" => array(array("tree" => array() ,"value" => 773309),array("tree" => array() ,"value" => 470168),array("tree" => array() ,"value" => 553295),array("tree" => array() ,"value" => 568482)) ,"value" => 974673),array("tree" => array(array("tree" => array() ,"value" => 968829),array("tree" => array() ,"value" => 166384),array("tree" => array() ,"value" => 875217),array("tree" => array() ,"value" => 288499)) ,"value" => 226605)) ,"value" => 842720),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 148895),array("tree" => array() ,"value" => 946192),array("tree" => array() ,"value" => 496050),array("tree" => array() ,"value" => 935355)) ,"value" => 87005),array("tree" => array(array("tree" => array() ,"value" => 461433),array("tree" => array() ,"value" => 26415),array("tree" => array() ,"value" => 870432),array("tree" => array() ,"value" => 343172)) ,"value" => 122943),array("tree" => array(array("tree" => array() ,"value" => 261165),array("tree" => array() ,"value" => 835896),array("tree" => array() ,"value" => 213345),array("tree" => array() ,"value" => 492127)) ,"value" => 821993),array("tree" => array(array("tree" => array() ,"value" => 770284),array("tree" => array() ,"value" => 328600),array("tree" => array() ,"value" => 31475),array("tree" => array() ,"value" => 472365)) ,"value" => 9068)) ,"value" => 323338)) ,"value" => 346270),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 916967),array("tree" => array() ,"value" => 937657),array("tree" => array() ,"value" => 211669),array("tree" => array() ,"value" => 753315)) ,"value" => 634018),array("tree" => array(array("tree" => array() ,"value" => 792178),array("tree" => array() ,"value" => 822833),array("tree" => array() ,"value" => 421750),array("tree" => array() ,"value" => 527409)) ,"value" => 163363),array("tree" => array(array("tree" => array() ,"value" => 920408),array("tree" => array() ,"value" => 666019),array("tree" => array() ,"value" => 903139),array("tree" => array() ,"value" => 11467)) ,"value" => 506839),array("tree" => array(array("tree" => array() ,"value" => 853140),array("tree" => array() ,"value" => 381437),array("tree" => array() ,"value" => 641578),array("tree" => array() ,"value" => 370269)) ,"value" => 762137)) ,"value" => 303860),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 600572),array("tree" => array() ,"value" => 730677),array("tree" => array() ,"value" => 101213),array("tree" => array() ,"value" => 529556)) ,"value" => 16646),array("tree" => array(array("tree" => array() ,"value" => 23681),array("tree" => array() ,"value" => 971450),array("tree" => array() ,"value" => 484529),array("tree" => array() ,"value" => 326246)) ,"value" => 420749),array("tree" => array(array("tree" => array() ,"value" => 952218),array("tree" => array() ,"value" => 212331),array("tree" => array() ,"value" => 306087),array("tree" => array() ,"value" => 830205)) ,"value" => 154386),array("tree" => array(array("tree" => array() ,"value" => 121426),array("tree" => array() ,"value" => 740316),array("tree" => array() ,"value" => 665882),array("tree" => array() ,"value" => 208049)) ,"value" => 634667)) ,"value" => 49683),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 676897),array("tree" => array() ,"value" => 201973),array("tree" => array() ,"value" => 839996),array("tree" => array() ,"value" => 793679)) ,"value" => 290303),array("tree" => array(array("tree" => array() ,"value" => 561366),array("tree" => array() ,"value" => 344174),array("tree" => array() ,"value" => 262773),array("tree" => array() ,"value" => 933830)) ,"value" => 75148),array("tree" => array(array("tree" => array() ,"value" => 750015),array("tree" => array() ,"value" => 14764),array("tree" => array() ,"value" => 169211),array("tree" => array() ,"value" => 930212)) ,"value" => 581382),array("tree" => array(array("tree" => array() ,"value" => 493146),array("tree" => array() ,"value" => 171921),array("tree" => array() ,"value" => 173062),array("tree" => array() ,"value" => 450628)) ,"value" => 58485)) ,"value" => 436228),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 676555),array("tree" => array() ,"value" => 671941),array("tree" => array() ,"value" => 451057),array("tree" => array() ,"value" => 405404)) ,"value" => 222742),array("tree" => array(array("tree" => array() ,"value" => 990493),array("tree" => array() ,"value" => 822524),array("tree" => array() ,"value" => 805808),array("tree" => array() ,"value" => 554908)) ,"value" => 200434),array("tree" => array(array("tree" => array() ,"value" => 235453),array("tree" => array() ,"value" => 266068),array("tree" => array() ,"value" => 919543),array("tree" => array() ,"value" => 107361)) ,"value" => 363981),array("tree" => array(array("tree" => array() ,"value" => 29847),array("tree" => array() ,"value" => 307645),array("tree" => array() ,"value" => 607355),array("tree" => array() ,"value" => 967864)) ,"value" => 510929)) ,"value" => 109462)) ,"value" => 78334),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 292346),array("tree" => array() ,"value" => 581368),array("tree" => array() ,"value" => 818877),array("tree" => array() ,"value" => 929787)) ,"value" => 805631),array("tree" => array(array("tree" => array() ,"value" => 667011),array("tree" => array() ,"value" => 776551),array("tree" => array() ,"value" => 213739),array("tree" => array() ,"value" => 433101)) ,"value" => 713879),array("tree" => array(array("tree" => array() ,"value" => 406170),array("tree" => array() ,"value" => 678157),array("tree" => array() ,"value" => 622958),array("tree" => array() ,"value" => 761266)) ,"value" => 36093),array("tree" => array(array("tree" => array() ,"value" => 180676),array("tree" => array() ,"value" => 935736),array("tree" => array() ,"value" => 646423),array("tree" => array() ,"value" => 508461)) ,"value" => 798201)) ,"value" => 374776),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 166777),array("tree" => array() ,"value" => 256845),array("tree" => array() ,"value" => 175740),array("tree" => array() ,"value" => 454883)) ,"value" => 834904),array("tree" => array(array("tree" => array() ,"value" => 249863),array("tree" => array() ,"value" => 874657),array("tree" => array() ,"value" => 150859),array("tree" => array() ,"value" => 973821)) ,"value" => 132315),array("tree" => array(array("tree" => array() ,"value" => 58637),array("tree" => array() ,"value" => 702742),array("tree" => array() ,"value" => 492229),array("tree" => array() ,"value" => 969082)) ,"value" => 568279),array("tree" => array(array("tree" => array() ,"value" => 439455),array("tree" => array() ,"value" => 701675),array("tree" => array() ,"value" => 569574),array("tree" => array() ,"value" => 733539)) ,"value" => 722431)) ,"value" => 496751),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 387295),array("tree" => array() ,"value" => 77723),array("tree" => array() ,"value" => 546579),array("tree" => array() ,"value" => 334059)) ,"value" => 670064),array("tree" => array(array("tree" => array() ,"value" => 361221),array("tree" => array() ,"value" => 301636),array("tree" => array() ,"value" => 307275),array("tree" => array() ,"value" => 433507)) ,"value" => 545611),array("tree" => array(array("tree" => array() ,"value" => 220196),array("tree" => array() ,"value" => 766668),array("tree" => array() ,"value" => 271222),array("tree" => array() ,"value" => 968029)) ,"value" => 164851),array("tree" => array(array("tree" => array() ,"value" => 890963),array("tree" => array() ,"value" => 670852),array("tree" => array() ,"value" => 793181),array("tree" => array() ,"value" => 919584)) ,"value" => 299094)) ,"value" => 143166),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 654115),array("tree" => array() ,"value" => 778471),array("tree" => array() ,"value" => 119206),array("tree" => array() ,"value" => 804990)) ,"value" => 300842),array("tree" => array(array("tree" => array() ,"value" => 387151),array("tree" => array() ,"value" => 540871),array("tree" => array() ,"value" => 113967),array("tree" => array() ,"value" => 15282)) ,"value" => 110808),array("tree" => array(array("tree" => array() ,"value" => 43314),array("tree" => array() ,"value" => 103983),array("tree" => array() ,"value" => 704443),array("tree" => array() ,"value" => 56094)) ,"value" => 993031),array("tree" => array(array("tree" => array() ,"value" => 227348),array("tree" => array() ,"value" => 690498),array("tree" => array() ,"value" => 165965),array("tree" => array() ,"value" => 432536)) ,"value" => 105915)) ,"value" => 687485)) ,"value" => 954026),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 356535),array("tree" => array() ,"value" => 143690),array("tree" => array() ,"value" => 607415),array("tree" => array() ,"value" => 238104)) ,"value" => 192541),array("tree" => array(array("tree" => array() ,"value" => 524745),array("tree" => array() ,"value" => 71527),array("tree" => array() ,"value" => 396767),array("tree" => array() ,"value" => 79540)) ,"value" => 365358),array("tree" => array(array("tree" => array() ,"value" => 19682),array("tree" => array() ,"value" => 363905),array("tree" => array() ,"value" => 139461),array("tree" => array() ,"value" => 83177)) ,"value" => 699950),array("tree" => array(array("tree" => array() ,"value" => 681061),array("tree" => array() ,"value" => 356214),array("tree" => array() ,"value" => 672323),array("tree" => array() ,"value" => 261399)) ,"value" => 604015)) ,"value" => 895544),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 824743),array("tree" => array() ,"value" => 997562),array("tree" => array() ,"value" => 231089),array("tree" => array() ,"value" => 815170)) ,"value" => 632838),array("tree" => array(array("tree" => array() ,"value" => 324615),array("tree" => array() ,"value" => 118557),array("tree" => array() ,"value" => 837677),array("tree" => array() ,"value" => 961113)) ,"value" => 487750),array("tree" => array(array("tree" => array() ,"value" => 640814),array("tree" => array() ,"value" => 346728),array("tree" => array() ,"value" => 865690),array("tree" => array() ,"value" => 381864)) ,"value" => 414439),array("tree" => array(array("tree" => array() ,"value" => 967561),array("tree" => array() ,"value" => 105375),array("tree" => array() ,"value" => 170604),array("tree" => array() ,"value" => 137418)) ,"value" => 904939)) ,"value" => 346054),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 664299),array("tree" => array() ,"value" => 684371),array("tree" => array() ,"value" => 569701),array("tree" => array() ,"value" => 619581)) ,"value" => 873218),array("tree" => array(array("tree" => array() ,"value" => 223139),array("tree" => array() ,"value" => 534859),array("tree" => array() ,"value" => 904849),array("tree" => array() ,"value" => 53574)) ,"value" => 9059),array("tree" => array(array("tree" => array() ,"value" => 914368),array("tree" => array() ,"value" => 255151),array("tree" => array() ,"value" => 65702),array("tree" => array() ,"value" => 2074)) ,"value" => 330379),array("tree" => array(array("tree" => array() ,"value" => 628569),array("tree" => array() ,"value" => 275092),array("tree" => array() ,"value" => 295143),array("tree" => array() ,"value" => 382208)) ,"value" => 785290)) ,"value" => 274924),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 866330),array("tree" => array() ,"value" => 26762),array("tree" => array() ,"value" => 289958),array("tree" => array() ,"value" => 596847)) ,"value" => 437626),array("tree" => array(array("tree" => array() ,"value" => 112742),array("tree" => array() ,"value" => 176608),array("tree" => array() ,"value" => 650235),array("tree" => array() ,"value" => 618067)) ,"value" => 493755),array("tree" => array(array("tree" => array() ,"value" => 6485),array("tree" => array() ,"value" => 641292),array("tree" => array() ,"value" => 679320),array("tree" => array() ,"value" => 941806)) ,"value" => 709440),array("tree" => array(array("tree" => array() ,"value" => 561425),array("tree" => array() ,"value" => 602833),array("tree" => array() ,"value" => 311425),array("tree" => array() ,"value" => 223963)) ,"value" => 305014)) ,"value" => 191690)) ,"value" => 286516)) ,"value" => 111142)) ,"value" => 820776),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 690516),array("tree" => array() ,"value" => 970210),array("tree" => array() ,"value" => 458148),array("tree" => array() ,"value" => 436599)) ,"value" => 770461),array("tree" => array(array("tree" => array() ,"value" => 750554),array("tree" => array() ,"value" => 163152),array("tree" => array() ,"value" => 418137),array("tree" => array() ,"value" => 295906)) ,"value" => 766977),array("tree" => array(array("tree" => array() ,"value" => 624062),array("tree" => array() ,"value" => 728656),array("tree" => array() ,"value" => 767957),array("tree" => array() ,"value" => 120490)) ,"value" => 47633),array("tree" => array(array("tree" => array() ,"value" => 228997),array("tree" => array() ,"value" => 517437),array("tree" => array() ,"value" => 880976),array("tree" => array() ,"value" => 447816)) ,"value" => 97427)) ,"value" => 326855),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 457104),array("tree" => array() ,"value" => 531725),array("tree" => array() ,"value" => 342158),array("tree" => array() ,"value" => 202320)) ,"value" => 899858),array("tree" => array(array("tree" => array() ,"value" => 49927),array("tree" => array() ,"value" => 909117),array("tree" => array() ,"value" => 52403),array("tree" => array() ,"value" => 942208)) ,"value" => 91131),array("tree" => array(array("tree" => array() ,"value" => 118971),array("tree" => array() ,"value" => 259625),array("tree" => array() ,"value" => 599663),array("tree" => array() ,"value" => 529717)) ,"value" => 413949),array("tree" => array(array("tree" => array() ,"value" => 115796),array("tree" => array() ,"value" => 79312),array("tree" => array() ,"value" => 339127),array("tree" => array() ,"value" => 441083)) ,"value" => 854582)) ,"value" => 397106),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 57232),array("tree" => array() ,"value" => 886692),array("tree" => array() ,"value" => 455716),array("tree" => array() ,"value" => 135623)) ,"value" => 97516),array("tree" => array(array("tree" => array() ,"value" => 655487),array("tree" => array() ,"value" => 266035),array("tree" => array() ,"value" => 56802),array("tree" => array() ,"value" => 76077)) ,"value" => 706382),array("tree" => array(array("tree" => array() ,"value" => 646107),array("tree" => array() ,"value" => 543472),array("tree" => array() ,"value" => 175336),array("tree" => array() ,"value" => 818914)) ,"value" => 640175),array("tree" => array(array("tree" => array() ,"value" => 650348),array("tree" => array() ,"value" => 219846),array("tree" => array() ,"value" => 871229),array("tree" => array() ,"value" => 553859)) ,"value" => 940358)) ,"value" => 915012),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 606914),array("tree" => array() ,"value" => 981168),array("tree" => array() ,"value" => 650165),array("tree" => array() ,"value" => 25915)) ,"value" => 928751),array("tree" => array(array("tree" => array() ,"value" => 793170),array("tree" => array() ,"value" => 992783),array("tree" => array() ,"value" => 399065),array("tree" => array() ,"value" => 808457)) ,"value" => 671803),array("tree" => array(array("tree" => array() ,"value" => 895309),array("tree" => array() ,"value" => 995619),array("tree" => array() ,"value" => 555334),array("tree" => array() ,"value" => 782127)) ,"value" => 419408),array("tree" => array(array("tree" => array() ,"value" => 410929),array("tree" => array() ,"value" => 879279),array("tree" => array() ,"value" => 957713),array("tree" => array() ,"value" => 922549)) ,"value" => 735164)) ,"value" => 29587)) ,"value" => 33905),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 196846),array("tree" => array() ,"value" => 168467),array("tree" => array() ,"value" => 540572),array("tree" => array() ,"value" => 146260)) ,"value" => 672579),array("tree" => array(array("tree" => array() ,"value" => 743656),array("tree" => array() ,"value" => 383074),array("tree" => array() ,"value" => 363636),array("tree" => array() ,"value" => 984660)) ,"value" => 811275),array("tree" => array(array("tree" => array() ,"value" => 439844),array("tree" => array() ,"value" => 471714),array("tree" => array() ,"value" => 787255),array("tree" => array() ,"value" => 717399)) ,"value" => 91787),array("tree" => array(array("tree" => array() ,"value" => 100640),array("tree" => array() ,"value" => 4897),array("tree" => array() ,"value" => 364151),array("tree" => array() ,"value" => 187906)) ,"value" => 480441)) ,"value" => 203097),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 795453),array("tree" => array() ,"value" => 535913),array("tree" => array() ,"value" => 838628),array("tree" => array() ,"value" => 940424)) ,"value" => 398563),array("tree" => array(array("tree" => array() ,"value" => 837321),array("tree" => array() ,"value" => 235474),array("tree" => array() ,"value" => 206835),array("tree" => array() ,"value" => 220699)) ,"value" => 31912),array("tree" => array(array("tree" => array() ,"value" => 968881),array("tree" => array() ,"value" => 852496),array("tree" => array() ,"value" => 130620),array("tree" => array() ,"value" => 618393)) ,"value" => 654006),array("tree" => array(array("tree" => array() ,"value" => 559771),array("tree" => array() ,"value" => 982090),array("tree" => array() ,"value" => 46178),array("tree" => array() ,"value" => 973743)) ,"value" => 402668)) ,"value" => 852807),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 371921),array("tree" => array() ,"value" => 893084),array("tree" => array() ,"value" => 984833),array("tree" => array() ,"value" => 95587)) ,"value" => 918239),array("tree" => array(array("tree" => array() ,"value" => 668957),array("tree" => array() ,"value" => 492829),array("tree" => array() ,"value" => 25778),array("tree" => array() ,"value" => 415195)) ,"value" => 382701),array("tree" => array(array("tree" => array() ,"value" => 629623),array("tree" => array() ,"value" => 563854),array("tree" => array() ,"value" => 653431),array("tree" => array() ,"value" => 967371)) ,"value" => 719463),array("tree" => array(array("tree" => array() ,"value" => 837130),array("tree" => array() ,"value" => 764078),array("tree" => array() ,"value" => 68179),array("tree" => array() ,"value" => 635149)) ,"value" => 799997)) ,"value" => 632992),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 477133),array("tree" => array() ,"value" => 507290),array("tree" => array() ,"value" => 56106),array("tree" => array() ,"value" => 978626)) ,"value" => 286650),array("tree" => array(array("tree" => array() ,"value" => 424757),array("tree" => array() ,"value" => 593808),array("tree" => array() ,"value" => 703243),array("tree" => array() ,"value" => 72968)) ,"value" => 874106),array("tree" => array(array("tree" => array() ,"value" => 736711),array("tree" => array() ,"value" => 702037),array("tree" => array() ,"value" => 133758),array("tree" => array() ,"value" => 908823)) ,"value" => 826120),array("tree" => array(array("tree" => array() ,"value" => 953553),array("tree" => array() ,"value" => 788900),array("tree" => array() ,"value" => 156756),array("tree" => array() ,"value" => 462235)) ,"value" => 688995)) ,"value" => 503314)) ,"value" => 123101),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 553321),array("tree" => array() ,"value" => 436607),array("tree" => array() ,"value" => 229762),array("tree" => array() ,"value" => 862500)) ,"value" => 859211),array("tree" => array(array("tree" => array() ,"value" => 705764),array("tree" => array() ,"value" => 712060),array("tree" => array() ,"value" => 283058),array("tree" => array() ,"value" => 996242)) ,"value" => 227845),array("tree" => array(array("tree" => array() ,"value" => 186955),array("tree" => array() ,"value" => 518050),array("tree" => array() ,"value" => 252997),array("tree" => array() ,"value" => 236438)) ,"value" => 497169),array("tree" => array(array("tree" => array() ,"value" => 923892),array("tree" => array() ,"value" => 748335),array("tree" => array() ,"value" => 976182),array("tree" => array() ,"value" => 372357)) ,"value" => 39563)) ,"value" => 778379),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 155644),array("tree" => array() ,"value" => 646455),array("tree" => array() ,"value" => 429060),array("tree" => array() ,"value" => 226325)) ,"value" => 233403),array("tree" => array(array("tree" => array() ,"value" => 779033),array("tree" => array() ,"value" => 60963),array("tree" => array() ,"value" => 544316),array("tree" => array() ,"value" => 122421)) ,"value" => 306125),array("tree" => array(array("tree" => array() ,"value" => 875966),array("tree" => array() ,"value" => 930168),array("tree" => array() ,"value" => 188435),array("tree" => array() ,"value" => 368384)) ,"value" => 204274),array("tree" => array(array("tree" => array() ,"value" => 973493),array("tree" => array() ,"value" => 880205),array("tree" => array() ,"value" => 682560),array("tree" => array() ,"value" => 121458)) ,"value" => 652565)) ,"value" => 436210),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 779812),array("tree" => array() ,"value" => 913468),array("tree" => array() ,"value" => 253346),array("tree" => array() ,"value" => 327035)) ,"value" => 716847),array("tree" => array(array("tree" => array() ,"value" => 813051),array("tree" => array() ,"value" => 186750),array("tree" => array() ,"value" => 667249),array("tree" => array() ,"value" => 443417)) ,"value" => 770637),array("tree" => array(array("tree" => array() ,"value" => 279500),array("tree" => array() ,"value" => 101333),array("tree" => array() ,"value" => 760412),array("tree" => array() ,"value" => 130550)) ,"value" => 786114),array("tree" => array(array("tree" => array() ,"value" => 357528),array("tree" => array() ,"value" => 671660),array("tree" => array() ,"value" => 627460),array("tree" => array() ,"value" => 875405)) ,"value" => 307544)) ,"value" => 973688),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 899717),array("tree" => array() ,"value" => 507462),array("tree" => array() ,"value" => 375850),array("tree" => array() ,"value" => 166882)) ,"value" => 362109),array("tree" => array(array("tree" => array() ,"value" => 417740),array("tree" => array() ,"value" => 823880),array("tree" => array() ,"value" => 179588),array("tree" => array() ,"value" => 144941)) ,"value" => 474979),array("tree" => array(array("tree" => array() ,"value" => 800139),array("tree" => array() ,"value" => 416531),array("tree" => array() ,"value" => 683733),array("tree" => array() ,"value" => 636011)) ,"value" => 620553),array("tree" => array(array("tree" => array() ,"value" => 182645),array("tree" => array() ,"value" => 486729),array("tree" => array() ,"value" => 766641),array("tree" => array() ,"value" => 298958)) ,"value" => 202602)) ,"value" => 165161)) ,"value" => 779721),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 812889),array("tree" => array() ,"value" => 701055),array("tree" => array() ,"value" => 413042),array("tree" => array() ,"value" => 650726)) ,"value" => 174375),array("tree" => array(array("tree" => array() ,"value" => 344784),array("tree" => array() ,"value" => 808188),array("tree" => array() ,"value" => 31775),array("tree" => array() ,"value" => 819876)) ,"value" => 540397),array("tree" => array(array("tree" => array() ,"value" => 840567),array("tree" => array() ,"value" => 411528),array("tree" => array() ,"value" => 529557),array("tree" => array() ,"value" => 254052)) ,"value" => 20853),array("tree" => array(array("tree" => array() ,"value" => 548232),array("tree" => array() ,"value" => 515858),array("tree" => array() ,"value" => 278585),array("tree" => array() ,"value" => 870532)) ,"value" => 702565)) ,"value" => 589808),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 938686),array("tree" => array() ,"value" => 450955),array("tree" => array() ,"value" => 701205),array("tree" => array() ,"value" => 464230)) ,"value" => 776552),array("tree" => array(array("tree" => array() ,"value" => 643094),array("tree" => array() ,"value" => 185267),array("tree" => array() ,"value" => 278265),array("tree" => array() ,"value" => 922527)) ,"value" => 63597),array("tree" => array(array("tree" => array() ,"value" => 400490),array("tree" => array() ,"value" => 450907),array("tree" => array() ,"value" => 118060),array("tree" => array() ,"value" => 308857)) ,"value" => 235569),array("tree" => array(array("tree" => array() ,"value" => 799263),array("tree" => array() ,"value" => 644962),array("tree" => array() ,"value" => 534571),array("tree" => array() ,"value" => 965884)) ,"value" => 639201)) ,"value" => 137489),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 201177),array("tree" => array() ,"value" => 192550),array("tree" => array() ,"value" => 706527),array("tree" => array() ,"value" => 818074)) ,"value" => 606552),array("tree" => array(array("tree" => array() ,"value" => 67955),array("tree" => array() ,"value" => 266163),array("tree" => array() ,"value" => 716258),array("tree" => array() ,"value" => 642276)) ,"value" => 478652),array("tree" => array(array("tree" => array() ,"value" => 264215),array("tree" => array() ,"value" => 663785),array("tree" => array() ,"value" => 89832),array("tree" => array() ,"value" => 806048)) ,"value" => 516492),array("tree" => array(array("tree" => array() ,"value" => 399743),array("tree" => array() ,"value" => 777560),array("tree" => array() ,"value" => 361834),array("tree" => array() ,"value" => 392575)) ,"value" => 224349)) ,"value" => 246866),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 428165),array("tree" => array() ,"value" => 698856),array("tree" => array() ,"value" => 252473),array("tree" => array() ,"value" => 835198)) ,"value" => 719323),array("tree" => array(array("tree" => array() ,"value" => 274364),array("tree" => array() ,"value" => 810359),array("tree" => array() ,"value" => 448376),array("tree" => array() ,"value" => 1845)) ,"value" => 976374),array("tree" => array(array("tree" => array() ,"value" => 504717),array("tree" => array() ,"value" => 28764),array("tree" => array() ,"value" => 569077),array("tree" => array() ,"value" => 573435)) ,"value" => 587135),array("tree" => array(array("tree" => array() ,"value" => 797039),array("tree" => array() ,"value" => 458014),array("tree" => array() ,"value" => 640366),array("tree" => array() ,"value" => 972568)) ,"value" => 48380)) ,"value" => 637736)) ,"value" => 845428)) ,"value" => 737344),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 21247),array("tree" => array() ,"value" => 848854),array("tree" => array() ,"value" => 577098),array("tree" => array() ,"value" => 231311)) ,"value" => 629336),array("tree" => array(array("tree" => array() ,"value" => 739231),array("tree" => array() ,"value" => 19219),array("tree" => array() ,"value" => 784568),array("tree" => array() ,"value" => 523322)) ,"value" => 190931),array("tree" => array(array("tree" => array() ,"value" => 402221),array("tree" => array() ,"value" => 527051),array("tree" => array() ,"value" => 719614),array("tree" => array() ,"value" => 932458)) ,"value" => 811480),array("tree" => array(array("tree" => array() ,"value" => 674249),array("tree" => array() ,"value" => 628239),array("tree" => array() ,"value" => 572266),array("tree" => array() ,"value" => 726119)) ,"value" => 848008)) ,"value" => 388654),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 831946),array("tree" => array() ,"value" => 292279),array("tree" => array() ,"value" => 439117),array("tree" => array() ,"value" => 731514)) ,"value" => 600583),array("tree" => array(array("tree" => array() ,"value" => 363554),array("tree" => array() ,"value" => 576648),array("tree" => array() ,"value" => 76931),array("tree" => array() ,"value" => 937107)) ,"value" => 134184),array("tree" => array(array("tree" => array() ,"value" => 221301),array("tree" => array() ,"value" => 259901),array("tree" => array() ,"value" => 464510),array("tree" => array() ,"value" => 991623)) ,"value" => 348041),array("tree" => array(array("tree" => array() ,"value" => 369310),array("tree" => array() ,"value" => 436209),array("tree" => array() ,"value" => 118442),array("tree" => array() ,"value" => 582349)) ,"value" => 421392)) ,"value" => 701788),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 648704),array("tree" => array() ,"value" => 538340),array("tree" => array() ,"value" => 216402),array("tree" => array() ,"value" => 906926)) ,"value" => 991922),array("tree" => array(array("tree" => array() ,"value" => 898281),array("tree" => array() ,"value" => 997694),array("tree" => array() ,"value" => 230261),array("tree" => array() ,"value" => 826943)) ,"value" => 662391),array("tree" => array(array("tree" => array() ,"value" => 367686),array("tree" => array() ,"value" => 929683),array("tree" => array() ,"value" => 491846),array("tree" => array() ,"value" => 379562)) ,"value" => 271563),array("tree" => array(array("tree" => array() ,"value" => 554549),array("tree" => array() ,"value" => 128119),array("tree" => array() ,"value" => 610853),array("tree" => array() ,"value" => 79987)) ,"value" => 312695)) ,"value" => 108105),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 68593),array("tree" => array() ,"value" => 254375),array("tree" => array() ,"value" => 631659),array("tree" => array() ,"value" => 785444)) ,"value" => 874059),array("tree" => array(array("tree" => array() ,"value" => 8755),array("tree" => array() ,"value" => 496278),array("tree" => array() ,"value" => 924393),array("tree" => array() ,"value" => 783504)) ,"value" => 342883),array("tree" => array(array("tree" => array() ,"value" => 509453),array("tree" => array() ,"value" => 855776),array("tree" => array() ,"value" => 878072),array("tree" => array() ,"value" => 488561)) ,"value" => 46988),array("tree" => array(array("tree" => array() ,"value" => 113300),array("tree" => array() ,"value" => 73357),array("tree" => array() ,"value" => 405102),array("tree" => array() ,"value" => 215677)) ,"value" => 346998)) ,"value" => 451290)) ,"value" => 914811),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 230385),array("tree" => array() ,"value" => 761187),array("tree" => array() ,"value" => 114152),array("tree" => array() ,"value" => 393515)) ,"value" => 739389),array("tree" => array(array("tree" => array() ,"value" => 886223),array("tree" => array() ,"value" => 375652),array("tree" => array() ,"value" => 356420),array("tree" => array() ,"value" => 875922)) ,"value" => 460911),array("tree" => array(array("tree" => array() ,"value" => 118886),array("tree" => array() ,"value" => 105703),array("tree" => array() ,"value" => 265757),array("tree" => array() ,"value" => 110326)) ,"value" => 291103),array("tree" => array(array("tree" => array() ,"value" => 446916),array("tree" => array() ,"value" => 937846),array("tree" => array() ,"value" => 195336),array("tree" => array() ,"value" => 23347)) ,"value" => 698456)) ,"value" => 204034),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 419836),array("tree" => array() ,"value" => 974523),array("tree" => array() ,"value" => 518711),array("tree" => array() ,"value" => 113779)) ,"value" => 667120),array("tree" => array(array("tree" => array() ,"value" => 547105),array("tree" => array() ,"value" => 47971),array("tree" => array() ,"value" => 389909),array("tree" => array() ,"value" => 189647)) ,"value" => 739616),array("tree" => array(array("tree" => array() ,"value" => 751338),array("tree" => array() ,"value" => 450427),array("tree" => array() ,"value" => 239506),array("tree" => array() ,"value" => 833957)) ,"value" => 563599),array("tree" => array(array("tree" => array() ,"value" => 323773),array("tree" => array() ,"value" => 519942),array("tree" => array() ,"value" => 130211),array("tree" => array() ,"value" => 443498)) ,"value" => 566448)) ,"value" => 47645),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 414111),array("tree" => array() ,"value" => 181703),array("tree" => array() ,"value" => 543966),array("tree" => array() ,"value" => 696955)) ,"value" => 576190),array("tree" => array(array("tree" => array() ,"value" => 151658),array("tree" => array() ,"value" => 213789),array("tree" => array() ,"value" => 225670),array("tree" => array() ,"value" => 50885)) ,"value" => 121079),array("tree" => array(array("tree" => array() ,"value" => 625030),array("tree" => array() ,"value" => 225107),array("tree" => array() ,"value" => 77321),array("tree" => array() ,"value" => 422029)) ,"value" => 82414),array("tree" => array(array("tree" => array() ,"value" => 953916),array("tree" => array() ,"value" => 491862),array("tree" => array() ,"value" => 61869),array("tree" => array() ,"value" => 113560)) ,"value" => 95505)) ,"value" => 235356),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 10429),array("tree" => array() ,"value" => 866967),array("tree" => array() ,"value" => 81526),array("tree" => array() ,"value" => 526400)) ,"value" => 556875),array("tree" => array(array("tree" => array() ,"value" => 860820),array("tree" => array() ,"value" => 208061),array("tree" => array() ,"value" => 371238),array("tree" => array() ,"value" => 222338)) ,"value" => 439798),array("tree" => array(array("tree" => array() ,"value" => 431780),array("tree" => array() ,"value" => 495412),array("tree" => array() ,"value" => 315847),array("tree" => array() ,"value" => 36344)) ,"value" => 153533),array("tree" => array(array("tree" => array() ,"value" => 706085),array("tree" => array() ,"value" => 850976),array("tree" => array() ,"value" => 597258),array("tree" => array() ,"value" => 317275)) ,"value" => 331398)) ,"value" => 579577)) ,"value" => 48853),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 115490),array("tree" => array() ,"value" => 780637),array("tree" => array() ,"value" => 754632),array("tree" => array() ,"value" => 480786)) ,"value" => 395167),array("tree" => array(array("tree" => array() ,"value" => 470951),array("tree" => array() ,"value" => 176317),array("tree" => array() ,"value" => 227402),array("tree" => array() ,"value" => 556234)) ,"value" => 503166),array("tree" => array(array("tree" => array() ,"value" => 560115),array("tree" => array() ,"value" => 497502),array("tree" => array() ,"value" => 130442),array("tree" => array() ,"value" => 708480)) ,"value" => 384000),array("tree" => array(array("tree" => array() ,"value" => 293718),array("tree" => array() ,"value" => 858084),array("tree" => array() ,"value" => 739031),array("tree" => array() ,"value" => 848845)) ,"value" => 741671)) ,"value" => 228930),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 256448),array("tree" => array() ,"value" => 602472),array("tree" => array() ,"value" => 366105),array("tree" => array() ,"value" => 843245)) ,"value" => 840105),array("tree" => array(array("tree" => array() ,"value" => 815902),array("tree" => array() ,"value" => 342105),array("tree" => array() ,"value" => 693973),array("tree" => array() ,"value" => 250241)) ,"value" => 719367),array("tree" => array(array("tree" => array() ,"value" => 974744),array("tree" => array() ,"value" => 551894),array("tree" => array() ,"value" => 603025),array("tree" => array() ,"value" => 226175)) ,"value" => 242440),array("tree" => array(array("tree" => array() ,"value" => 806469),array("tree" => array() ,"value" => 320555),array("tree" => array() ,"value" => 450321),array("tree" => array() ,"value" => 555096)) ,"value" => 633097)) ,"value" => 506116),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 739882),array("tree" => array() ,"value" => 304352),array("tree" => array() ,"value" => 378850),array("tree" => array() ,"value" => 642237)) ,"value" => 266065),array("tree" => array(array("tree" => array() ,"value" => 609743),array("tree" => array() ,"value" => 760129),array("tree" => array() ,"value" => 640186),array("tree" => array() ,"value" => 61382)) ,"value" => 965846),array("tree" => array(array("tree" => array() ,"value" => 435761),array("tree" => array() ,"value" => 119455),array("tree" => array() ,"value" => 21197),array("tree" => array() ,"value" => 190071)) ,"value" => 569074),array("tree" => array(array("tree" => array() ,"value" => 496123),array("tree" => array() ,"value" => 763471),array("tree" => array() ,"value" => 135538),array("tree" => array() ,"value" => 875987)) ,"value" => 720441)) ,"value" => 498277),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 642570),array("tree" => array() ,"value" => 856089),array("tree" => array() ,"value" => 344217),array("tree" => array() ,"value" => 686475)) ,"value" => 980735),array("tree" => array(array("tree" => array() ,"value" => 522057),array("tree" => array() ,"value" => 615564),array("tree" => array() ,"value" => 869926),array("tree" => array() ,"value" => 621736)) ,"value" => 70836),array("tree" => array(array("tree" => array() ,"value" => 629987),array("tree" => array() ,"value" => 744763),array("tree" => array() ,"value" => 446796),array("tree" => array() ,"value" => 328834)) ,"value" => 19632),array("tree" => array(array("tree" => array() ,"value" => 573945),array("tree" => array() ,"value" => 731682),array("tree" => array() ,"value" => 254211),array("tree" => array() ,"value" => 983803)) ,"value" => 525124)) ,"value" => 92842)) ,"value" => 200278),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 597410),array("tree" => array() ,"value" => 768761),array("tree" => array() ,"value" => 581984),array("tree" => array() ,"value" => 392233)) ,"value" => 5325),array("tree" => array(array("tree" => array() ,"value" => 657202),array("tree" => array() ,"value" => 482718),array("tree" => array() ,"value" => 519833),array("tree" => array() ,"value" => 929495)) ,"value" => 456729),array("tree" => array(array("tree" => array() ,"value" => 610401),array("tree" => array() ,"value" => 706217),array("tree" => array() ,"value" => 827059),array("tree" => array() ,"value" => 78732)) ,"value" => 774025),array("tree" => array(array("tree" => array() ,"value" => 942474),array("tree" => array() ,"value" => 387392),array("tree" => array() ,"value" => 357784),array("tree" => array() ,"value" => 208496)) ,"value" => 420041)) ,"value" => 486386),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 871211),array("tree" => array() ,"value" => 139220),array("tree" => array() ,"value" => 660764),array("tree" => array() ,"value" => 305265)) ,"value" => 276885),array("tree" => array(array("tree" => array() ,"value" => 541186),array("tree" => array() ,"value" => 33343),array("tree" => array() ,"value" => 888812),array("tree" => array() ,"value" => 607530)) ,"value" => 91924),array("tree" => array(array("tree" => array() ,"value" => 892681),array("tree" => array() ,"value" => 407963),array("tree" => array() ,"value" => 587824),array("tree" => array() ,"value" => 524973)) ,"value" => 794945),array("tree" => array(array("tree" => array() ,"value" => 58573),array("tree" => array() ,"value" => 802041),array("tree" => array() ,"value" => 986536),array("tree" => array() ,"value" => 906905)) ,"value" => 976946)) ,"value" => 434269),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 372210),array("tree" => array() ,"value" => 495550),array("tree" => array() ,"value" => 783643),array("tree" => array() ,"value" => 715565)) ,"value" => 76236),array("tree" => array(array("tree" => array() ,"value" => 668590),array("tree" => array() ,"value" => 295225),array("tree" => array() ,"value" => 613280),array("tree" => array() ,"value" => 319350)) ,"value" => 893164),array("tree" => array(array("tree" => array() ,"value" => 688462),array("tree" => array() ,"value" => 349961),array("tree" => array() ,"value" => 212270),array("tree" => array() ,"value" => 333468)) ,"value" => 239259),array("tree" => array(array("tree" => array() ,"value" => 68305),array("tree" => array() ,"value" => 825499),array("tree" => array() ,"value" => 290831),array("tree" => array() ,"value" => 377836)) ,"value" => 64707)) ,"value" => 248423),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 441097),array("tree" => array() ,"value" => 50031),array("tree" => array() ,"value" => 574281),array("tree" => array() ,"value" => 506246)) ,"value" => 863345),array("tree" => array(array("tree" => array() ,"value" => 585575),array("tree" => array() ,"value" => 227424),array("tree" => array() ,"value" => 832819),array("tree" => array() ,"value" => 709108)) ,"value" => 92990),array("tree" => array(array("tree" => array() ,"value" => 753021),array("tree" => array() ,"value" => 523973),array("tree" => array() ,"value" => 695790),array("tree" => array() ,"value" => 126875)) ,"value" => 155310),array("tree" => array(array("tree" => array() ,"value" => 665438),array("tree" => array() ,"value" => 874299),array("tree" => array() ,"value" => 337436),array("tree" => array() ,"value" => 8613)) ,"value" => 675529)) ,"value" => 181939)) ,"value" => 716569)) ,"value" => 300812),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 971900),array("tree" => array() ,"value" => 999939),array("tree" => array() ,"value" => 294371),array("tree" => array() ,"value" => 653288)) ,"value" => 325815),array("tree" => array(array("tree" => array() ,"value" => 462519),array("tree" => array() ,"value" => 880447),array("tree" => array() ,"value" => 270348),array("tree" => array() ,"value" => 105742)) ,"value" => 754084),array("tree" => array(array("tree" => array() ,"value" => 725883),array("tree" => array() ,"value" => 89329),array("tree" => array() ,"value" => 411458),array("tree" => array() ,"value" => 713542)) ,"value" => 785953),array("tree" => array(array("tree" => array() ,"value" => 952781),array("tree" => array() ,"value" => 146767),array("tree" => array() ,"value" => 266726),array("tree" => array() ,"value" => 848551)) ,"value" => 247577)) ,"value" => 852107),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 648968),array("tree" => array() ,"value" => 593452),array("tree" => array() ,"value" => 755359),array("tree" => array() ,"value" => 452712)) ,"value" => 448730),array("tree" => array(array("tree" => array() ,"value" => 794071),array("tree" => array() ,"value" => 838290),array("tree" => array() ,"value" => 938025),array("tree" => array() ,"value" => 826696)) ,"value" => 946561),array("tree" => array(array("tree" => array() ,"value" => 636397),array("tree" => array() ,"value" => 366731),array("tree" => array() ,"value" => 200524),array("tree" => array() ,"value" => 295535)) ,"value" => 931221),array("tree" => array(array("tree" => array() ,"value" => 56228),array("tree" => array() ,"value" => 123817),array("tree" => array() ,"value" => 579951),array("tree" => array() ,"value" => 268516)) ,"value" => 233039)) ,"value" => 689052),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 790925),array("tree" => array() ,"value" => 99505),array("tree" => array() ,"value" => 725161),array("tree" => array() ,"value" => 30576)) ,"value" => 964233),array("tree" => array(array("tree" => array() ,"value" => 187438),array("tree" => array() ,"value" => 989044),array("tree" => array() ,"value" => 208353),array("tree" => array() ,"value" => 213432)) ,"value" => 290008),array("tree" => array(array("tree" => array() ,"value" => 146227),array("tree" => array() ,"value" => 38083),array("tree" => array() ,"value" => 589855),array("tree" => array() ,"value" => 511735)) ,"value" => 975951),array("tree" => array(array("tree" => array() ,"value" => 310417),array("tree" => array() ,"value" => 156484),array("tree" => array() ,"value" => 365552),array("tree" => array() ,"value" => 377131)) ,"value" => 908573)) ,"value" => 691274),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 33187),array("tree" => array() ,"value" => 136935),array("tree" => array() ,"value" => 811441),array("tree" => array() ,"value" => 679022)) ,"value" => 665380),array("tree" => array(array("tree" => array() ,"value" => 382353),array("tree" => array() ,"value" => 233778),array("tree" => array() ,"value" => 643903),array("tree" => array() ,"value" => 590237)) ,"value" => 408528),array("tree" => array(array("tree" => array() ,"value" => 235957),array("tree" => array() ,"value" => 604741),array("tree" => array() ,"value" => 200617),array("tree" => array() ,"value" => 954865)) ,"value" => 236671),array("tree" => array(array("tree" => array() ,"value" => 271481),array("tree" => array() ,"value" => 855315),array("tree" => array() ,"value" => 786338),array("tree" => array() ,"value" => 161555)) ,"value" => 551043)) ,"value" => 482972)) ,"value" => 399775),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 16430),array("tree" => array() ,"value" => 873690),array("tree" => array() ,"value" => 592776),array("tree" => array() ,"value" => 46680)) ,"value" => 809939),array("tree" => array(array("tree" => array() ,"value" => 103),array("tree" => array() ,"value" => 567990),array("tree" => array() ,"value" => 948954),array("tree" => array() ,"value" => 70770)) ,"value" => 340191),array("tree" => array(array("tree" => array() ,"value" => 894058),array("tree" => array() ,"value" => 272652),array("tree" => array() ,"value" => 741794),array("tree" => array() ,"value" => 317993)) ,"value" => 685428),array("tree" => array(array("tree" => array() ,"value" => 709823),array("tree" => array() ,"value" => 5532),array("tree" => array() ,"value" => 25293),array("tree" => array() ,"value" => 59322)) ,"value" => 652912)) ,"value" => 93236),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 347751),array("tree" => array() ,"value" => 439029),array("tree" => array() ,"value" => 882546),array("tree" => array() ,"value" => 175600)) ,"value" => 897853),array("tree" => array(array("tree" => array() ,"value" => 981568),array("tree" => array() ,"value" => 66678),array("tree" => array() ,"value" => 974999),array("tree" => array() ,"value" => 871579)) ,"value" => 908728),array("tree" => array(array("tree" => array() ,"value" => 254689),array("tree" => array() ,"value" => 118094),array("tree" => array() ,"value" => 619703),array("tree" => array() ,"value" => 414175)) ,"value" => 826960),array("tree" => array(array("tree" => array() ,"value" => 835958),array("tree" => array() ,"value" => 137341),array("tree" => array() ,"value" => 975336),array("tree" => array() ,"value" => 703220)) ,"value" => 409382)) ,"value" => 157204),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 890227),array("tree" => array() ,"value" => 655270),array("tree" => array() ,"value" => 73593),array("tree" => array() ,"value" => 820388)) ,"value" => 179400),array("tree" => array(array("tree" => array() ,"value" => 999102),array("tree" => array() ,"value" => 831988),array("tree" => array() ,"value" => 340375),array("tree" => array() ,"value" => 998413)) ,"value" => 335333),array("tree" => array(array("tree" => array() ,"value" => 334439),array("tree" => array() ,"value" => 23630),array("tree" => array() ,"value" => 285231),array("tree" => array() ,"value" => 455097)) ,"value" => 855600),array("tree" => array(array("tree" => array() ,"value" => 685293),array("tree" => array() ,"value" => 168262),array("tree" => array() ,"value" => 100279),array("tree" => array() ,"value" => 143802)) ,"value" => 244296)) ,"value" => 224196),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 796807),array("tree" => array() ,"value" => 269273),array("tree" => array() ,"value" => 346749),array("tree" => array() ,"value" => 842109)) ,"value" => 648449),array("tree" => array(array("tree" => array() ,"value" => 621201),array("tree" => array() ,"value" => 48256),array("tree" => array() ,"value" => 34994),array("tree" => array() ,"value" => 347240)) ,"value" => 207857),array("tree" => array(array("tree" => array() ,"value" => 17372),array("tree" => array() ,"value" => 998097),array("tree" => array() ,"value" => 592657),array("tree" => array() ,"value" => 231782)) ,"value" => 896283),array("tree" => array(array("tree" => array() ,"value" => 423200),array("tree" => array() ,"value" => 511662),array("tree" => array() ,"value" => 901693),array("tree" => array() ,"value" => 858269)) ,"value" => 811600)) ,"value" => 311369)) ,"value" => 780293),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 938943),array("tree" => array() ,"value" => 100949),array("tree" => array() ,"value" => 591805),array("tree" => array() ,"value" => 158116)) ,"value" => 922740),array("tree" => array(array("tree" => array() ,"value" => 366872),array("tree" => array() ,"value" => 657705),array("tree" => array() ,"value" => 710794),array("tree" => array() ,"value" => 924513)) ,"value" => 486505),array("tree" => array(array("tree" => array() ,"value" => 297716),array("tree" => array() ,"value" => 380205),array("tree" => array() ,"value" => 968647),array("tree" => array() ,"value" => 824179)) ,"value" => 792413),array("tree" => array(array("tree" => array() ,"value" => 736727),array("tree" => array() ,"value" => 661724),array("tree" => array() ,"value" => 226208),array("tree" => array() ,"value" => 594225)) ,"value" => 624179)) ,"value" => 496829),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 321807),array("tree" => array() ,"value" => 378161),array("tree" => array() ,"value" => 786579),array("tree" => array() ,"value" => 611889)) ,"value" => 506836),array("tree" => array(array("tree" => array() ,"value" => 933124),array("tree" => array() ,"value" => 647484),array("tree" => array() ,"value" => 447108),array("tree" => array() ,"value" => 547324)) ,"value" => 145930),array("tree" => array(array("tree" => array() ,"value" => 53787),array("tree" => array() ,"value" => 654486),array("tree" => array() ,"value" => 824541),array("tree" => array() ,"value" => 403940)) ,"value" => 798718),array("tree" => array(array("tree" => array() ,"value" => 749061),array("tree" => array() ,"value" => 589674),array("tree" => array() ,"value" => 431792),array("tree" => array() ,"value" => 921206)) ,"value" => 27152)) ,"value" => 815682),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 527000),array("tree" => array() ,"value" => 418594),array("tree" => array() ,"value" => 347352),array("tree" => array() ,"value" => 79084)) ,"value" => 338175),array("tree" => array(array("tree" => array() ,"value" => 780898),array("tree" => array() ,"value" => 274102),array("tree" => array() ,"value" => 217071),array("tree" => array() ,"value" => 510807)) ,"value" => 524124),array("tree" => array(array("tree" => array() ,"value" => 571644),array("tree" => array() ,"value" => 332605),array("tree" => array() ,"value" => 753922),array("tree" => array() ,"value" => 943759)) ,"value" => 971256),array("tree" => array(array("tree" => array() ,"value" => 229928),array("tree" => array() ,"value" => 537367),array("tree" => array() ,"value" => 217449),array("tree" => array() ,"value" => 349500)) ,"value" => 787057)) ,"value" => 208316),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 494509),array("tree" => array() ,"value" => 235145),array("tree" => array() ,"value" => 847747),array("tree" => array() ,"value" => 764199)) ,"value" => 179280),array("tree" => array(array("tree" => array() ,"value" => 995730),array("tree" => array() ,"value" => 213527),array("tree" => array() ,"value" => 924412),array("tree" => array() ,"value" => 908125)) ,"value" => 37246),array("tree" => array(array("tree" => array() ,"value" => 975828),array("tree" => array() ,"value" => 279770),array("tree" => array() ,"value" => 93480),array("tree" => array() ,"value" => 450274)) ,"value" => 600514),array("tree" => array(array("tree" => array() ,"value" => 135832),array("tree" => array() ,"value" => 84858),array("tree" => array() ,"value" => 200353),array("tree" => array() ,"value" => 871715)) ,"value" => 33380)) ,"value" => 234394)) ,"value" => 666758),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 498556),array("tree" => array() ,"value" => 390100),array("tree" => array() ,"value" => 317770),array("tree" => array() ,"value" => 529108)) ,"value" => 731969),array("tree" => array(array("tree" => array() ,"value" => 296925),array("tree" => array() ,"value" => 908739),array("tree" => array() ,"value" => 497907),array("tree" => array() ,"value" => 196967)) ,"value" => 4557),array("tree" => array(array("tree" => array() ,"value" => 706339),array("tree" => array() ,"value" => 795795),array("tree" => array() ,"value" => 38597),array("tree" => array() ,"value" => 316771)) ,"value" => 198047),array("tree" => array(array("tree" => array() ,"value" => 420108),array("tree" => array() ,"value" => 708678),array("tree" => array() ,"value" => 691315),array("tree" => array() ,"value" => 256601)) ,"value" => 80857)) ,"value" => 99573),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 956050),array("tree" => array() ,"value" => 563772),array("tree" => array() ,"value" => 178923),array("tree" => array() ,"value" => 62862)) ,"value" => 529832),array("tree" => array(array("tree" => array() ,"value" => 178129),array("tree" => array() ,"value" => 634945),array("tree" => array() ,"value" => 102412),array("tree" => array() ,"value" => 948234)) ,"value" => 299348),array("tree" => array(array("tree" => array() ,"value" => 292107),array("tree" => array() ,"value" => 145291),array("tree" => array() ,"value" => 536804),array("tree" => array() ,"value" => 92436)) ,"value" => 893300),array("tree" => array(array("tree" => array() ,"value" => 550821),array("tree" => array() ,"value" => 862870),array("tree" => array() ,"value" => 916095),array("tree" => array() ,"value" => 18525)) ,"value" => 515483)) ,"value" => 34168),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 546776),array("tree" => array() ,"value" => 268219),array("tree" => array() ,"value" => 498685),array("tree" => array() ,"value" => 540657)) ,"value" => 150524),array("tree" => array(array("tree" => array() ,"value" => 580984),array("tree" => array() ,"value" => 262244),array("tree" => array() ,"value" => 755077),array("tree" => array() ,"value" => 67365)) ,"value" => 355474),array("tree" => array(array("tree" => array() ,"value" => 624979),array("tree" => array() ,"value" => 988893),array("tree" => array() ,"value" => 576059),array("tree" => array() ,"value" => 882782)) ,"value" => 552097),array("tree" => array(array("tree" => array() ,"value" => 375890),array("tree" => array() ,"value" => 268285),array("tree" => array() ,"value" => 918915),array("tree" => array() ,"value" => 546505)) ,"value" => 383294)) ,"value" => 659609),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 617941),array("tree" => array() ,"value" => 857865),array("tree" => array() ,"value" => 229671),array("tree" => array() ,"value" => 386398)) ,"value" => 338810),array("tree" => array(array("tree" => array() ,"value" => 346736),array("tree" => array() ,"value" => 305467),array("tree" => array() ,"value" => 13030),array("tree" => array() ,"value" => 411974)) ,"value" => 126847),array("tree" => array(array("tree" => array() ,"value" => 843264),array("tree" => array() ,"value" => 974768),array("tree" => array() ,"value" => 855369),array("tree" => array() ,"value" => 871576)) ,"value" => 410803),array("tree" => array(array("tree" => array() ,"value" => 365993),array("tree" => array() ,"value" => 939688),array("tree" => array() ,"value" => 73580),array("tree" => array() ,"value" => 382514)) ,"value" => 621214)) ,"value" => 402815)) ,"value" => 206057)) ,"value" => 961403),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 468196),array("tree" => array() ,"value" => 388059),array("tree" => array() ,"value" => 965010),array("tree" => array() ,"value" => 834747)) ,"value" => 779397),array("tree" => array(array("tree" => array() ,"value" => 273956),array("tree" => array() ,"value" => 910677),array("tree" => array() ,"value" => 629976),array("tree" => array() ,"value" => 293654)) ,"value" => 483911),array("tree" => array(array("tree" => array() ,"value" => 305848),array("tree" => array() ,"value" => 317575),array("tree" => array() ,"value" => 656434),array("tree" => array() ,"value" => 829625)) ,"value" => 647969),array("tree" => array(array("tree" => array() ,"value" => 951003),array("tree" => array() ,"value" => 688085),array("tree" => array() ,"value" => 558905),array("tree" => array() ,"value" => 792280)) ,"value" => 627791)) ,"value" => 901377),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 354193),array("tree" => array() ,"value" => 196665),array("tree" => array() ,"value" => 884620),array("tree" => array() ,"value" => 546269)) ,"value" => 57655),array("tree" => array(array("tree" => array() ,"value" => 969280),array("tree" => array() ,"value" => 210778),array("tree" => array() ,"value" => 520518),array("tree" => array() ,"value" => 313277)) ,"value" => 526990),array("tree" => array(array("tree" => array() ,"value" => 342396),array("tree" => array() ,"value" => 237483),array("tree" => array() ,"value" => 702487),array("tree" => array() ,"value" => 299018)) ,"value" => 467248),array("tree" => array(array("tree" => array() ,"value" => 603708),array("tree" => array() ,"value" => 340634),array("tree" => array() ,"value" => 487794),array("tree" => array() ,"value" => 682787)) ,"value" => 82269)) ,"value" => 923417),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 173923),array("tree" => array() ,"value" => 46644),array("tree" => array() ,"value" => 353186),array("tree" => array() ,"value" => 240586)) ,"value" => 309451),array("tree" => array(array("tree" => array() ,"value" => 808564),array("tree" => array() ,"value" => 11968),array("tree" => array() ,"value" => 683843),array("tree" => array() ,"value" => 178332)) ,"value" => 75979),array("tree" => array(array("tree" => array() ,"value" => 394357),array("tree" => array() ,"value" => 734824),array("tree" => array() ,"value" => 531671),array("tree" => array() ,"value" => 640)) ,"value" => 869024),array("tree" => array(array("tree" => array() ,"value" => 188005),array("tree" => array() ,"value" => 588794),array("tree" => array() ,"value" => 914738),array("tree" => array() ,"value" => 625619)) ,"value" => 506254)) ,"value" => 212523),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 291458),array("tree" => array() ,"value" => 467573),array("tree" => array() ,"value" => 409331),array("tree" => array() ,"value" => 460846)) ,"value" => 848033),array("tree" => array(array("tree" => array() ,"value" => 697977),array("tree" => array() ,"value" => 959820),array("tree" => array() ,"value" => 396701),array("tree" => array() ,"value" => 597344)) ,"value" => 613650),array("tree" => array(array("tree" => array() ,"value" => 641210),array("tree" => array() ,"value" => 746860),array("tree" => array() ,"value" => 877850),array("tree" => array() ,"value" => 508177)) ,"value" => 158839),array("tree" => array(array("tree" => array() ,"value" => 395292),array("tree" => array() ,"value" => 468388),array("tree" => array() ,"value" => 676729),array("tree" => array() ,"value" => 32264)) ,"value" => 416827)) ,"value" => 796001)) ,"value" => 667841),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 933669),array("tree" => array() ,"value" => 799681),array("tree" => array() ,"value" => 113768),array("tree" => array() ,"value" => 159986)) ,"value" => 187431),array("tree" => array(array("tree" => array() ,"value" => 717121),array("tree" => array() ,"value" => 655155),array("tree" => array() ,"value" => 225621),array("tree" => array() ,"value" => 556874)) ,"value" => 854469),array("tree" => array(array("tree" => array() ,"value" => 486052),array("tree" => array() ,"value" => 201844),array("tree" => array() ,"value" => 842893),array("tree" => array() ,"value" => 281326)) ,"value" => 630129),array("tree" => array(array("tree" => array() ,"value" => 700857),array("tree" => array() ,"value" => 470209),array("tree" => array() ,"value" => 755673),array("tree" => array() ,"value" => 404568)) ,"value" => 827138)) ,"value" => 304095),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 434692),array("tree" => array() ,"value" => 243390),array("tree" => array() ,"value" => 295237),array("tree" => array() ,"value" => 235879)) ,"value" => 592307),array("tree" => array(array("tree" => array() ,"value" => 902085),array("tree" => array() ,"value" => 727507),array("tree" => array() ,"value" => 873713),array("tree" => array() ,"value" => 615760)) ,"value" => 63397),array("tree" => array(array("tree" => array() ,"value" => 40370),array("tree" => array() ,"value" => 712758),array("tree" => array() ,"value" => 521392),array("tree" => array() ,"value" => 189614)) ,"value" => 358815),array("tree" => array(array("tree" => array() ,"value" => 602228),array("tree" => array() ,"value" => 42647),array("tree" => array() ,"value" => 7075),array("tree" => array() ,"value" => 124026)) ,"value" => 933158)) ,"value" => 671465),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 443059),array("tree" => array() ,"value" => 581630),array("tree" => array() ,"value" => 38412),array("tree" => array() ,"value" => 76132)) ,"value" => 896525),array("tree" => array(array("tree" => array() ,"value" => 293336),array("tree" => array() ,"value" => 50173),array("tree" => array() ,"value" => 991076),array("tree" => array() ,"value" => 373692)) ,"value" => 649862),array("tree" => array(array("tree" => array() ,"value" => 507658),array("tree" => array() ,"value" => 466365),array("tree" => array() ,"value" => 705528),array("tree" => array() ,"value" => 697774)) ,"value" => 780187),array("tree" => array(array("tree" => array() ,"value" => 468271),array("tree" => array() ,"value" => 355488),array("tree" => array() ,"value" => 517570),array("tree" => array() ,"value" => 872037)) ,"value" => 45485)) ,"value" => 540031),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 856090),array("tree" => array() ,"value" => 118769),array("tree" => array() ,"value" => 164699),array("tree" => array() ,"value" => 770757)) ,"value" => 648949),array("tree" => array(array("tree" => array() ,"value" => 117789),array("tree" => array() ,"value" => 395973),array("tree" => array() ,"value" => 580577),array("tree" => array() ,"value" => 268229)) ,"value" => 57478),array("tree" => array(array("tree" => array() ,"value" => 190746),array("tree" => array() ,"value" => 693722),array("tree" => array() ,"value" => 769972),array("tree" => array() ,"value" => 451011)) ,"value" => 33326),array("tree" => array(array("tree" => array() ,"value" => 724189),array("tree" => array() ,"value" => 920725),array("tree" => array() ,"value" => 456767),array("tree" => array() ,"value" => 553194)) ,"value" => 126528)) ,"value" => 245113)) ,"value" => 888964),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 49999),array("tree" => array() ,"value" => 603111),array("tree" => array() ,"value" => 490843),array("tree" => array() ,"value" => 156779)) ,"value" => 687867),array("tree" => array(array("tree" => array() ,"value" => 449078),array("tree" => array() ,"value" => 485937),array("tree" => array() ,"value" => 688353),array("tree" => array() ,"value" => 490392)) ,"value" => 878342),array("tree" => array(array("tree" => array() ,"value" => 911754),array("tree" => array() ,"value" => 578563),array("tree" => array() ,"value" => 135876),array("tree" => array() ,"value" => 6810)) ,"value" => 921616),array("tree" => array(array("tree" => array() ,"value" => 483231),array("tree" => array() ,"value" => 915405),array("tree" => array() ,"value" => 895075),array("tree" => array() ,"value" => 861911)) ,"value" => 532267)) ,"value" => 400544),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 8774),array("tree" => array() ,"value" => 515587),array("tree" => array() ,"value" => 100126),array("tree" => array() ,"value" => 485993)) ,"value" => 735601),array("tree" => array(array("tree" => array() ,"value" => 80468),array("tree" => array() ,"value" => 135692),array("tree" => array() ,"value" => 504295),array("tree" => array() ,"value" => 132695)) ,"value" => 162964),array("tree" => array(array("tree" => array() ,"value" => 530016),array("tree" => array() ,"value" => 861971),array("tree" => array() ,"value" => 8715),array("tree" => array() ,"value" => 922311)) ,"value" => 237150),array("tree" => array(array("tree" => array() ,"value" => 409246),array("tree" => array() ,"value" => 692872),array("tree" => array() ,"value" => 689721),array("tree" => array() ,"value" => 96449)) ,"value" => 568560)) ,"value" => 998414),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 375905),array("tree" => array() ,"value" => 836213),array("tree" => array() ,"value" => 324549),array("tree" => array() ,"value" => 424284)) ,"value" => 356351),array("tree" => array(array("tree" => array() ,"value" => 248756),array("tree" => array() ,"value" => 783070),array("tree" => array() ,"value" => 799217),array("tree" => array() ,"value" => 663561)) ,"value" => 686948),array("tree" => array(array("tree" => array() ,"value" => 40725),array("tree" => array() ,"value" => 291182),array("tree" => array() ,"value" => 951690),array("tree" => array() ,"value" => 199530)) ,"value" => 926084),array("tree" => array(array("tree" => array() ,"value" => 181478),array("tree" => array() ,"value" => 535230),array("tree" => array() ,"value" => 345101),array("tree" => array() ,"value" => 913227)) ,"value" => 632430)) ,"value" => 955391),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 323360),array("tree" => array() ,"value" => 838747),array("tree" => array() ,"value" => 593397),array("tree" => array() ,"value" => 902089)) ,"value" => 499225),array("tree" => array(array("tree" => array() ,"value" => 658926),array("tree" => array() ,"value" => 303343),array("tree" => array() ,"value" => 585042),array("tree" => array() ,"value" => 327033)) ,"value" => 981242),array("tree" => array(array("tree" => array() ,"value" => 223448),array("tree" => array() ,"value" => 282094),array("tree" => array() ,"value" => 882451),array("tree" => array() ,"value" => 563156)) ,"value" => 125320),array("tree" => array(array("tree" => array() ,"value" => 383269),array("tree" => array() ,"value" => 342784),array("tree" => array() ,"value" => 963529),array("tree" => array() ,"value" => 647942)) ,"value" => 714990)) ,"value" => 530472)) ,"value" => 130408),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 194557),array("tree" => array() ,"value" => 649513),array("tree" => array() ,"value" => 59098),array("tree" => array() ,"value" => 586129)) ,"value" => 490146),array("tree" => array(array("tree" => array() ,"value" => 848485),array("tree" => array() ,"value" => 381051),array("tree" => array() ,"value" => 633192),array("tree" => array() ,"value" => 256630)) ,"value" => 610217),array("tree" => array(array("tree" => array() ,"value" => 737560),array("tree" => array() ,"value" => 327362),array("tree" => array() ,"value" => 437502),array("tree" => array() ,"value" => 541555)) ,"value" => 444694),array("tree" => array(array("tree" => array() ,"value" => 196143),array("tree" => array() ,"value" => 767114),array("tree" => array() ,"value" => 197401),array("tree" => array() ,"value" => 335582)) ,"value" => 762470)) ,"value" => 773318),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 733580),array("tree" => array() ,"value" => 238537),array("tree" => array() ,"value" => 307953),array("tree" => array() ,"value" => 707688)) ,"value" => 285177),array("tree" => array(array("tree" => array() ,"value" => 135830),array("tree" => array() ,"value" => 854037),array("tree" => array() ,"value" => 723896),array("tree" => array() ,"value" => 130016)) ,"value" => 622948),array("tree" => array(array("tree" => array() ,"value" => 419749),array("tree" => array() ,"value" => 473982),array("tree" => array() ,"value" => 526692),array("tree" => array() ,"value" => 106503)) ,"value" => 833684),array("tree" => array(array("tree" => array() ,"value" => 862758),array("tree" => array() ,"value" => 569244),array("tree" => array() ,"value" => 511081),array("tree" => array() ,"value" => 226945)) ,"value" => 309771)) ,"value" => 493408),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 237879),array("tree" => array() ,"value" => 698538),array("tree" => array() ,"value" => 349995),array("tree" => array() ,"value" => 68873)) ,"value" => 534372),array("tree" => array(array("tree" => array() ,"value" => 722527),array("tree" => array() ,"value" => 993824),array("tree" => array() ,"value" => 705977),array("tree" => array() ,"value" => 781661)) ,"value" => 975758),array("tree" => array(array("tree" => array() ,"value" => 961646),array("tree" => array() ,"value" => 647350),array("tree" => array() ,"value" => 378053),array("tree" => array() ,"value" => 496973)) ,"value" => 657734),array("tree" => array(array("tree" => array() ,"value" => 415762),array("tree" => array() ,"value" => 686224),array("tree" => array() ,"value" => 585389),array("tree" => array() ,"value" => 651637)) ,"value" => 466991)) ,"value" => 638483),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 620364),array("tree" => array() ,"value" => 340715),array("tree" => array() ,"value" => 999491),array("tree" => array() ,"value" => 45452)) ,"value" => 330167),array("tree" => array(array("tree" => array() ,"value" => 962462),array("tree" => array() ,"value" => 977305),array("tree" => array() ,"value" => 130161),array("tree" => array() ,"value" => 312131)) ,"value" => 742538),array("tree" => array(array("tree" => array() ,"value" => 754348),array("tree" => array() ,"value" => 420561),array("tree" => array() ,"value" => 835425),array("tree" => array() ,"value" => 119664)) ,"value" => 34453),array("tree" => array(array("tree" => array() ,"value" => 914045),array("tree" => array() ,"value" => 318398),array("tree" => array() ,"value" => 569547),array("tree" => array() ,"value" => 786156)) ,"value" => 225226)) ,"value" => 446451)) ,"value" => 548765)) ,"value" => 382990)) ,"value" => 351149),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 482408),array("tree" => array() ,"value" => 205667),array("tree" => array() ,"value" => 34706),array("tree" => array() ,"value" => 386779)) ,"value" => 302197),array("tree" => array(array("tree" => array() ,"value" => 82601),array("tree" => array() ,"value" => 839438),array("tree" => array() ,"value" => 129327),array("tree" => array() ,"value" => 168634)) ,"value" => 491116),array("tree" => array(array("tree" => array() ,"value" => 93039),array("tree" => array() ,"value" => 236448),array("tree" => array() ,"value" => 4002),array("tree" => array() ,"value" => 295934)) ,"value" => 805941),array("tree" => array(array("tree" => array() ,"value" => 968792),array("tree" => array() ,"value" => 55630),array("tree" => array() ,"value" => 120374),array("tree" => array() ,"value" => 495582)) ,"value" => 667194)) ,"value" => 310014),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 22737),array("tree" => array() ,"value" => 566665),array("tree" => array() ,"value" => 327606),array("tree" => array() ,"value" => 643422)) ,"value" => 7163),array("tree" => array(array("tree" => array() ,"value" => 354900),array("tree" => array() ,"value" => 976736),array("tree" => array() ,"value" => 80323),array("tree" => array() ,"value" => 192615)) ,"value" => 846860),array("tree" => array(array("tree" => array() ,"value" => 559807),array("tree" => array() ,"value" => 21323),array("tree" => array() ,"value" => 107457),array("tree" => array() ,"value" => 840316)) ,"value" => 559501),array("tree" => array(array("tree" => array() ,"value" => 377710),array("tree" => array() ,"value" => 799710),array("tree" => array() ,"value" => 40094),array("tree" => array() ,"value" => 889496)) ,"value" => 110346)) ,"value" => 261854),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 215135),array("tree" => array() ,"value" => 313780),array("tree" => array() ,"value" => 841567),array("tree" => array() ,"value" => 37653)) ,"value" => 10817),array("tree" => array(array("tree" => array() ,"value" => 427060),array("tree" => array() ,"value" => 668101),array("tree" => array() ,"value" => 278),array("tree" => array() ,"value" => 829535)) ,"value" => 418898),array("tree" => array(array("tree" => array() ,"value" => 925403),array("tree" => array() ,"value" => 241601),array("tree" => array() ,"value" => 261078),array("tree" => array() ,"value" => 116041)) ,"value" => 556362),array("tree" => array(array("tree" => array() ,"value" => 826463),array("tree" => array() ,"value" => 699642),array("tree" => array() ,"value" => 547615),array("tree" => array() ,"value" => 109100)) ,"value" => 576415)) ,"value" => 903592),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 441759),array("tree" => array() ,"value" => 223908),array("tree" => array() ,"value" => 459611),array("tree" => array() ,"value" => 259096)) ,"value" => 419078),array("tree" => array(array("tree" => array() ,"value" => 702656),array("tree" => array() ,"value" => 107761),array("tree" => array() ,"value" => 459904),array("tree" => array() ,"value" => 237840)) ,"value" => 936582),array("tree" => array(array("tree" => array() ,"value" => 485003),array("tree" => array() ,"value" => 823885),array("tree" => array() ,"value" => 876135),array("tree" => array() ,"value" => 898181)) ,"value" => 867464),array("tree" => array(array("tree" => array() ,"value" => 563683),array("tree" => array() ,"value" => 613232),array("tree" => array() ,"value" => 61201),array("tree" => array() ,"value" => 680731)) ,"value" => 797655)) ,"value" => 756189)) ,"value" => 75413),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 102618),array("tree" => array() ,"value" => 193610),array("tree" => array() ,"value" => 770579),array("tree" => array() ,"value" => 126109)) ,"value" => 68024),array("tree" => array(array("tree" => array() ,"value" => 1391),array("tree" => array() ,"value" => 21032),array("tree" => array() ,"value" => 615368),array("tree" => array() ,"value" => 391690)) ,"value" => 690939),array("tree" => array(array("tree" => array() ,"value" => 600890),array("tree" => array() ,"value" => 73341),array("tree" => array() ,"value" => 926688),array("tree" => array() ,"value" => 896821)) ,"value" => 940912),array("tree" => array(array("tree" => array() ,"value" => 527736),array("tree" => array() ,"value" => 857457),array("tree" => array() ,"value" => 474716),array("tree" => array() ,"value" => 92043)) ,"value" => 429642)) ,"value" => 692630),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 412823),array("tree" => array() ,"value" => 157457),array("tree" => array() ,"value" => 453075),array("tree" => array() ,"value" => 402991)) ,"value" => 449130),array("tree" => array(array("tree" => array() ,"value" => 176697),array("tree" => array() ,"value" => 478489),array("tree" => array() ,"value" => 938587),array("tree" => array() ,"value" => 550611)) ,"value" => 4619),array("tree" => array(array("tree" => array() ,"value" => 714173),array("tree" => array() ,"value" => 826571),array("tree" => array() ,"value" => 874365),array("tree" => array() ,"value" => 281270)) ,"value" => 258959),array("tree" => array(array("tree" => array() ,"value" => 498376),array("tree" => array() ,"value" => 929203),array("tree" => array() ,"value" => 63942),array("tree" => array() ,"value" => 584942)) ,"value" => 563661)) ,"value" => 764962),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 256069),array("tree" => array() ,"value" => 135636),array("tree" => array() ,"value" => 522654),array("tree" => array() ,"value" => 58622)) ,"value" => 573450),array("tree" => array(array("tree" => array() ,"value" => 175183),array("tree" => array() ,"value" => 230305),array("tree" => array() ,"value" => 385740),array("tree" => array() ,"value" => 675323)) ,"value" => 913368),array("tree" => array(array("tree" => array() ,"value" => 661046),array("tree" => array() ,"value" => 844960),array("tree" => array() ,"value" => 787362),array("tree" => array() ,"value" => 522876)) ,"value" => 279372),array("tree" => array(array("tree" => array() ,"value" => 819167),array("tree" => array() ,"value" => 148805),array("tree" => array() ,"value" => 282163),array("tree" => array() ,"value" => 261287)) ,"value" => 410253)) ,"value" => 961991),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 222444),array("tree" => array() ,"value" => 255618),array("tree" => array() ,"value" => 728271),array("tree" => array() ,"value" => 659999)) ,"value" => 187632),array("tree" => array(array("tree" => array() ,"value" => 645164),array("tree" => array() ,"value" => 945623),array("tree" => array() ,"value" => 908529),array("tree" => array() ,"value" => 409762)) ,"value" => 57665),array("tree" => array(array("tree" => array() ,"value" => 528454),array("tree" => array() ,"value" => 145380),array("tree" => array() ,"value" => 115651),array("tree" => array() ,"value" => 588174)) ,"value" => 96943),array("tree" => array(array("tree" => array() ,"value" => 167894),array("tree" => array() ,"value" => 420693),array("tree" => array() ,"value" => 880375),array("tree" => array() ,"value" => 957606)) ,"value" => 396189)) ,"value" => 41692)) ,"value" => 469738),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 73182),array("tree" => array() ,"value" => 655220),array("tree" => array() ,"value" => 607205),array("tree" => array() ,"value" => 117239)) ,"value" => 843146),array("tree" => array(array("tree" => array() ,"value" => 804366),array("tree" => array() ,"value" => 941014),array("tree" => array() ,"value" => 248794),array("tree" => array() ,"value" => 57690)) ,"value" => 399970),array("tree" => array(array("tree" => array() ,"value" => 387098),array("tree" => array() ,"value" => 334369),array("tree" => array() ,"value" => 808527),array("tree" => array() ,"value" => 935896)) ,"value" => 673873),array("tree" => array(array("tree" => array() ,"value" => 189703),array("tree" => array() ,"value" => 129628),array("tree" => array() ,"value" => 244140),array("tree" => array() ,"value" => 365439)) ,"value" => 588878)) ,"value" => 741442),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 812780),array("tree" => array() ,"value" => 667144),array("tree" => array() ,"value" => 573774),array("tree" => array() ,"value" => 595194)) ,"value" => 337083),array("tree" => array(array("tree" => array() ,"value" => 751703),array("tree" => array() ,"value" => 678889),array("tree" => array() ,"value" => 946530),array("tree" => array() ,"value" => 287382)) ,"value" => 381598),array("tree" => array(array("tree" => array() ,"value" => 858598),array("tree" => array() ,"value" => 773832),array("tree" => array() ,"value" => 756494),array("tree" => array() ,"value" => 69303)) ,"value" => 584490),array("tree" => array(array("tree" => array() ,"value" => 530259),array("tree" => array() ,"value" => 783717),array("tree" => array() ,"value" => 472442),array("tree" => array() ,"value" => 916524)) ,"value" => 148447)) ,"value" => 951156),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 258104),array("tree" => array() ,"value" => 999862),array("tree" => array() ,"value" => 947165),array("tree" => array() ,"value" => 986434)) ,"value" => 214747),array("tree" => array(array("tree" => array() ,"value" => 663702),array("tree" => array() ,"value" => 685431),array("tree" => array() ,"value" => 143713),array("tree" => array() ,"value" => 468803)) ,"value" => 125838),array("tree" => array(array("tree" => array() ,"value" => 816352),array("tree" => array() ,"value" => 983959),array("tree" => array() ,"value" => 635142),array("tree" => array() ,"value" => 137705)) ,"value" => 229883),array("tree" => array(array("tree" => array() ,"value" => 475097),array("tree" => array() ,"value" => 119556),array("tree" => array() ,"value" => 889486),array("tree" => array() ,"value" => 512297)) ,"value" => 219467)) ,"value" => 784183),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 730937),array("tree" => array() ,"value" => 643705),array("tree" => array() ,"value" => 29893),array("tree" => array() ,"value" => 1267)) ,"value" => 954912),array("tree" => array(array("tree" => array() ,"value" => 117696),array("tree" => array() ,"value" => 486908),array("tree" => array() ,"value" => 732),array("tree" => array() ,"value" => 876660)) ,"value" => 967008),array("tree" => array(array("tree" => array() ,"value" => 156338),array("tree" => array() ,"value" => 528021),array("tree" => array() ,"value" => 789523),array("tree" => array() ,"value" => 1681)) ,"value" => 85712),array("tree" => array(array("tree" => array() ,"value" => 670664),array("tree" => array() ,"value" => 131497),array("tree" => array() ,"value" => 563918),array("tree" => array() ,"value" => 362647)) ,"value" => 685071)) ,"value" => 255177)) ,"value" => 695278),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 63539),array("tree" => array() ,"value" => 418915),array("tree" => array() ,"value" => 814119),array("tree" => array() ,"value" => 395323)) ,"value" => 845399),array("tree" => array(array("tree" => array() ,"value" => 158092),array("tree" => array() ,"value" => 707078),array("tree" => array() ,"value" => 567503),array("tree" => array() ,"value" => 773010)) ,"value" => 431840),array("tree" => array(array("tree" => array() ,"value" => 746595),array("tree" => array() ,"value" => 757197),array("tree" => array() ,"value" => 966582),array("tree" => array() ,"value" => 591753)) ,"value" => 266117),array("tree" => array(array("tree" => array() ,"value" => 295314),array("tree" => array() ,"value" => 66282),array("tree" => array() ,"value" => 995737),array("tree" => array() ,"value" => 592132)) ,"value" => 107469)) ,"value" => 897950),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 335928),array("tree" => array() ,"value" => 30802),array("tree" => array() ,"value" => 789735),array("tree" => array() ,"value" => 915526)) ,"value" => 627449),array("tree" => array(array("tree" => array() ,"value" => 11620),array("tree" => array() ,"value" => 454362),array("tree" => array() ,"value" => 722108),array("tree" => array() ,"value" => 229153)) ,"value" => 948067),array("tree" => array(array("tree" => array() ,"value" => 623758),array("tree" => array() ,"value" => 359662),array("tree" => array() ,"value" => 10343),array("tree" => array() ,"value" => 825346)) ,"value" => 558286),array("tree" => array(array("tree" => array() ,"value" => 671998),array("tree" => array() ,"value" => 211732),array("tree" => array() ,"value" => 312646),array("tree" => array() ,"value" => 969842)) ,"value" => 118365)) ,"value" => 518091),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 652303),array("tree" => array() ,"value" => 607409),array("tree" => array() ,"value" => 537763),array("tree" => array() ,"value" => 52078)) ,"value" => 389382),array("tree" => array(array("tree" => array() ,"value" => 19637),array("tree" => array() ,"value" => 921767),array("tree" => array() ,"value" => 986231),array("tree" => array() ,"value" => 546873)) ,"value" => 645109),array("tree" => array(array("tree" => array() ,"value" => 445773),array("tree" => array() ,"value" => 590912),array("tree" => array() ,"value" => 7497),array("tree" => array() ,"value" => 221028)) ,"value" => 457052),array("tree" => array(array("tree" => array() ,"value" => 543562),array("tree" => array() ,"value" => 807779),array("tree" => array() ,"value" => 896289),array("tree" => array() ,"value" => 539270)) ,"value" => 405498)) ,"value" => 945184),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 231533),array("tree" => array() ,"value" => 297375),array("tree" => array() ,"value" => 651869),array("tree" => array() ,"value" => 752661)) ,"value" => 887924),array("tree" => array(array("tree" => array() ,"value" => 476157),array("tree" => array() ,"value" => 858642),array("tree" => array() ,"value" => 118269),array("tree" => array() ,"value" => 61941)) ,"value" => 818250),array("tree" => array(array("tree" => array() ,"value" => 708536),array("tree" => array() ,"value" => 980972),array("tree" => array() ,"value" => 485756),array("tree" => array() ,"value" => 183949)) ,"value" => 360331),array("tree" => array(array("tree" => array() ,"value" => 83885),array("tree" => array() ,"value" => 798319),array("tree" => array() ,"value" => 791968),array("tree" => array() ,"value" => 780333)) ,"value" => 951564)) ,"value" => 979873)) ,"value" => 19838)) ,"value" => 202816),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 605219),array("tree" => array() ,"value" => 764641),array("tree" => array() ,"value" => 763882),array("tree" => array() ,"value" => 289892)) ,"value" => 948505),array("tree" => array(array("tree" => array() ,"value" => 281886),array("tree" => array() ,"value" => 680611),array("tree" => array() ,"value" => 350961),array("tree" => array() ,"value" => 353194)) ,"value" => 983737),array("tree" => array(array("tree" => array() ,"value" => 533647),array("tree" => array() ,"value" => 851288),array("tree" => array() ,"value" => 551942),array("tree" => array() ,"value" => 570190)) ,"value" => 572053),array("tree" => array(array("tree" => array() ,"value" => 948517),array("tree" => array() ,"value" => 166825),array("tree" => array() ,"value" => 260455),array("tree" => array() ,"value" => 815697)) ,"value" => 259821)) ,"value" => 218612),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 595974),array("tree" => array() ,"value" => 725998),array("tree" => array() ,"value" => 798514),array("tree" => array() ,"value" => 151412)) ,"value" => 797294),array("tree" => array(array("tree" => array() ,"value" => 635920),array("tree" => array() ,"value" => 964029),array("tree" => array() ,"value" => 243052),array("tree" => array() ,"value" => 949186)) ,"value" => 448658),array("tree" => array(array("tree" => array() ,"value" => 595441),array("tree" => array() ,"value" => 326920),array("tree" => array() ,"value" => 535547),array("tree" => array() ,"value" => 502405)) ,"value" => 164143),array("tree" => array(array("tree" => array() ,"value" => 297592),array("tree" => array() ,"value" => 122668),array("tree" => array() ,"value" => 766418),array("tree" => array() ,"value" => 914164)) ,"value" => 58935)) ,"value" => 972745),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 621374),array("tree" => array() ,"value" => 656075),array("tree" => array() ,"value" => 797715),array("tree" => array() ,"value" => 24616)) ,"value" => 817276),array("tree" => array(array("tree" => array() ,"value" => 219545),array("tree" => array() ,"value" => 808380),array("tree" => array() ,"value" => 608700),array("tree" => array() ,"value" => 377540)) ,"value" => 337186),array("tree" => array(array("tree" => array() ,"value" => 367705),array("tree" => array() ,"value" => 804893),array("tree" => array() ,"value" => 735874),array("tree" => array() ,"value" => 439225)) ,"value" => 157563),array("tree" => array(array("tree" => array() ,"value" => 401043),array("tree" => array() ,"value" => 607863),array("tree" => array() ,"value" => 94957),array("tree" => array() ,"value" => 217341)) ,"value" => 988326)) ,"value" => 505957),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 529157),array("tree" => array() ,"value" => 553898),array("tree" => array() ,"value" => 992546),array("tree" => array() ,"value" => 880485)) ,"value" => 540996),array("tree" => array(array("tree" => array() ,"value" => 626039),array("tree" => array() ,"value" => 470954),array("tree" => array() ,"value" => 77480),array("tree" => array() ,"value" => 520994)) ,"value" => 871068),array("tree" => array(array("tree" => array() ,"value" => 816501),array("tree" => array() ,"value" => 146840),array("tree" => array() ,"value" => 99297),array("tree" => array() ,"value" => 553009)) ,"value" => 519072),array("tree" => array(array("tree" => array() ,"value" => 596844),array("tree" => array() ,"value" => 754506),array("tree" => array() ,"value" => 815655),array("tree" => array() ,"value" => 629379)) ,"value" => 693742)) ,"value" => 280391)) ,"value" => 655651),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 786533),array("tree" => array() ,"value" => 414011),array("tree" => array() ,"value" => 14128),array("tree" => array() ,"value" => 232273)) ,"value" => 327293),array("tree" => array(array("tree" => array() ,"value" => 354793),array("tree" => array() ,"value" => 701946),array("tree" => array() ,"value" => 608228),array("tree" => array() ,"value" => 260889)) ,"value" => 52367),array("tree" => array(array("tree" => array() ,"value" => 579787),array("tree" => array() ,"value" => 426061),array("tree" => array() ,"value" => 276465),array("tree" => array() ,"value" => 968743)) ,"value" => 303354),array("tree" => array(array("tree" => array() ,"value" => 287169),array("tree" => array() ,"value" => 581020),array("tree" => array() ,"value" => 464288),array("tree" => array() ,"value" => 152398)) ,"value" => 8515)) ,"value" => 886359),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 788184),array("tree" => array() ,"value" => 337718),array("tree" => array() ,"value" => 58111),array("tree" => array() ,"value" => 90717)) ,"value" => 595933),array("tree" => array(array("tree" => array() ,"value" => 238664),array("tree" => array() ,"value" => 587565),array("tree" => array() ,"value" => 429714),array("tree" => array() ,"value" => 821973)) ,"value" => 781116),array("tree" => array(array("tree" => array() ,"value" => 472506),array("tree" => array() ,"value" => 688887),array("tree" => array() ,"value" => 778258),array("tree" => array() ,"value" => 72223)) ,"value" => 964725),array("tree" => array(array("tree" => array() ,"value" => 842063),array("tree" => array() ,"value" => 417559),array("tree" => array() ,"value" => 31789),array("tree" => array() ,"value" => 515948)) ,"value" => 310541)) ,"value" => 64889),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 901277),array("tree" => array() ,"value" => 268739),array("tree" => array() ,"value" => 42196),array("tree" => array() ,"value" => 782469)) ,"value" => 7864),array("tree" => array(array("tree" => array() ,"value" => 307597),array("tree" => array() ,"value" => 411792),array("tree" => array() ,"value" => 443921),array("tree" => array() ,"value" => 91077)) ,"value" => 211259),array("tree" => array(array("tree" => array() ,"value" => 384714),array("tree" => array() ,"value" => 255625),array("tree" => array() ,"value" => 530258),array("tree" => array() ,"value" => 87602)) ,"value" => 653174),array("tree" => array(array("tree" => array() ,"value" => 688129),array("tree" => array() ,"value" => 607338),array("tree" => array() ,"value" => 890483),array("tree" => array() ,"value" => 245182)) ,"value" => 721414)) ,"value" => 97717),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 44691),array("tree" => array() ,"value" => 125704),array("tree" => array() ,"value" => 316665),array("tree" => array() ,"value" => 307552)) ,"value" => 512700),array("tree" => array(array("tree" => array() ,"value" => 747077),array("tree" => array() ,"value" => 240891),array("tree" => array() ,"value" => 732320),array("tree" => array() ,"value" => 18985)) ,"value" => 113004),array("tree" => array(array("tree" => array() ,"value" => 156591),array("tree" => array() ,"value" => 326323),array("tree" => array() ,"value" => 688314),array("tree" => array() ,"value" => 372777)) ,"value" => 587786),array("tree" => array(array("tree" => array() ,"value" => 128706),array("tree" => array() ,"value" => 5729),array("tree" => array() ,"value" => 668579),array("tree" => array() ,"value" => 760121)) ,"value" => 390703)) ,"value" => 557245)) ,"value" => 355776),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 118277),array("tree" => array() ,"value" => 186385),array("tree" => array() ,"value" => 853549),array("tree" => array() ,"value" => 880274)) ,"value" => 101288),array("tree" => array(array("tree" => array() ,"value" => 261885),array("tree" => array() ,"value" => 977311),array("tree" => array() ,"value" => 716358),array("tree" => array() ,"value" => 797160)) ,"value" => 741378),array("tree" => array(array("tree" => array() ,"value" => 752056),array("tree" => array() ,"value" => 967615),array("tree" => array() ,"value" => 223261),array("tree" => array() ,"value" => 886373)) ,"value" => 244398),array("tree" => array(array("tree" => array() ,"value" => 486674),array("tree" => array() ,"value" => 526348),array("tree" => array() ,"value" => 674734),array("tree" => array() ,"value" => 461299)) ,"value" => 874473)) ,"value" => 829176),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 661350),array("tree" => array() ,"value" => 76490),array("tree" => array() ,"value" => 497152),array("tree" => array() ,"value" => 61551)) ,"value" => 999455),array("tree" => array(array("tree" => array() ,"value" => 741984),array("tree" => array() ,"value" => 749629),array("tree" => array() ,"value" => 806479),array("tree" => array() ,"value" => 952106)) ,"value" => 887660),array("tree" => array(array("tree" => array() ,"value" => 280079),array("tree" => array() ,"value" => 909693),array("tree" => array() ,"value" => 631587),array("tree" => array() ,"value" => 825850)) ,"value" => 192520),array("tree" => array(array("tree" => array() ,"value" => 738887),array("tree" => array() ,"value" => 441674),array("tree" => array() ,"value" => 952291),array("tree" => array() ,"value" => 116111)) ,"value" => 212952)) ,"value" => 471886),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 262718),array("tree" => array() ,"value" => 621075),array("tree" => array() ,"value" => 727759),array("tree" => array() ,"value" => 103991)) ,"value" => 233778),array("tree" => array(array("tree" => array() ,"value" => 393569),array("tree" => array() ,"value" => 207657),array("tree" => array() ,"value" => 284952),array("tree" => array() ,"value" => 833762)) ,"value" => 737444),array("tree" => array(array("tree" => array() ,"value" => 567255),array("tree" => array() ,"value" => 832552),array("tree" => array() ,"value" => 791424),array("tree" => array() ,"value" => 954042)) ,"value" => 262584),array("tree" => array(array("tree" => array() ,"value" => 546336),array("tree" => array() ,"value" => 708115),array("tree" => array() ,"value" => 745988),array("tree" => array() ,"value" => 251382)) ,"value" => 19354)) ,"value" => 947146),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 309527),array("tree" => array() ,"value" => 986225),array("tree" => array() ,"value" => 544587),array("tree" => array() ,"value" => 970955)) ,"value" => 72903),array("tree" => array(array("tree" => array() ,"value" => 106452),array("tree" => array() ,"value" => 460567),array("tree" => array() ,"value" => 428657),array("tree" => array() ,"value" => 540396)) ,"value" => 554586),array("tree" => array(array("tree" => array() ,"value" => 315850),array("tree" => array() ,"value" => 837990),array("tree" => array() ,"value" => 614814),array("tree" => array() ,"value" => 775500)) ,"value" => 149639),array("tree" => array(array("tree" => array() ,"value" => 326243),array("tree" => array() ,"value" => 98822),array("tree" => array() ,"value" => 542030),array("tree" => array() ,"value" => 473846)) ,"value" => 121991)) ,"value" => 404695)) ,"value" => 299433),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 973697),array("tree" => array() ,"value" => 915578),array("tree" => array() ,"value" => 820545),array("tree" => array() ,"value" => 346552)) ,"value" => 548498),array("tree" => array(array("tree" => array() ,"value" => 562315),array("tree" => array() ,"value" => 889872),array("tree" => array() ,"value" => 864537),array("tree" => array() ,"value" => 308411)) ,"value" => 567501),array("tree" => array(array("tree" => array() ,"value" => 598248),array("tree" => array() ,"value" => 20075),array("tree" => array() ,"value" => 222711),array("tree" => array() ,"value" => 853493)) ,"value" => 949652),array("tree" => array(array("tree" => array() ,"value" => 642951),array("tree" => array() ,"value" => 420875),array("tree" => array() ,"value" => 208376),array("tree" => array() ,"value" => 596721)) ,"value" => 830301)) ,"value" => 423229),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 60531),array("tree" => array() ,"value" => 844952),array("tree" => array() ,"value" => 180335),array("tree" => array() ,"value" => 782916)) ,"value" => 738134),array("tree" => array(array("tree" => array() ,"value" => 258514),array("tree" => array() ,"value" => 706281),array("tree" => array() ,"value" => 286468),array("tree" => array() ,"value" => 608731)) ,"value" => 834211),array("tree" => array(array("tree" => array() ,"value" => 268342),array("tree" => array() ,"value" => 500129),array("tree" => array() ,"value" => 68188),array("tree" => array() ,"value" => 23292)) ,"value" => 379393),array("tree" => array(array("tree" => array() ,"value" => 255955),array("tree" => array() ,"value" => 554966),array("tree" => array() ,"value" => 572330),array("tree" => array() ,"value" => 323104)) ,"value" => 221144)) ,"value" => 140009),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 11449),array("tree" => array() ,"value" => 223113),array("tree" => array() ,"value" => 315176),array("tree" => array() ,"value" => 824447)) ,"value" => 156262),array("tree" => array(array("tree" => array() ,"value" => 530562),array("tree" => array() ,"value" => 316537),array("tree" => array() ,"value" => 29224),array("tree" => array() ,"value" => 556945)) ,"value" => 70545),array("tree" => array(array("tree" => array() ,"value" => 396697),array("tree" => array() ,"value" => 254825),array("tree" => array() ,"value" => 414077),array("tree" => array() ,"value" => 650236)) ,"value" => 456442),array("tree" => array(array("tree" => array() ,"value" => 945444),array("tree" => array() ,"value" => 818435),array("tree" => array() ,"value" => 61861),array("tree" => array() ,"value" => 678163)) ,"value" => 274863)) ,"value" => 88253),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 777768),array("tree" => array() ,"value" => 832522),array("tree" => array() ,"value" => 58279),array("tree" => array() ,"value" => 178838)) ,"value" => 7495),array("tree" => array(array("tree" => array() ,"value" => 945405),array("tree" => array() ,"value" => 495586),array("tree" => array() ,"value" => 278723),array("tree" => array() ,"value" => 15262)) ,"value" => 335380),array("tree" => array(array("tree" => array() ,"value" => 390213),array("tree" => array() ,"value" => 550268),array("tree" => array() ,"value" => 185536),array("tree" => array() ,"value" => 992582)) ,"value" => 73555),array("tree" => array(array("tree" => array() ,"value" => 485562),array("tree" => array() ,"value" => 391444),array("tree" => array() ,"value" => 215890),array("tree" => array() ,"value" => 306480)) ,"value" => 752820)) ,"value" => 380648)) ,"value" => 341518)) ,"value" => 596582),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 448325),array("tree" => array() ,"value" => 325528),array("tree" => array() ,"value" => 829091),array("tree" => array() ,"value" => 761499)) ,"value" => 666423),array("tree" => array(array("tree" => array() ,"value" => 611720),array("tree" => array() ,"value" => 784228),array("tree" => array() ,"value" => 864574),array("tree" => array() ,"value" => 398534)) ,"value" => 330855),array("tree" => array(array("tree" => array() ,"value" => 86253),array("tree" => array() ,"value" => 891385),array("tree" => array() ,"value" => 182698),array("tree" => array() ,"value" => 650856)) ,"value" => 589065),array("tree" => array(array("tree" => array() ,"value" => 591230),array("tree" => array() ,"value" => 77767),array("tree" => array() ,"value" => 76486),array("tree" => array() ,"value" => 146077)) ,"value" => 152042)) ,"value" => 884780),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 897139),array("tree" => array() ,"value" => 157250),array("tree" => array() ,"value" => 87879),array("tree" => array() ,"value" => 227433)) ,"value" => 938941),array("tree" => array(array("tree" => array() ,"value" => 44568),array("tree" => array() ,"value" => 944731),array("tree" => array() ,"value" => 722360),array("tree" => array() ,"value" => 61806)) ,"value" => 240897),array("tree" => array(array("tree" => array() ,"value" => 944808),array("tree" => array() ,"value" => 562497),array("tree" => array() ,"value" => 776579),array("tree" => array() ,"value" => 332881)) ,"value" => 916583),array("tree" => array(array("tree" => array() ,"value" => 846470),array("tree" => array() ,"value" => 28113),array("tree" => array() ,"value" => 86921),array("tree" => array() ,"value" => 62767)) ,"value" => 52551)) ,"value" => 464692),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 199091),array("tree" => array() ,"value" => 515331),array("tree" => array() ,"value" => 639394),array("tree" => array() ,"value" => 230241)) ,"value" => 500208),array("tree" => array(array("tree" => array() ,"value" => 786598),array("tree" => array() ,"value" => 728592),array("tree" => array() ,"value" => 420011),array("tree" => array() ,"value" => 107582)) ,"value" => 902490),array("tree" => array(array("tree" => array() ,"value" => 273062),array("tree" => array() ,"value" => 48733),array("tree" => array() ,"value" => 777994),array("tree" => array() ,"value" => 23533)) ,"value" => 562727),array("tree" => array(array("tree" => array() ,"value" => 904455),array("tree" => array() ,"value" => 337540),array("tree" => array() ,"value" => 504880),array("tree" => array() ,"value" => 811547)) ,"value" => 595090)) ,"value" => 203212),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 455042),array("tree" => array() ,"value" => 733710),array("tree" => array() ,"value" => 663718),array("tree" => array() ,"value" => 83673)) ,"value" => 453547),array("tree" => array(array("tree" => array() ,"value" => 413160),array("tree" => array() ,"value" => 717683),array("tree" => array() ,"value" => 702011),array("tree" => array() ,"value" => 415333)) ,"value" => 144386),array("tree" => array(array("tree" => array() ,"value" => 967365),array("tree" => array() ,"value" => 802174),array("tree" => array() ,"value" => 959480),array("tree" => array() ,"value" => 537994)) ,"value" => 772340),array("tree" => array(array("tree" => array() ,"value" => 940899),array("tree" => array() ,"value" => 658065),array("tree" => array() ,"value" => 127194),array("tree" => array() ,"value" => 329092)) ,"value" => 286360)) ,"value" => 845173)) ,"value" => 568908),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 172424),array("tree" => array() ,"value" => 739358),array("tree" => array() ,"value" => 338691),array("tree" => array() ,"value" => 270553)) ,"value" => 475642),array("tree" => array(array("tree" => array() ,"value" => 303920),array("tree" => array() ,"value" => 221922),array("tree" => array() ,"value" => 848780),array("tree" => array() ,"value" => 219478)) ,"value" => 952834),array("tree" => array(array("tree" => array() ,"value" => 681126),array("tree" => array() ,"value" => 961267),array("tree" => array() ,"value" => 66421),array("tree" => array() ,"value" => 524574)) ,"value" => 353456),array("tree" => array(array("tree" => array() ,"value" => 745997),array("tree" => array() ,"value" => 190069),array("tree" => array() ,"value" => 965349),array("tree" => array() ,"value" => 122550)) ,"value" => 180220)) ,"value" => 378131),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 571986),array("tree" => array() ,"value" => 387113),array("tree" => array() ,"value" => 787555),array("tree" => array() ,"value" => 735687)) ,"value" => 450928),array("tree" => array(array("tree" => array() ,"value" => 860723),array("tree" => array() ,"value" => 145526),array("tree" => array() ,"value" => 360874),array("tree" => array() ,"value" => 372994)) ,"value" => 881100),array("tree" => array(array("tree" => array() ,"value" => 629816),array("tree" => array() ,"value" => 235230),array("tree" => array() ,"value" => 801955),array("tree" => array() ,"value" => 18635)) ,"value" => 588252),array("tree" => array(array("tree" => array() ,"value" => 846582),array("tree" => array() ,"value" => 848702),array("tree" => array() ,"value" => 837104),array("tree" => array() ,"value" => 22525)) ,"value" => 406616)) ,"value" => 44662),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 932281),array("tree" => array() ,"value" => 534097),array("tree" => array() ,"value" => 249116),array("tree" => array() ,"value" => 654997)) ,"value" => 999251),array("tree" => array(array("tree" => array() ,"value" => 677237),array("tree" => array() ,"value" => 238247),array("tree" => array() ,"value" => 353245),array("tree" => array() ,"value" => 603538)) ,"value" => 529828),array("tree" => array(array("tree" => array() ,"value" => 938712),array("tree" => array() ,"value" => 703811),array("tree" => array() ,"value" => 92053),array("tree" => array() ,"value" => 507788)) ,"value" => 23224),array("tree" => array(array("tree" => array() ,"value" => 208002),array("tree" => array() ,"value" => 684114),array("tree" => array() ,"value" => 640104),array("tree" => array() ,"value" => 823834)) ,"value" => 166403)) ,"value" => 657477),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 27782),array("tree" => array() ,"value" => 155364),array("tree" => array() ,"value" => 217381),array("tree" => array() ,"value" => 88370)) ,"value" => 383012),array("tree" => array(array("tree" => array() ,"value" => 37278),array("tree" => array() ,"value" => 490568),array("tree" => array() ,"value" => 294100),array("tree" => array() ,"value" => 151576)) ,"value" => 934440),array("tree" => array(array("tree" => array() ,"value" => 822358),array("tree" => array() ,"value" => 337082),array("tree" => array() ,"value" => 945109),array("tree" => array() ,"value" => 30628)) ,"value" => 84022),array("tree" => array(array("tree" => array() ,"value" => 324289),array("tree" => array() ,"value" => 98144),array("tree" => array() ,"value" => 654116),array("tree" => array() ,"value" => 757154)) ,"value" => 876160)) ,"value" => 854079)) ,"value" => 992188),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 512148),array("tree" => array() ,"value" => 530254),array("tree" => array() ,"value" => 616562),array("tree" => array() ,"value" => 410696)) ,"value" => 631467),array("tree" => array(array("tree" => array() ,"value" => 497075),array("tree" => array() ,"value" => 8293),array("tree" => array() ,"value" => 368335),array("tree" => array() ,"value" => 681408)) ,"value" => 775335),array("tree" => array(array("tree" => array() ,"value" => 915778),array("tree" => array() ,"value" => 197937),array("tree" => array() ,"value" => 301203),array("tree" => array() ,"value" => 412327)) ,"value" => 743939),array("tree" => array(array("tree" => array() ,"value" => 557428),array("tree" => array() ,"value" => 174245),array("tree" => array() ,"value" => 255223),array("tree" => array() ,"value" => 466256)) ,"value" => 636803)) ,"value" => 660495),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 646857),array("tree" => array() ,"value" => 614797),array("tree" => array() ,"value" => 55133),array("tree" => array() ,"value" => 661893)) ,"value" => 686062),array("tree" => array(array("tree" => array() ,"value" => 302002),array("tree" => array() ,"value" => 14172),array("tree" => array() ,"value" => 947050),array("tree" => array() ,"value" => 656329)) ,"value" => 16499),array("tree" => array(array("tree" => array() ,"value" => 140089),array("tree" => array() ,"value" => 270693),array("tree" => array() ,"value" => 172129),array("tree" => array() ,"value" => 241762)) ,"value" => 502437),array("tree" => array(array("tree" => array() ,"value" => 742594),array("tree" => array() ,"value" => 608793),array("tree" => array() ,"value" => 569792),array("tree" => array() ,"value" => 511360)) ,"value" => 473847)) ,"value" => 250280),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 386726),array("tree" => array() ,"value" => 754052),array("tree" => array() ,"value" => 791101),array("tree" => array() ,"value" => 3232)) ,"value" => 789751),array("tree" => array(array("tree" => array() ,"value" => 93394),array("tree" => array() ,"value" => 964818),array("tree" => array() ,"value" => 980045),array("tree" => array() ,"value" => 643969)) ,"value" => 515938),array("tree" => array(array("tree" => array() ,"value" => 233929),array("tree" => array() ,"value" => 12051),array("tree" => array() ,"value" => 500728),array("tree" => array() ,"value" => 16076)) ,"value" => 227224),array("tree" => array(array("tree" => array() ,"value" => 441437),array("tree" => array() ,"value" => 430216),array("tree" => array() ,"value" => 335851),array("tree" => array() ,"value" => 336012)) ,"value" => 10868)) ,"value" => 566035),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 951471),array("tree" => array() ,"value" => 199142),array("tree" => array() ,"value" => 953631),array("tree" => array() ,"value" => 578065)) ,"value" => 823695),array("tree" => array(array("tree" => array() ,"value" => 353169),array("tree" => array() ,"value" => 89751),array("tree" => array() ,"value" => 583530),array("tree" => array() ,"value" => 339049)) ,"value" => 423393),array("tree" => array(array("tree" => array() ,"value" => 479199),array("tree" => array() ,"value" => 111266),array("tree" => array() ,"value" => 725388),array("tree" => array() ,"value" => 632542)) ,"value" => 556441),array("tree" => array(array("tree" => array() ,"value" => 597372),array("tree" => array() ,"value" => 921413),array("tree" => array() ,"value" => 93915),array("tree" => array() ,"value" => 643795)) ,"value" => 564376)) ,"value" => 560996)) ,"value" => 47970),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 833195),array("tree" => array() ,"value" => 19041),array("tree" => array() ,"value" => 434579),array("tree" => array() ,"value" => 650153)) ,"value" => 35818),array("tree" => array(array("tree" => array() ,"value" => 593828),array("tree" => array() ,"value" => 155107),array("tree" => array() ,"value" => 911441),array("tree" => array() ,"value" => 713790)) ,"value" => 593616),array("tree" => array(array("tree" => array() ,"value" => 470384),array("tree" => array() ,"value" => 628763),array("tree" => array() ,"value" => 445989),array("tree" => array() ,"value" => 898867)) ,"value" => 837601),array("tree" => array(array("tree" => array() ,"value" => 596844),array("tree" => array() ,"value" => 78743),array("tree" => array() ,"value" => 284741),array("tree" => array() ,"value" => 719539)) ,"value" => 187032)) ,"value" => 694017),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 642316),array("tree" => array() ,"value" => 24431),array("tree" => array() ,"value" => 30385),array("tree" => array() ,"value" => 903182)) ,"value" => 712574),array("tree" => array(array("tree" => array() ,"value" => 461037),array("tree" => array() ,"value" => 88660),array("tree" => array() ,"value" => 149431),array("tree" => array() ,"value" => 933791)) ,"value" => 332657),array("tree" => array(array("tree" => array() ,"value" => 558197),array("tree" => array() ,"value" => 351307),array("tree" => array() ,"value" => 736359),array("tree" => array() ,"value" => 372690)) ,"value" => 114095),array("tree" => array(array("tree" => array() ,"value" => 357686),array("tree" => array() ,"value" => 434737),array("tree" => array() ,"value" => 878515),array("tree" => array() ,"value" => 822785)) ,"value" => 903582)) ,"value" => 375120),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 191257),array("tree" => array() ,"value" => 431790),array("tree" => array() ,"value" => 723169),array("tree" => array() ,"value" => 462876)) ,"value" => 621523),array("tree" => array(array("tree" => array() ,"value" => 769159),array("tree" => array() ,"value" => 703834),array("tree" => array() ,"value" => 380087),array("tree" => array() ,"value" => 682861)) ,"value" => 451345),array("tree" => array(array("tree" => array() ,"value" => 36937),array("tree" => array() ,"value" => 189899),array("tree" => array() ,"value" => 169157),array("tree" => array() ,"value" => 81941)) ,"value" => 904862),array("tree" => array(array("tree" => array() ,"value" => 283505),array("tree" => array() ,"value" => 124952),array("tree" => array() ,"value" => 90220),array("tree" => array() ,"value" => 591968)) ,"value" => 84108)) ,"value" => 23143),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 856960),array("tree" => array() ,"value" => 649222),array("tree" => array() ,"value" => 567917),array("tree" => array() ,"value" => 723133)) ,"value" => 990392),array("tree" => array(array("tree" => array() ,"value" => 927666),array("tree" => array() ,"value" => 588436),array("tree" => array() ,"value" => 723924),array("tree" => array() ,"value" => 15214)) ,"value" => 965943),array("tree" => array(array("tree" => array() ,"value" => 767898),array("tree" => array() ,"value" => 781768),array("tree" => array() ,"value" => 708386),array("tree" => array() ,"value" => 832347)) ,"value" => 685188),array("tree" => array(array("tree" => array() ,"value" => 102032),array("tree" => array() ,"value" => 785724),array("tree" => array() ,"value" => 966146),array("tree" => array() ,"value" => 932843)) ,"value" => 262378)) ,"value" => 534074)) ,"value" => 162999)) ,"value" => 153246),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 969463),array("tree" => array() ,"value" => 784197),array("tree" => array() ,"value" => 537647),array("tree" => array() ,"value" => 413822)) ,"value" => 348334),array("tree" => array(array("tree" => array() ,"value" => 639585),array("tree" => array() ,"value" => 728784),array("tree" => array() ,"value" => 190359),array("tree" => array() ,"value" => 229719)) ,"value" => 535670),array("tree" => array(array("tree" => array() ,"value" => 155834),array("tree" => array() ,"value" => 209797),array("tree" => array() ,"value" => 446344),array("tree" => array() ,"value" => 436906)) ,"value" => 188313),array("tree" => array(array("tree" => array() ,"value" => 809859),array("tree" => array() ,"value" => 351012),array("tree" => array() ,"value" => 112721),array("tree" => array() ,"value" => 741056)) ,"value" => 258199)) ,"value" => 471098),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 938629),array("tree" => array() ,"value" => 650160),array("tree" => array() ,"value" => 376780),array("tree" => array() ,"value" => 105550)) ,"value" => 674240),array("tree" => array(array("tree" => array() ,"value" => 932554),array("tree" => array() ,"value" => 541698),array("tree" => array() ,"value" => 682579),array("tree" => array() ,"value" => 48651)) ,"value" => 331589),array("tree" => array(array("tree" => array() ,"value" => 747170),array("tree" => array() ,"value" => 457550),array("tree" => array() ,"value" => 378938),array("tree" => array() ,"value" => 876170)) ,"value" => 375491),array("tree" => array(array("tree" => array() ,"value" => 339730),array("tree" => array() ,"value" => 632368),array("tree" => array() ,"value" => 302253),array("tree" => array() ,"value" => 527928)) ,"value" => 224223)) ,"value" => 480970),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 351935),array("tree" => array() ,"value" => 273324),array("tree" => array() ,"value" => 635084),array("tree" => array() ,"value" => 690860)) ,"value" => 721662),array("tree" => array(array("tree" => array() ,"value" => 679093),array("tree" => array() ,"value" => 824158),array("tree" => array() ,"value" => 778644),array("tree" => array() ,"value" => 98865)) ,"value" => 676499),array("tree" => array(array("tree" => array() ,"value" => 900909),array("tree" => array() ,"value" => 115039),array("tree" => array() ,"value" => 640730),array("tree" => array() ,"value" => 171031)) ,"value" => 227720),array("tree" => array(array("tree" => array() ,"value" => 253329),array("tree" => array() ,"value" => 59564),array("tree" => array() ,"value" => 495268),array("tree" => array() ,"value" => 22677)) ,"value" => 993763)) ,"value" => 139058),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 271194),array("tree" => array() ,"value" => 940622),array("tree" => array() ,"value" => 241510),array("tree" => array() ,"value" => 785224)) ,"value" => 194662),array("tree" => array(array("tree" => array() ,"value" => 904679),array("tree" => array() ,"value" => 83640),array("tree" => array() ,"value" => 521701),array("tree" => array() ,"value" => 976041)) ,"value" => 949834),array("tree" => array(array("tree" => array() ,"value" => 325902),array("tree" => array() ,"value" => 180644),array("tree" => array() ,"value" => 123632),array("tree" => array() ,"value" => 634094)) ,"value" => 791986),array("tree" => array(array("tree" => array() ,"value" => 19823),array("tree" => array() ,"value" => 383385),array("tree" => array() ,"value" => 771195),array("tree" => array() ,"value" => 2965)) ,"value" => 34502)) ,"value" => 305422)) ,"value" => 581850),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 940527),array("tree" => array() ,"value" => 294460),array("tree" => array() ,"value" => 945225),array("tree" => array() ,"value" => 25422)) ,"value" => 387076),array("tree" => array(array("tree" => array() ,"value" => 112680),array("tree" => array() ,"value" => 385317),array("tree" => array() ,"value" => 68546),array("tree" => array() ,"value" => 773120)) ,"value" => 480355),array("tree" => array(array("tree" => array() ,"value" => 410332),array("tree" => array() ,"value" => 785926),array("tree" => array() ,"value" => 413722),array("tree" => array() ,"value" => 206616)) ,"value" => 976934),array("tree" => array(array("tree" => array() ,"value" => 683729),array("tree" => array() ,"value" => 518679),array("tree" => array() ,"value" => 899692),array("tree" => array() ,"value" => 25573)) ,"value" => 139494)) ,"value" => 773413),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 715794),array("tree" => array() ,"value" => 827111),array("tree" => array() ,"value" => 863705),array("tree" => array() ,"value" => 500430)) ,"value" => 535870),array("tree" => array(array("tree" => array() ,"value" => 294050),array("tree" => array() ,"value" => 189456),array("tree" => array() ,"value" => 812109),array("tree" => array() ,"value" => 324647)) ,"value" => 685323),array("tree" => array(array("tree" => array() ,"value" => 368373),array("tree" => array() ,"value" => 359707),array("tree" => array() ,"value" => 998061),array("tree" => array() ,"value" => 96052)) ,"value" => 714258),array("tree" => array(array("tree" => array() ,"value" => 174387),array("tree" => array() ,"value" => 932834),array("tree" => array() ,"value" => 106086),array("tree" => array() ,"value" => 313253)) ,"value" => 895585)) ,"value" => 257942),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 188216),array("tree" => array() ,"value" => 132636),array("tree" => array() ,"value" => 378515),array("tree" => array() ,"value" => 279435)) ,"value" => 333092),array("tree" => array(array("tree" => array() ,"value" => 43184),array("tree" => array() ,"value" => 717902),array("tree" => array() ,"value" => 88041),array("tree" => array() ,"value" => 759223)) ,"value" => 626780),array("tree" => array(array("tree" => array() ,"value" => 20036),array("tree" => array() ,"value" => 461266),array("tree" => array() ,"value" => 169813),array("tree" => array() ,"value" => 751368)) ,"value" => 225297),array("tree" => array(array("tree" => array() ,"value" => 911455),array("tree" => array() ,"value" => 720161),array("tree" => array() ,"value" => 89979),array("tree" => array() ,"value" => 16610)) ,"value" => 968359)) ,"value" => 139287),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 375422),array("tree" => array() ,"value" => 462900),array("tree" => array() ,"value" => 840210),array("tree" => array() ,"value" => 414238)) ,"value" => 682776),array("tree" => array(array("tree" => array() ,"value" => 116108),array("tree" => array() ,"value" => 77777),array("tree" => array() ,"value" => 891920),array("tree" => array() ,"value" => 62225)) ,"value" => 89135),array("tree" => array(array("tree" => array() ,"value" => 804074),array("tree" => array() ,"value" => 351775),array("tree" => array() ,"value" => 602311),array("tree" => array() ,"value" => 157664)) ,"value" => 369125),array("tree" => array(array("tree" => array() ,"value" => 303147),array("tree" => array() ,"value" => 225265),array("tree" => array() ,"value" => 440868),array("tree" => array() ,"value" => 437594)) ,"value" => 113052)) ,"value" => 719313)) ,"value" => 411710),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 167454),array("tree" => array() ,"value" => 56682),array("tree" => array() ,"value" => 418004),array("tree" => array() ,"value" => 320056)) ,"value" => 619169),array("tree" => array(array("tree" => array() ,"value" => 751479),array("tree" => array() ,"value" => 415410),array("tree" => array() ,"value" => 378543),array("tree" => array() ,"value" => 988908)) ,"value" => 46797),array("tree" => array(array("tree" => array() ,"value" => 529668),array("tree" => array() ,"value" => 685392),array("tree" => array() ,"value" => 276217),array("tree" => array() ,"value" => 609967)) ,"value" => 107340),array("tree" => array(array("tree" => array() ,"value" => 178821),array("tree" => array() ,"value" => 542415),array("tree" => array() ,"value" => 514180),array("tree" => array() ,"value" => 491746)) ,"value" => 683106)) ,"value" => 211197),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 238019),array("tree" => array() ,"value" => 457144),array("tree" => array() ,"value" => 490274),array("tree" => array() ,"value" => 427645)) ,"value" => 402131),array("tree" => array(array("tree" => array() ,"value" => 859871),array("tree" => array() ,"value" => 353035),array("tree" => array() ,"value" => 341121),array("tree" => array() ,"value" => 459202)) ,"value" => 18041),array("tree" => array(array("tree" => array() ,"value" => 895160),array("tree" => array() ,"value" => 29487),array("tree" => array() ,"value" => 764315),array("tree" => array() ,"value" => 634987)) ,"value" => 147435),array("tree" => array(array("tree" => array() ,"value" => 693325),array("tree" => array() ,"value" => 448531),array("tree" => array() ,"value" => 128508),array("tree" => array() ,"value" => 390444)) ,"value" => 817503)) ,"value" => 568669),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 538512),array("tree" => array() ,"value" => 829081),array("tree" => array() ,"value" => 198300),array("tree" => array() ,"value" => 18851)) ,"value" => 925331),array("tree" => array(array("tree" => array() ,"value" => 695944),array("tree" => array() ,"value" => 528911),array("tree" => array() ,"value" => 156259),array("tree" => array() ,"value" => 10505)) ,"value" => 998826),array("tree" => array(array("tree" => array() ,"value" => 291539),array("tree" => array() ,"value" => 700937),array("tree" => array() ,"value" => 289676),array("tree" => array() ,"value" => 805797)) ,"value" => 432733),array("tree" => array(array("tree" => array() ,"value" => 147992),array("tree" => array() ,"value" => 388810),array("tree" => array() ,"value" => 409623),array("tree" => array() ,"value" => 16245)) ,"value" => 165313)) ,"value" => 151191),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 533340),array("tree" => array() ,"value" => 603),array("tree" => array() ,"value" => 344876),array("tree" => array() ,"value" => 13187)) ,"value" => 492026),array("tree" => array(array("tree" => array() ,"value" => 587535),array("tree" => array() ,"value" => 386255),array("tree" => array() ,"value" => 759820),array("tree" => array() ,"value" => 952986)) ,"value" => 439930),array("tree" => array(array("tree" => array() ,"value" => 364635),array("tree" => array() ,"value" => 487217),array("tree" => array() ,"value" => 698450),array("tree" => array() ,"value" => 758046)) ,"value" => 563176),array("tree" => array(array("tree" => array() ,"value" => 44908),array("tree" => array() ,"value" => 739148),array("tree" => array() ,"value" => 970507),array("tree" => array() ,"value" => 235060)) ,"value" => 348556)) ,"value" => 741408)) ,"value" => 567828),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 240263),array("tree" => array() ,"value" => 62561),array("tree" => array() ,"value" => 335559),array("tree" => array() ,"value" => 482914)) ,"value" => 235850),array("tree" => array(array("tree" => array() ,"value" => 434636),array("tree" => array() ,"value" => 888370),array("tree" => array() ,"value" => 168985),array("tree" => array() ,"value" => 783493)) ,"value" => 8884),array("tree" => array(array("tree" => array() ,"value" => 246120),array("tree" => array() ,"value" => 667507),array("tree" => array() ,"value" => 82350),array("tree" => array() ,"value" => 732028)) ,"value" => 832976),array("tree" => array(array("tree" => array() ,"value" => 178966),array("tree" => array() ,"value" => 802949),array("tree" => array() ,"value" => 614954),array("tree" => array() ,"value" => 839526)) ,"value" => 903396)) ,"value" => 155565),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 223879),array("tree" => array() ,"value" => 389992),array("tree" => array() ,"value" => 894125),array("tree" => array() ,"value" => 629173)) ,"value" => 410385),array("tree" => array(array("tree" => array() ,"value" => 348253),array("tree" => array() ,"value" => 124065),array("tree" => array() ,"value" => 959025),array("tree" => array() ,"value" => 333139)) ,"value" => 678640),array("tree" => array(array("tree" => array() ,"value" => 612730),array("tree" => array() ,"value" => 844582),array("tree" => array() ,"value" => 470396),array("tree" => array() ,"value" => 568534)) ,"value" => 290155),array("tree" => array(array("tree" => array() ,"value" => 386661),array("tree" => array() ,"value" => 995764),array("tree" => array() ,"value" => 262618),array("tree" => array() ,"value" => 691204)) ,"value" => 283910)) ,"value" => 163819),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 684172),array("tree" => array() ,"value" => 31462),array("tree" => array() ,"value" => 495702),array("tree" => array() ,"value" => 12449)) ,"value" => 872150),array("tree" => array(array("tree" => array() ,"value" => 96995),array("tree" => array() ,"value" => 468974),array("tree" => array() ,"value" => 646926),array("tree" => array() ,"value" => 413678)) ,"value" => 411952),array("tree" => array(array("tree" => array() ,"value" => 41027),array("tree" => array() ,"value" => 675638),array("tree" => array() ,"value" => 685545),array("tree" => array() ,"value" => 818687)) ,"value" => 635358),array("tree" => array(array("tree" => array() ,"value" => 628910),array("tree" => array() ,"value" => 468379),array("tree" => array() ,"value" => 215841),array("tree" => array() ,"value" => 161294)) ,"value" => 196133)) ,"value" => 676298),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 596831),array("tree" => array() ,"value" => 561771),array("tree" => array() ,"value" => 396687),array("tree" => array() ,"value" => 472723)) ,"value" => 555257),array("tree" => array(array("tree" => array() ,"value" => 473110),array("tree" => array() ,"value" => 29139),array("tree" => array() ,"value" => 20608),array("tree" => array() ,"value" => 479707)) ,"value" => 407159),array("tree" => array(array("tree" => array() ,"value" => 800232),array("tree" => array() ,"value" => 958077),array("tree" => array() ,"value" => 302056),array("tree" => array() ,"value" => 355620)) ,"value" => 887983),array("tree" => array(array("tree" => array() ,"value" => 549256),array("tree" => array() ,"value" => 728801),array("tree" => array() ,"value" => 239571),array("tree" => array() ,"value" => 475837)) ,"value" => 303914)) ,"value" => 425714)) ,"value" => 192670)) ,"value" => 728834)) ,"value" => 34023),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 597019),array("tree" => array() ,"value" => 64943),array("tree" => array() ,"value" => 742508),array("tree" => array() ,"value" => 501630)) ,"value" => 912609),array("tree" => array(array("tree" => array() ,"value" => 238887),array("tree" => array() ,"value" => 665870),array("tree" => array() ,"value" => 700187),array("tree" => array() ,"value" => 117327)) ,"value" => 162390),array("tree" => array(array("tree" => array() ,"value" => 673762),array("tree" => array() ,"value" => 350842),array("tree" => array() ,"value" => 69992),array("tree" => array() ,"value" => 362204)) ,"value" => 826571),array("tree" => array(array("tree" => array() ,"value" => 602421),array("tree" => array() ,"value" => 670374),array("tree" => array() ,"value" => 198181),array("tree" => array() ,"value" => 515784)) ,"value" => 264345)) ,"value" => 549846),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 352821),array("tree" => array() ,"value" => 551023),array("tree" => array() ,"value" => 305640),array("tree" => array() ,"value" => 347865)) ,"value" => 611953),array("tree" => array(array("tree" => array() ,"value" => 494091),array("tree" => array() ,"value" => 727963),array("tree" => array() ,"value" => 708817),array("tree" => array() ,"value" => 611611)) ,"value" => 358248),array("tree" => array(array("tree" => array() ,"value" => 950969),array("tree" => array() ,"value" => 247274),array("tree" => array() ,"value" => 152904),array("tree" => array() ,"value" => 697133)) ,"value" => 199432),array("tree" => array(array("tree" => array() ,"value" => 16434),array("tree" => array() ,"value" => 297328),array("tree" => array() ,"value" => 863931),array("tree" => array() ,"value" => 327177)) ,"value" => 325328)) ,"value" => 347961),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 908578),array("tree" => array() ,"value" => 285041),array("tree" => array() ,"value" => 427055),array("tree" => array() ,"value" => 62091)) ,"value" => 328382),array("tree" => array(array("tree" => array() ,"value" => 568424),array("tree" => array() ,"value" => 899624),array("tree" => array() ,"value" => 95060),array("tree" => array() ,"value" => 935921)) ,"value" => 297359),array("tree" => array(array("tree" => array() ,"value" => 371444),array("tree" => array() ,"value" => 275833),array("tree" => array() ,"value" => 462204),array("tree" => array() ,"value" => 286418)) ,"value" => 589797),array("tree" => array(array("tree" => array() ,"value" => 732354),array("tree" => array() ,"value" => 521813),array("tree" => array() ,"value" => 726111),array("tree" => array() ,"value" => 947271)) ,"value" => 606492)) ,"value" => 26414),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 81713),array("tree" => array() ,"value" => 673871),array("tree" => array() ,"value" => 967323),array("tree" => array() ,"value" => 777156)) ,"value" => 958209),array("tree" => array(array("tree" => array() ,"value" => 708857),array("tree" => array() ,"value" => 393222),array("tree" => array() ,"value" => 696583),array("tree" => array() ,"value" => 741159)) ,"value" => 14600),array("tree" => array(array("tree" => array() ,"value" => 833441),array("tree" => array() ,"value" => 325320),array("tree" => array() ,"value" => 447815),array("tree" => array() ,"value" => 590201)) ,"value" => 388721),array("tree" => array(array("tree" => array() ,"value" => 96421),array("tree" => array() ,"value" => 595343),array("tree" => array() ,"value" => 32652),array("tree" => array() ,"value" => 373586)) ,"value" => 41340)) ,"value" => 413726)) ,"value" => 785126),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 219170),array("tree" => array() ,"value" => 32267),array("tree" => array() ,"value" => 826717),array("tree" => array() ,"value" => 785523)) ,"value" => 608393),array("tree" => array(array("tree" => array() ,"value" => 821613),array("tree" => array() ,"value" => 568610),array("tree" => array() ,"value" => 499843),array("tree" => array() ,"value" => 276187)) ,"value" => 324052),array("tree" => array(array("tree" => array() ,"value" => 67282),array("tree" => array() ,"value" => 676696),array("tree" => array() ,"value" => 413380),array("tree" => array() ,"value" => 57924)) ,"value" => 371321),array("tree" => array(array("tree" => array() ,"value" => 306780),array("tree" => array() ,"value" => 893071),array("tree" => array() ,"value" => 158280),array("tree" => array() ,"value" => 176619)) ,"value" => 617940)) ,"value" => 182841),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 275752),array("tree" => array() ,"value" => 910715),array("tree" => array() ,"value" => 453561),array("tree" => array() ,"value" => 868085)) ,"value" => 66417),array("tree" => array(array("tree" => array() ,"value" => 590398),array("tree" => array() ,"value" => 810495),array("tree" => array() ,"value" => 819875),array("tree" => array() ,"value" => 762299)) ,"value" => 13698),array("tree" => array(array("tree" => array() ,"value" => 613924),array("tree" => array() ,"value" => 588869),array("tree" => array() ,"value" => 56792),array("tree" => array() ,"value" => 54585)) ,"value" => 13829),array("tree" => array(array("tree" => array() ,"value" => 648822),array("tree" => array() ,"value" => 882582),array("tree" => array() ,"value" => 213822),array("tree" => array() ,"value" => 808768)) ,"value" => 907302)) ,"value" => 120609),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 480201),array("tree" => array() ,"value" => 402174),array("tree" => array() ,"value" => 987229),array("tree" => array() ,"value" => 924682)) ,"value" => 742740),array("tree" => array(array("tree" => array() ,"value" => 703547),array("tree" => array() ,"value" => 432417),array("tree" => array() ,"value" => 439258),array("tree" => array() ,"value" => 73125)) ,"value" => 85334),array("tree" => array(array("tree" => array() ,"value" => 825955),array("tree" => array() ,"value" => 463277),array("tree" => array() ,"value" => 386291),array("tree" => array() ,"value" => 515983)) ,"value" => 623853),array("tree" => array(array("tree" => array() ,"value" => 744718),array("tree" => array() ,"value" => 89546),array("tree" => array() ,"value" => 586607),array("tree" => array() ,"value" => 92755)) ,"value" => 398393)) ,"value" => 847655),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 517633),array("tree" => array() ,"value" => 305061),array("tree" => array() ,"value" => 885939),array("tree" => array() ,"value" => 772866)) ,"value" => 768918),array("tree" => array(array("tree" => array() ,"value" => 133461),array("tree" => array() ,"value" => 295626),array("tree" => array() ,"value" => 668546),array("tree" => array() ,"value" => 675967)) ,"value" => 54807),array("tree" => array(array("tree" => array() ,"value" => 26528),array("tree" => array() ,"value" => 951767),array("tree" => array() ,"value" => 824584),array("tree" => array() ,"value" => 445630)) ,"value" => 348539),array("tree" => array(array("tree" => array() ,"value" => 229715),array("tree" => array() ,"value" => 398757),array("tree" => array() ,"value" => 784312),array("tree" => array() ,"value" => 516776)) ,"value" => 842739)) ,"value" => 663421)) ,"value" => 644560),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 631575),array("tree" => array() ,"value" => 607001),array("tree" => array() ,"value" => 739701),array("tree" => array() ,"value" => 278472)) ,"value" => 116653),array("tree" => array(array("tree" => array() ,"value" => 364527),array("tree" => array() ,"value" => 266274),array("tree" => array() ,"value" => 430524),array("tree" => array() ,"value" => 108272)) ,"value" => 5594),array("tree" => array(array("tree" => array() ,"value" => 179508),array("tree" => array() ,"value" => 742594),array("tree" => array() ,"value" => 303071),array("tree" => array() ,"value" => 536334)) ,"value" => 719123),array("tree" => array(array("tree" => array() ,"value" => 832147),array("tree" => array() ,"value" => 337645),array("tree" => array() ,"value" => 224954),array("tree" => array() ,"value" => 250586)) ,"value" => 53152)) ,"value" => 730732),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 486201),array("tree" => array() ,"value" => 398252),array("tree" => array() ,"value" => 547142),array("tree" => array() ,"value" => 493270)) ,"value" => 249100),array("tree" => array(array("tree" => array() ,"value" => 525740),array("tree" => array() ,"value" => 619399),array("tree" => array() ,"value" => 751171),array("tree" => array() ,"value" => 80424)) ,"value" => 783541),array("tree" => array(array("tree" => array() ,"value" => 646562),array("tree" => array() ,"value" => 940298),array("tree" => array() ,"value" => 954816),array("tree" => array() ,"value" => 586340)) ,"value" => 532060),array("tree" => array(array("tree" => array() ,"value" => 223372),array("tree" => array() ,"value" => 47122),array("tree" => array() ,"value" => 455386),array("tree" => array() ,"value" => 349463)) ,"value" => 572144)) ,"value" => 763126),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 433024),array("tree" => array() ,"value" => 852542),array("tree" => array() ,"value" => 30977),array("tree" => array() ,"value" => 625)) ,"value" => 758746),array("tree" => array(array("tree" => array() ,"value" => 925516),array("tree" => array() ,"value" => 717896),array("tree" => array() ,"value" => 611580),array("tree" => array() ,"value" => 874180)) ,"value" => 152014),array("tree" => array(array("tree" => array() ,"value" => 322440),array("tree" => array() ,"value" => 484275),array("tree" => array() ,"value" => 165807),array("tree" => array() ,"value" => 852877)) ,"value" => 230921),array("tree" => array(array("tree" => array() ,"value" => 465961),array("tree" => array() ,"value" => 130724),array("tree" => array() ,"value" => 51313),array("tree" => array() ,"value" => 422408)) ,"value" => 836516)) ,"value" => 10830),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 815841),array("tree" => array() ,"value" => 268938),array("tree" => array() ,"value" => 803211),array("tree" => array() ,"value" => 879870)) ,"value" => 811094),array("tree" => array(array("tree" => array() ,"value" => 49854),array("tree" => array() ,"value" => 313908),array("tree" => array() ,"value" => 5061),array("tree" => array() ,"value" => 602236)) ,"value" => 749401),array("tree" => array(array("tree" => array() ,"value" => 849),array("tree" => array() ,"value" => 521803),array("tree" => array() ,"value" => 71046),array("tree" => array() ,"value" => 392544)) ,"value" => 257930),array("tree" => array(array("tree" => array() ,"value" => 553511),array("tree" => array() ,"value" => 299011),array("tree" => array() ,"value" => 365977),array("tree" => array() ,"value" => 39534)) ,"value" => 772045)) ,"value" => 860958)) ,"value" => 476105),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 297950),array("tree" => array() ,"value" => 43246),array("tree" => array() ,"value" => 510812),array("tree" => array() ,"value" => 145672)) ,"value" => 421363),array("tree" => array(array("tree" => array() ,"value" => 681931),array("tree" => array() ,"value" => 596969),array("tree" => array() ,"value" => 714679),array("tree" => array() ,"value" => 588168)) ,"value" => 764486),array("tree" => array(array("tree" => array() ,"value" => 340191),array("tree" => array() ,"value" => 841611),array("tree" => array() ,"value" => 322007),array("tree" => array() ,"value" => 188789)) ,"value" => 582394),array("tree" => array(array("tree" => array() ,"value" => 648843),array("tree" => array() ,"value" => 384111),array("tree" => array() ,"value" => 399132),array("tree" => array() ,"value" => 536565)) ,"value" => 738305)) ,"value" => 101304),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 664519),array("tree" => array() ,"value" => 604353),array("tree" => array() ,"value" => 422082),array("tree" => array() ,"value" => 636442)) ,"value" => 102146),array("tree" => array(array("tree" => array() ,"value" => 285690),array("tree" => array() ,"value" => 11837),array("tree" => array() ,"value" => 85787),array("tree" => array() ,"value" => 877064)) ,"value" => 95939),array("tree" => array(array("tree" => array() ,"value" => 638102),array("tree" => array() ,"value" => 2875),array("tree" => array() ,"value" => 664764),array("tree" => array() ,"value" => 637300)) ,"value" => 554013),array("tree" => array(array("tree" => array() ,"value" => 263686),array("tree" => array() ,"value" => 506480),array("tree" => array() ,"value" => 441000),array("tree" => array() ,"value" => 414797)) ,"value" => 358644)) ,"value" => 852716),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 990037),array("tree" => array() ,"value" => 87837),array("tree" => array() ,"value" => 830568),array("tree" => array() ,"value" => 15348)) ,"value" => 838164),array("tree" => array(array("tree" => array() ,"value" => 315075),array("tree" => array() ,"value" => 723203),array("tree" => array() ,"value" => 686026),array("tree" => array() ,"value" => 875023)) ,"value" => 537488),array("tree" => array(array("tree" => array() ,"value" => 102611),array("tree" => array() ,"value" => 571811),array("tree" => array() ,"value" => 129419),array("tree" => array() ,"value" => 88764)) ,"value" => 218257),array("tree" => array(array("tree" => array() ,"value" => 287622),array("tree" => array() ,"value" => 704068),array("tree" => array() ,"value" => 806816),array("tree" => array() ,"value" => 556735)) ,"value" => 965534)) ,"value" => 56164),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 823173),array("tree" => array() ,"value" => 857959),array("tree" => array() ,"value" => 457771),array("tree" => array() ,"value" => 465029)) ,"value" => 898882),array("tree" => array(array("tree" => array() ,"value" => 929037),array("tree" => array() ,"value" => 975784),array("tree" => array() ,"value" => 168758),array("tree" => array() ,"value" => 432444)) ,"value" => 225836),array("tree" => array(array("tree" => array() ,"value" => 906280),array("tree" => array() ,"value" => 381998),array("tree" => array() ,"value" => 129665),array("tree" => array() ,"value" => 130180)) ,"value" => 245820),array("tree" => array(array("tree" => array() ,"value" => 826786),array("tree" => array() ,"value" => 510232),array("tree" => array() ,"value" => 620),array("tree" => array() ,"value" => 808941)) ,"value" => 962330)) ,"value" => 152684)) ,"value" => 556063)) ,"value" => 530107),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 812309),array("tree" => array() ,"value" => 271029),array("tree" => array() ,"value" => 711798),array("tree" => array() ,"value" => 288810)) ,"value" => 449531),array("tree" => array(array("tree" => array() ,"value" => 18998),array("tree" => array() ,"value" => 163957),array("tree" => array() ,"value" => 489697),array("tree" => array() ,"value" => 467923)) ,"value" => 775802),array("tree" => array(array("tree" => array() ,"value" => 987251),array("tree" => array() ,"value" => 388075),array("tree" => array() ,"value" => 232093),array("tree" => array() ,"value" => 319499)) ,"value" => 115525),array("tree" => array(array("tree" => array() ,"value" => 237361),array("tree" => array() ,"value" => 788600),array("tree" => array() ,"value" => 63024),array("tree" => array() ,"value" => 763164)) ,"value" => 447276)) ,"value" => 947955),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 442181),array("tree" => array() ,"value" => 52351),array("tree" => array() ,"value" => 872883),array("tree" => array() ,"value" => 626446)) ,"value" => 530187),array("tree" => array(array("tree" => array() ,"value" => 154077),array("tree" => array() ,"value" => 537383),array("tree" => array() ,"value" => 449698),array("tree" => array() ,"value" => 895154)) ,"value" => 531592),array("tree" => array(array("tree" => array() ,"value" => 885414),array("tree" => array() ,"value" => 948792),array("tree" => array() ,"value" => 642432),array("tree" => array() ,"value" => 711357)) ,"value" => 794166),array("tree" => array(array("tree" => array() ,"value" => 73802),array("tree" => array() ,"value" => 563874),array("tree" => array() ,"value" => 762468),array("tree" => array() ,"value" => 132354)) ,"value" => 39594)) ,"value" => 600200),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 105142),array("tree" => array() ,"value" => 517739),array("tree" => array() ,"value" => 299435),array("tree" => array() ,"value" => 746085)) ,"value" => 694003),array("tree" => array(array("tree" => array() ,"value" => 697803),array("tree" => array() ,"value" => 764731),array("tree" => array() ,"value" => 623581),array("tree" => array() ,"value" => 559114)) ,"value" => 120922),array("tree" => array(array("tree" => array() ,"value" => 942199),array("tree" => array() ,"value" => 983587),array("tree" => array() ,"value" => 445103),array("tree" => array() ,"value" => 999480)) ,"value" => 991695),array("tree" => array(array("tree" => array() ,"value" => 23171),array("tree" => array() ,"value" => 5258),array("tree" => array() ,"value" => 340128),array("tree" => array() ,"value" => 186196)) ,"value" => 345927)) ,"value" => 576888),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 763875),array("tree" => array() ,"value" => 305841),array("tree" => array() ,"value" => 257351),array("tree" => array() ,"value" => 89927)) ,"value" => 322265),array("tree" => array(array("tree" => array() ,"value" => 550218),array("tree" => array() ,"value" => 936150),array("tree" => array() ,"value" => 595357),array("tree" => array() ,"value" => 30527)) ,"value" => 96834),array("tree" => array(array("tree" => array() ,"value" => 638729),array("tree" => array() ,"value" => 676394),array("tree" => array() ,"value" => 707036),array("tree" => array() ,"value" => 631658)) ,"value" => 182100),array("tree" => array(array("tree" => array() ,"value" => 534497),array("tree" => array() ,"value" => 285126),array("tree" => array() ,"value" => 729510),array("tree" => array() ,"value" => 294969)) ,"value" => 818258)) ,"value" => 88624)) ,"value" => 981166),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 186951),array("tree" => array() ,"value" => 698672),array("tree" => array() ,"value" => 855733),array("tree" => array() ,"value" => 571365)) ,"value" => 945083),array("tree" => array(array("tree" => array() ,"value" => 337585),array("tree" => array() ,"value" => 252190),array("tree" => array() ,"value" => 550126),array("tree" => array() ,"value" => 280969)) ,"value" => 157822),array("tree" => array(array("tree" => array() ,"value" => 812000),array("tree" => array() ,"value" => 594458),array("tree" => array() ,"value" => 378597),array("tree" => array() ,"value" => 501876)) ,"value" => 381764),array("tree" => array(array("tree" => array() ,"value" => 382914),array("tree" => array() ,"value" => 270666),array("tree" => array() ,"value" => 969815),array("tree" => array() ,"value" => 916476)) ,"value" => 714823)) ,"value" => 238578),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 57599),array("tree" => array() ,"value" => 861545),array("tree" => array() ,"value" => 540042),array("tree" => array() ,"value" => 464949)) ,"value" => 353472),array("tree" => array(array("tree" => array() ,"value" => 150137),array("tree" => array() ,"value" => 405430),array("tree" => array() ,"value" => 365415),array("tree" => array() ,"value" => 224395)) ,"value" => 202717),array("tree" => array(array("tree" => array() ,"value" => 282315),array("tree" => array() ,"value" => 183730),array("tree" => array() ,"value" => 536698),array("tree" => array() ,"value" => 880518)) ,"value" => 388515),array("tree" => array(array("tree" => array() ,"value" => 802895),array("tree" => array() ,"value" => 249370),array("tree" => array() ,"value" => 880085),array("tree" => array() ,"value" => 146715)) ,"value" => 968012)) ,"value" => 699474),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 164539),array("tree" => array() ,"value" => 628909),array("tree" => array() ,"value" => 544288),array("tree" => array() ,"value" => 797648)) ,"value" => 398434),array("tree" => array(array("tree" => array() ,"value" => 701174),array("tree" => array() ,"value" => 858078),array("tree" => array() ,"value" => 782674),array("tree" => array() ,"value" => 910906)) ,"value" => 251519),array("tree" => array(array("tree" => array() ,"value" => 728233),array("tree" => array() ,"value" => 337791),array("tree" => array() ,"value" => 417747),array("tree" => array() ,"value" => 714575)) ,"value" => 92994),array("tree" => array(array("tree" => array() ,"value" => 930382),array("tree" => array() ,"value" => 760415),array("tree" => array() ,"value" => 801724),array("tree" => array() ,"value" => 839471)) ,"value" => 97270)) ,"value" => 497165),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 738068),array("tree" => array() ,"value" => 339276),array("tree" => array() ,"value" => 138201),array("tree" => array() ,"value" => 12003)) ,"value" => 343824),array("tree" => array(array("tree" => array() ,"value" => 631164),array("tree" => array() ,"value" => 89927),array("tree" => array() ,"value" => 769038),array("tree" => array() ,"value" => 555324)) ,"value" => 55112),array("tree" => array(array("tree" => array() ,"value" => 910001),array("tree" => array() ,"value" => 859181),array("tree" => array() ,"value" => 135915),array("tree" => array() ,"value" => 361216)) ,"value" => 964898),array("tree" => array(array("tree" => array() ,"value" => 470694),array("tree" => array() ,"value" => 336808),array("tree" => array() ,"value" => 966195),array("tree" => array() ,"value" => 200813)) ,"value" => 18482)) ,"value" => 756600)) ,"value" => 533881),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 2976),array("tree" => array() ,"value" => 434963),array("tree" => array() ,"value" => 979927),array("tree" => array() ,"value" => 479293)) ,"value" => 239421),array("tree" => array(array("tree" => array() ,"value" => 94371),array("tree" => array() ,"value" => 543745),array("tree" => array() ,"value" => 107108),array("tree" => array() ,"value" => 226037)) ,"value" => 53167),array("tree" => array(array("tree" => array() ,"value" => 586403),array("tree" => array() ,"value" => 713162),array("tree" => array() ,"value" => 84313),array("tree" => array() ,"value" => 263136)) ,"value" => 374798),array("tree" => array(array("tree" => array() ,"value" => 843843),array("tree" => array() ,"value" => 429224),array("tree" => array() ,"value" => 955777),array("tree" => array() ,"value" => 658635)) ,"value" => 574863)) ,"value" => 660514),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 508486),array("tree" => array() ,"value" => 399792),array("tree" => array() ,"value" => 436101),array("tree" => array() ,"value" => 712017)) ,"value" => 823416),array("tree" => array(array("tree" => array() ,"value" => 817267),array("tree" => array() ,"value" => 409357),array("tree" => array() ,"value" => 822460),array("tree" => array() ,"value" => 98244)) ,"value" => 470390),array("tree" => array(array("tree" => array() ,"value" => 87508),array("tree" => array() ,"value" => 309474),array("tree" => array() ,"value" => 366695),array("tree" => array() ,"value" => 189084)) ,"value" => 802386),array("tree" => array(array("tree" => array() ,"value" => 794993),array("tree" => array() ,"value" => 878902),array("tree" => array() ,"value" => 773366),array("tree" => array() ,"value" => 334159)) ,"value" => 689785)) ,"value" => 475810),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 217555),array("tree" => array() ,"value" => 421479),array("tree" => array() ,"value" => 803155),array("tree" => array() ,"value" => 40846)) ,"value" => 297721),array("tree" => array(array("tree" => array() ,"value" => 505837),array("tree" => array() ,"value" => 888740),array("tree" => array() ,"value" => 702667),array("tree" => array() ,"value" => 883416)) ,"value" => 637539),array("tree" => array(array("tree" => array() ,"value" => 945453),array("tree" => array() ,"value" => 75181),array("tree" => array() ,"value" => 94346),array("tree" => array() ,"value" => 608931)) ,"value" => 665573),array("tree" => array(array("tree" => array() ,"value" => 870594),array("tree" => array() ,"value" => 937797),array("tree" => array() ,"value" => 591391),array("tree" => array() ,"value" => 278793)) ,"value" => 903642)) ,"value" => 232260),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 354863),array("tree" => array() ,"value" => 637343),array("tree" => array() ,"value" => 938432),array("tree" => array() ,"value" => 591828)) ,"value" => 192243),array("tree" => array(array("tree" => array() ,"value" => 630246),array("tree" => array() ,"value" => 558618),array("tree" => array() ,"value" => 900699),array("tree" => array() ,"value" => 680982)) ,"value" => 716146),array("tree" => array(array("tree" => array() ,"value" => 102279),array("tree" => array() ,"value" => 695531),array("tree" => array() ,"value" => 631579),array("tree" => array() ,"value" => 168605)) ,"value" => 182276),array("tree" => array(array("tree" => array() ,"value" => 956999),array("tree" => array() ,"value" => 559866),array("tree" => array() ,"value" => 21260),array("tree" => array() ,"value" => 277429)) ,"value" => 147606)) ,"value" => 675208)) ,"value" => 171667),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 57111),array("tree" => array() ,"value" => 802075),array("tree" => array() ,"value" => 800868),array("tree" => array() ,"value" => 367694)) ,"value" => 110027),array("tree" => array(array("tree" => array() ,"value" => 200661),array("tree" => array() ,"value" => 602769),array("tree" => array() ,"value" => 390321),array("tree" => array() ,"value" => 595730)) ,"value" => 198451),array("tree" => array(array("tree" => array() ,"value" => 210540),array("tree" => array() ,"value" => 863541),array("tree" => array() ,"value" => 625753),array("tree" => array() ,"value" => 338938)) ,"value" => 473041),array("tree" => array(array("tree" => array() ,"value" => 812469),array("tree" => array() ,"value" => 667417),array("tree" => array() ,"value" => 507369),array("tree" => array() ,"value" => 121427)) ,"value" => 841902)) ,"value" => 694455),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 220708),array("tree" => array() ,"value" => 603569),array("tree" => array() ,"value" => 992613),array("tree" => array() ,"value" => 208843)) ,"value" => 692559),array("tree" => array(array("tree" => array() ,"value" => 932946),array("tree" => array() ,"value" => 255176),array("tree" => array() ,"value" => 949942),array("tree" => array() ,"value" => 176904)) ,"value" => 874323),array("tree" => array(array("tree" => array() ,"value" => 131968),array("tree" => array() ,"value" => 675742),array("tree" => array() ,"value" => 362988),array("tree" => array() ,"value" => 144318)) ,"value" => 268590),array("tree" => array(array("tree" => array() ,"value" => 258196),array("tree" => array() ,"value" => 887941),array("tree" => array() ,"value" => 811828),array("tree" => array() ,"value" => 700015)) ,"value" => 698150)) ,"value" => 172569),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 563526),array("tree" => array() ,"value" => 884045),array("tree" => array() ,"value" => 436852),array("tree" => array() ,"value" => 291932)) ,"value" => 458490),array("tree" => array(array("tree" => array() ,"value" => 372347),array("tree" => array() ,"value" => 5221),array("tree" => array() ,"value" => 878418),array("tree" => array() ,"value" => 321885)) ,"value" => 29649),array("tree" => array(array("tree" => array() ,"value" => 831525),array("tree" => array() ,"value" => 266118),array("tree" => array() ,"value" => 644070),array("tree" => array() ,"value" => 203322)) ,"value" => 39430),array("tree" => array(array("tree" => array() ,"value" => 806882),array("tree" => array() ,"value" => 114882),array("tree" => array() ,"value" => 673968),array("tree" => array() ,"value" => 710288)) ,"value" => 199597)) ,"value" => 13403),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 340415),array("tree" => array() ,"value" => 465069),array("tree" => array() ,"value" => 216190),array("tree" => array() ,"value" => 864672)) ,"value" => 338347),array("tree" => array(array("tree" => array() ,"value" => 372031),array("tree" => array() ,"value" => 194311),array("tree" => array() ,"value" => 835111),array("tree" => array() ,"value" => 30691)) ,"value" => 586642),array("tree" => array(array("tree" => array() ,"value" => 315525),array("tree" => array() ,"value" => 412339),array("tree" => array() ,"value" => 926970),array("tree" => array() ,"value" => 408430)) ,"value" => 990363),array("tree" => array(array("tree" => array() ,"value" => 316303),array("tree" => array() ,"value" => 839157),array("tree" => array() ,"value" => 451395),array("tree" => array() ,"value" => 879610)) ,"value" => 762622)) ,"value" => 729099)) ,"value" => 10633)) ,"value" => 951133),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 72574),array("tree" => array() ,"value" => 541478),array("tree" => array() ,"value" => 111354),array("tree" => array() ,"value" => 439579)) ,"value" => 886255),array("tree" => array(array("tree" => array() ,"value" => 726746),array("tree" => array() ,"value" => 954933),array("tree" => array() ,"value" => 509426),array("tree" => array() ,"value" => 956900)) ,"value" => 336304),array("tree" => array(array("tree" => array() ,"value" => 327767),array("tree" => array() ,"value" => 34604),array("tree" => array() ,"value" => 696685),array("tree" => array() ,"value" => 103853)) ,"value" => 473614),array("tree" => array(array("tree" => array() ,"value" => 905912),array("tree" => array() ,"value" => 566581),array("tree" => array() ,"value" => 199332),array("tree" => array() ,"value" => 546052)) ,"value" => 3536)) ,"value" => 453832),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 431733),array("tree" => array() ,"value" => 178779),array("tree" => array() ,"value" => 155763),array("tree" => array() ,"value" => 460937)) ,"value" => 943784),array("tree" => array(array("tree" => array() ,"value" => 17900),array("tree" => array() ,"value" => 324702),array("tree" => array() ,"value" => 650065),array("tree" => array() ,"value" => 966993)) ,"value" => 995981),array("tree" => array(array("tree" => array() ,"value" => 590486),array("tree" => array() ,"value" => 654279),array("tree" => array() ,"value" => 319773),array("tree" => array() ,"value" => 15531)) ,"value" => 991060),array("tree" => array(array("tree" => array() ,"value" => 929867),array("tree" => array() ,"value" => 595630),array("tree" => array() ,"value" => 476719),array("tree" => array() ,"value" => 537538)) ,"value" => 197688)) ,"value" => 662392),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 349874),array("tree" => array() ,"value" => 940973),array("tree" => array() ,"value" => 716159),array("tree" => array() ,"value" => 323440)) ,"value" => 734276),array("tree" => array(array("tree" => array() ,"value" => 274163),array("tree" => array() ,"value" => 184834),array("tree" => array() ,"value" => 865866),array("tree" => array() ,"value" => 405891)) ,"value" => 145641),array("tree" => array(array("tree" => array() ,"value" => 733659),array("tree" => array() ,"value" => 83027),array("tree" => array() ,"value" => 232406),array("tree" => array() ,"value" => 252138)) ,"value" => 641465),array("tree" => array(array("tree" => array() ,"value" => 708316),array("tree" => array() ,"value" => 538918),array("tree" => array() ,"value" => 536440),array("tree" => array() ,"value" => 315512)) ,"value" => 842630)) ,"value" => 202403),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 903958),array("tree" => array() ,"value" => 80185),array("tree" => array() ,"value" => 620706),array("tree" => array() ,"value" => 73809)) ,"value" => 928047),array("tree" => array(array("tree" => array() ,"value" => 615055),array("tree" => array() ,"value" => 331818),array("tree" => array() ,"value" => 706843),array("tree" => array() ,"value" => 130866)) ,"value" => 173335),array("tree" => array(array("tree" => array() ,"value" => 833597),array("tree" => array() ,"value" => 510020),array("tree" => array() ,"value" => 416965),array("tree" => array() ,"value" => 221436)) ,"value" => 240650),array("tree" => array(array("tree" => array() ,"value" => 681361),array("tree" => array() ,"value" => 831289),array("tree" => array() ,"value" => 8380),array("tree" => array() ,"value" => 42268)) ,"value" => 216316)) ,"value" => 663107)) ,"value" => 261445),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 37953),array("tree" => array() ,"value" => 877353),array("tree" => array() ,"value" => 283932),array("tree" => array() ,"value" => 123467)) ,"value" => 433673),array("tree" => array(array("tree" => array() ,"value" => 584698),array("tree" => array() ,"value" => 717886),array("tree" => array() ,"value" => 840047),array("tree" => array() ,"value" => 244680)) ,"value" => 630113),array("tree" => array(array("tree" => array() ,"value" => 202411),array("tree" => array() ,"value" => 989688),array("tree" => array() ,"value" => 756437),array("tree" => array() ,"value" => 194027)) ,"value" => 153332),array("tree" => array(array("tree" => array() ,"value" => 485491),array("tree" => array() ,"value" => 376586),array("tree" => array() ,"value" => 743974),array("tree" => array() ,"value" => 610810)) ,"value" => 843244)) ,"value" => 995972),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 91644),array("tree" => array() ,"value" => 56494),array("tree" => array() ,"value" => 649005),array("tree" => array() ,"value" => 46200)) ,"value" => 471886),array("tree" => array(array("tree" => array() ,"value" => 103845),array("tree" => array() ,"value" => 860577),array("tree" => array() ,"value" => 414339),array("tree" => array() ,"value" => 472322)) ,"value" => 12857),array("tree" => array(array("tree" => array() ,"value" => 832974),array("tree" => array() ,"value" => 377366),array("tree" => array() ,"value" => 976998),array("tree" => array() ,"value" => 667009)) ,"value" => 309389),array("tree" => array(array("tree" => array() ,"value" => 595637),array("tree" => array() ,"value" => 599201),array("tree" => array() ,"value" => 464245),array("tree" => array() ,"value" => 825378)) ,"value" => 406747)) ,"value" => 851576),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 805266),array("tree" => array() ,"value" => 600271),array("tree" => array() ,"value" => 32868),array("tree" => array() ,"value" => 5108)) ,"value" => 91406),array("tree" => array(array("tree" => array() ,"value" => 621065),array("tree" => array() ,"value" => 229651),array("tree" => array() ,"value" => 648715),array("tree" => array() ,"value" => 753499)) ,"value" => 868316),array("tree" => array(array("tree" => array() ,"value" => 162270),array("tree" => array() ,"value" => 460678),array("tree" => array() ,"value" => 315235),array("tree" => array() ,"value" => 701234)) ,"value" => 143617),array("tree" => array(array("tree" => array() ,"value" => 532870),array("tree" => array() ,"value" => 25868),array("tree" => array() ,"value" => 725675),array("tree" => array() ,"value" => 572955)) ,"value" => 336817)) ,"value" => 880143),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 612337),array("tree" => array() ,"value" => 267198),array("tree" => array() ,"value" => 526191),array("tree" => array() ,"value" => 921802)) ,"value" => 810143),array("tree" => array(array("tree" => array() ,"value" => 775134),array("tree" => array() ,"value" => 396108),array("tree" => array() ,"value" => 189667),array("tree" => array() ,"value" => 256655)) ,"value" => 577954),array("tree" => array(array("tree" => array() ,"value" => 423956),array("tree" => array() ,"value" => 127679),array("tree" => array() ,"value" => 104141),array("tree" => array() ,"value" => 334836)) ,"value" => 829059),array("tree" => array(array("tree" => array() ,"value" => 305207),array("tree" => array() ,"value" => 464140),array("tree" => array() ,"value" => 167242),array("tree" => array() ,"value" => 286479)) ,"value" => 788293)) ,"value" => 644173)) ,"value" => 120168),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 386519),array("tree" => array() ,"value" => 936658),array("tree" => array() ,"value" => 406839),array("tree" => array() ,"value" => 298199)) ,"value" => 761028),array("tree" => array(array("tree" => array() ,"value" => 28869),array("tree" => array() ,"value" => 505302),array("tree" => array() ,"value" => 156424),array("tree" => array() ,"value" => 77773)) ,"value" => 900864),array("tree" => array(array("tree" => array() ,"value" => 158780),array("tree" => array() ,"value" => 758693),array("tree" => array() ,"value" => 380492),array("tree" => array() ,"value" => 575223)) ,"value" => 74311),array("tree" => array(array("tree" => array() ,"value" => 653217),array("tree" => array() ,"value" => 801991),array("tree" => array() ,"value" => 791113),array("tree" => array() ,"value" => 306768)) ,"value" => 939985)) ,"value" => 11173),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 84520),array("tree" => array() ,"value" => 658456),array("tree" => array() ,"value" => 874171),array("tree" => array() ,"value" => 532731)) ,"value" => 866265),array("tree" => array(array("tree" => array() ,"value" => 661272),array("tree" => array() ,"value" => 223635),array("tree" => array() ,"value" => 645419),array("tree" => array() ,"value" => 855794)) ,"value" => 701619),array("tree" => array(array("tree" => array() ,"value" => 889007),array("tree" => array() ,"value" => 298707),array("tree" => array() ,"value" => 316573),array("tree" => array() ,"value" => 271399)) ,"value" => 758005),array("tree" => array(array("tree" => array() ,"value" => 710158),array("tree" => array() ,"value" => 235766),array("tree" => array() ,"value" => 398854),array("tree" => array() ,"value" => 954888)) ,"value" => 822397)) ,"value" => 865383),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 913161),array("tree" => array() ,"value" => 81521),array("tree" => array() ,"value" => 712470),array("tree" => array() ,"value" => 128511)) ,"value" => 803929),array("tree" => array(array("tree" => array() ,"value" => 55325),array("tree" => array() ,"value" => 779120),array("tree" => array() ,"value" => 895856),array("tree" => array() ,"value" => 368700)) ,"value" => 210729),array("tree" => array(array("tree" => array() ,"value" => 130710),array("tree" => array() ,"value" => 935901),array("tree" => array() ,"value" => 960114),array("tree" => array() ,"value" => 274151)) ,"value" => 549325),array("tree" => array(array("tree" => array() ,"value" => 815328),array("tree" => array() ,"value" => 421853),array("tree" => array() ,"value" => 859637),array("tree" => array() ,"value" => 566384)) ,"value" => 457529)) ,"value" => 452234),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 535449),array("tree" => array() ,"value" => 888598),array("tree" => array() ,"value" => 833122),array("tree" => array() ,"value" => 466305)) ,"value" => 565054),array("tree" => array(array("tree" => array() ,"value" => 797394),array("tree" => array() ,"value" => 468372),array("tree" => array() ,"value" => 605660),array("tree" => array() ,"value" => 493122)) ,"value" => 926256),array("tree" => array(array("tree" => array() ,"value" => 413276),array("tree" => array() ,"value" => 860428),array("tree" => array() ,"value" => 271679),array("tree" => array() ,"value" => 961585)) ,"value" => 731805),array("tree" => array(array("tree" => array() ,"value" => 586234),array("tree" => array() ,"value" => 620578),array("tree" => array() ,"value" => 515608),array("tree" => array() ,"value" => 326674)) ,"value" => 668216)) ,"value" => 751206)) ,"value" => 110256),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 35814),array("tree" => array() ,"value" => 469565),array("tree" => array() ,"value" => 879581),array("tree" => array() ,"value" => 901564)) ,"value" => 732001),array("tree" => array(array("tree" => array() ,"value" => 642084),array("tree" => array() ,"value" => 65419),array("tree" => array() ,"value" => 733669),array("tree" => array() ,"value" => 698204)) ,"value" => 117020),array("tree" => array(array("tree" => array() ,"value" => 387978),array("tree" => array() ,"value" => 412204),array("tree" => array() ,"value" => 660364),array("tree" => array() ,"value" => 278592)) ,"value" => 183860),array("tree" => array(array("tree" => array() ,"value" => 199840),array("tree" => array() ,"value" => 831309),array("tree" => array() ,"value" => 59233),array("tree" => array() ,"value" => 575874)) ,"value" => 366745)) ,"value" => 557511),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 826873),array("tree" => array() ,"value" => 946338),array("tree" => array() ,"value" => 701122),array("tree" => array() ,"value" => 12241)) ,"value" => 658948),array("tree" => array(array("tree" => array() ,"value" => 596808),array("tree" => array() ,"value" => 365281),array("tree" => array() ,"value" => 600705),array("tree" => array() ,"value" => 648823)) ,"value" => 780233),array("tree" => array(array("tree" => array() ,"value" => 140778),array("tree" => array() ,"value" => 516992),array("tree" => array() ,"value" => 318826),array("tree" => array() ,"value" => 638174)) ,"value" => 918495),array("tree" => array(array("tree" => array() ,"value" => 869755),array("tree" => array() ,"value" => 236701),array("tree" => array() ,"value" => 601614),array("tree" => array() ,"value" => 751841)) ,"value" => 804040)) ,"value" => 429404),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 438394),array("tree" => array() ,"value" => 444757),array("tree" => array() ,"value" => 868244),array("tree" => array() ,"value" => 848566)) ,"value" => 873847),array("tree" => array(array("tree" => array() ,"value" => 557347),array("tree" => array() ,"value" => 816499),array("tree" => array() ,"value" => 354416),array("tree" => array() ,"value" => 924657)) ,"value" => 362431),array("tree" => array(array("tree" => array() ,"value" => 408098),array("tree" => array() ,"value" => 34797),array("tree" => array() ,"value" => 425367),array("tree" => array() ,"value" => 465749)) ,"value" => 849574),array("tree" => array(array("tree" => array() ,"value" => 747671),array("tree" => array() ,"value" => 618176),array("tree" => array() ,"value" => 730484),array("tree" => array() ,"value" => 526761)) ,"value" => 743631)) ,"value" => 781475),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 399383),array("tree" => array() ,"value" => 41416),array("tree" => array() ,"value" => 555170),array("tree" => array() ,"value" => 872550)) ,"value" => 8247),array("tree" => array(array("tree" => array() ,"value" => 163831),array("tree" => array() ,"value" => 794051),array("tree" => array() ,"value" => 194299),array("tree" => array() ,"value" => 321037)) ,"value" => 321578),array("tree" => array(array("tree" => array() ,"value" => 298732),array("tree" => array() ,"value" => 786466),array("tree" => array() ,"value" => 842100),array("tree" => array() ,"value" => 933969)) ,"value" => 18432),array("tree" => array(array("tree" => array() ,"value" => 938114),array("tree" => array() ,"value" => 108624),array("tree" => array() ,"value" => 636768),array("tree" => array() ,"value" => 602187)) ,"value" => 418842)) ,"value" => 429828)) ,"value" => 449189)) ,"value" => 39598),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 379251),array("tree" => array() ,"value" => 788368),array("tree" => array() ,"value" => 886113),array("tree" => array() ,"value" => 938250)) ,"value" => 484882),array("tree" => array(array("tree" => array() ,"value" => 853280),array("tree" => array() ,"value" => 796432),array("tree" => array() ,"value" => 769769),array("tree" => array() ,"value" => 176505)) ,"value" => 233465),array("tree" => array(array("tree" => array() ,"value" => 724411),array("tree" => array() ,"value" => 780200),array("tree" => array() ,"value" => 993864),array("tree" => array() ,"value" => 333925)) ,"value" => 357753),array("tree" => array(array("tree" => array() ,"value" => 323242),array("tree" => array() ,"value" => 116269),array("tree" => array() ,"value" => 110576),array("tree" => array() ,"value" => 916542)) ,"value" => 971352)) ,"value" => 334410),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 168613),array("tree" => array() ,"value" => 672460),array("tree" => array() ,"value" => 163672),array("tree" => array() ,"value" => 350725)) ,"value" => 673775),array("tree" => array(array("tree" => array() ,"value" => 132451),array("tree" => array() ,"value" => 523695),array("tree" => array() ,"value" => 755769),array("tree" => array() ,"value" => 995123)) ,"value" => 748458),array("tree" => array(array("tree" => array() ,"value" => 687134),array("tree" => array() ,"value" => 477694),array("tree" => array() ,"value" => 471280),array("tree" => array() ,"value" => 869863)) ,"value" => 789416),array("tree" => array(array("tree" => array() ,"value" => 719380),array("tree" => array() ,"value" => 192797),array("tree" => array() ,"value" => 397222),array("tree" => array() ,"value" => 218485)) ,"value" => 111957)) ,"value" => 562241),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 610157),array("tree" => array() ,"value" => 727095),array("tree" => array() ,"value" => 409889),array("tree" => array() ,"value" => 969978)) ,"value" => 783107),array("tree" => array(array("tree" => array() ,"value" => 41291),array("tree" => array() ,"value" => 23334),array("tree" => array() ,"value" => 858395),array("tree" => array() ,"value" => 914563)) ,"value" => 526946),array("tree" => array(array("tree" => array() ,"value" => 123078),array("tree" => array() ,"value" => 899274),array("tree" => array() ,"value" => 681596),array("tree" => array() ,"value" => 527090)) ,"value" => 728181),array("tree" => array(array("tree" => array() ,"value" => 644),array("tree" => array() ,"value" => 264406),array("tree" => array() ,"value" => 335585),array("tree" => array() ,"value" => 825503)) ,"value" => 843786)) ,"value" => 559354),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 212387),array("tree" => array() ,"value" => 788918),array("tree" => array() ,"value" => 348798),array("tree" => array() ,"value" => 73256)) ,"value" => 961413),array("tree" => array(array("tree" => array() ,"value" => 722756),array("tree" => array() ,"value" => 183170),array("tree" => array() ,"value" => 449202),array("tree" => array() ,"value" => 38699)) ,"value" => 295855),array("tree" => array(array("tree" => array() ,"value" => 193907),array("tree" => array() ,"value" => 388333),array("tree" => array() ,"value" => 981108),array("tree" => array() ,"value" => 311658)) ,"value" => 193200),array("tree" => array(array("tree" => array() ,"value" => 25450),array("tree" => array() ,"value" => 653238),array("tree" => array() ,"value" => 71931),array("tree" => array() ,"value" => 923954)) ,"value" => 580473)) ,"value" => 419135)) ,"value" => 89293),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 362717),array("tree" => array() ,"value" => 414298),array("tree" => array() ,"value" => 253769),array("tree" => array() ,"value" => 24219)) ,"value" => 526356),array("tree" => array(array("tree" => array() ,"value" => 292961),array("tree" => array() ,"value" => 382782),array("tree" => array() ,"value" => 799307),array("tree" => array() ,"value" => 15453)) ,"value" => 289538),array("tree" => array(array("tree" => array() ,"value" => 761170),array("tree" => array() ,"value" => 296542),array("tree" => array() ,"value" => 496563),array("tree" => array() ,"value" => 315762)) ,"value" => 827217),array("tree" => array(array("tree" => array() ,"value" => 689774),array("tree" => array() ,"value" => 24623),array("tree" => array() ,"value" => 732625),array("tree" => array() ,"value" => 984154)) ,"value" => 703573)) ,"value" => 483146),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 23164),array("tree" => array() ,"value" => 511717),array("tree" => array() ,"value" => 760244),array("tree" => array() ,"value" => 331367)) ,"value" => 587334),array("tree" => array(array("tree" => array() ,"value" => 987746),array("tree" => array() ,"value" => 349728),array("tree" => array() ,"value" => 987693),array("tree" => array() ,"value" => 228835)) ,"value" => 894647),array("tree" => array(array("tree" => array() ,"value" => 594329),array("tree" => array() ,"value" => 224108),array("tree" => array() ,"value" => 342443),array("tree" => array() ,"value" => 885680)) ,"value" => 896209),array("tree" => array(array("tree" => array() ,"value" => 762792),array("tree" => array() ,"value" => 258651),array("tree" => array() ,"value" => 147775),array("tree" => array() ,"value" => 434177)) ,"value" => 379471)) ,"value" => 549254),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 16196),array("tree" => array() ,"value" => 436462),array("tree" => array() ,"value" => 771474),array("tree" => array() ,"value" => 724797)) ,"value" => 254682),array("tree" => array(array("tree" => array() ,"value" => 393528),array("tree" => array() ,"value" => 174012),array("tree" => array() ,"value" => 936388),array("tree" => array() ,"value" => 3078)) ,"value" => 675747),array("tree" => array(array("tree" => array() ,"value" => 242894),array("tree" => array() ,"value" => 529945),array("tree" => array() ,"value" => 964982),array("tree" => array() ,"value" => 935486)) ,"value" => 16849),array("tree" => array(array("tree" => array() ,"value" => 945013),array("tree" => array() ,"value" => 363376),array("tree" => array() ,"value" => 335443),array("tree" => array() ,"value" => 760873)) ,"value" => 86713)) ,"value" => 491036),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 881253),array("tree" => array() ,"value" => 12846),array("tree" => array() ,"value" => 687791),array("tree" => array() ,"value" => 481238)) ,"value" => 16950),array("tree" => array(array("tree" => array() ,"value" => 212682),array("tree" => array() ,"value" => 137844),array("tree" => array() ,"value" => 33016),array("tree" => array() ,"value" => 652052)) ,"value" => 65785),array("tree" => array(array("tree" => array() ,"value" => 100894),array("tree" => array() ,"value" => 601999),array("tree" => array() ,"value" => 673580),array("tree" => array() ,"value" => 759727)) ,"value" => 102963),array("tree" => array(array("tree" => array() ,"value" => 75023),array("tree" => array() ,"value" => 804591),array("tree" => array() ,"value" => 945852),array("tree" => array() ,"value" => 467049)) ,"value" => 556653)) ,"value" => 321992)) ,"value" => 879117),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 303752),array("tree" => array() ,"value" => 753769),array("tree" => array() ,"value" => 166785),array("tree" => array() ,"value" => 548564)) ,"value" => 46344),array("tree" => array(array("tree" => array() ,"value" => 68658),array("tree" => array() ,"value" => 967766),array("tree" => array() ,"value" => 808308),array("tree" => array() ,"value" => 572533)) ,"value" => 794551),array("tree" => array(array("tree" => array() ,"value" => 114680),array("tree" => array() ,"value" => 169483),array("tree" => array() ,"value" => 107505),array("tree" => array() ,"value" => 269015)) ,"value" => 793345),array("tree" => array(array("tree" => array() ,"value" => 869493),array("tree" => array() ,"value" => 54494),array("tree" => array() ,"value" => 253771),array("tree" => array() ,"value" => 705037)) ,"value" => 525484)) ,"value" => 129664),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 871420),array("tree" => array() ,"value" => 472439),array("tree" => array() ,"value" => 643067),array("tree" => array() ,"value" => 717291)) ,"value" => 63881),array("tree" => array(array("tree" => array() ,"value" => 918877),array("tree" => array() ,"value" => 306484),array("tree" => array() ,"value" => 552476),array("tree" => array() ,"value" => 181910)) ,"value" => 630391),array("tree" => array(array("tree" => array() ,"value" => 633934),array("tree" => array() ,"value" => 548254),array("tree" => array() ,"value" => 845089),array("tree" => array() ,"value" => 128668)) ,"value" => 411212),array("tree" => array(array("tree" => array() ,"value" => 126649),array("tree" => array() ,"value" => 387199),array("tree" => array() ,"value" => 347956),array("tree" => array() ,"value" => 66350)) ,"value" => 820696)) ,"value" => 549300),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 73708),array("tree" => array() ,"value" => 121593),array("tree" => array() ,"value" => 626323),array("tree" => array() ,"value" => 277050)) ,"value" => 693664),array("tree" => array(array("tree" => array() ,"value" => 813376),array("tree" => array() ,"value" => 220049),array("tree" => array() ,"value" => 214924),array("tree" => array() ,"value" => 12075)) ,"value" => 810974),array("tree" => array(array("tree" => array() ,"value" => 51147),array("tree" => array() ,"value" => 101285),array("tree" => array() ,"value" => 570413),array("tree" => array() ,"value" => 623907)) ,"value" => 465004),array("tree" => array(array("tree" => array() ,"value" => 982048),array("tree" => array() ,"value" => 534070),array("tree" => array() ,"value" => 371659),array("tree" => array() ,"value" => 516903)) ,"value" => 5854)) ,"value" => 267513),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 891715),array("tree" => array() ,"value" => 53942),array("tree" => array() ,"value" => 127957),array("tree" => array() ,"value" => 152846)) ,"value" => 335223),array("tree" => array(array("tree" => array() ,"value" => 746196),array("tree" => array() ,"value" => 822924),array("tree" => array() ,"value" => 490748),array("tree" => array() ,"value" => 464305)) ,"value" => 368322),array("tree" => array(array("tree" => array() ,"value" => 518700),array("tree" => array() ,"value" => 566024),array("tree" => array() ,"value" => 286768),array("tree" => array() ,"value" => 671985)) ,"value" => 63264),array("tree" => array(array("tree" => array() ,"value" => 23489),array("tree" => array() ,"value" => 867569),array("tree" => array() ,"value" => 398353),array("tree" => array() ,"value" => 195555)) ,"value" => 936945)) ,"value" => 4986)) ,"value" => 506579),array("tree" => array(array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 646758),array("tree" => array() ,"value" => 605965),array("tree" => array() ,"value" => 732419),array("tree" => array() ,"value" => 447695)) ,"value" => 818221),array("tree" => array(array("tree" => array() ,"value" => 136453),array("tree" => array() ,"value" => 149313),array("tree" => array() ,"value" => 202471),array("tree" => array() ,"value" => 473604)) ,"value" => 513230),array("tree" => array(array("tree" => array() ,"value" => 935945),array("tree" => array() ,"value" => 760199),array("tree" => array() ,"value" => 473127),array("tree" => array() ,"value" => 904618)) ,"value" => 186365),array("tree" => array(array("tree" => array() ,"value" => 798907),array("tree" => array() ,"value" => 746109),array("tree" => array() ,"value" => 7784),array("tree" => array() ,"value" => 830376)) ,"value" => 71367)) ,"value" => 656257),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 321803),array("tree" => array() ,"value" => 324454),array("tree" => array() ,"value" => 219026),array("tree" => array() ,"value" => 526603)) ,"value" => 299835),array("tree" => array(array("tree" => array() ,"value" => 227363),array("tree" => array() ,"value" => 783885),array("tree" => array() ,"value" => 501746),array("tree" => array() ,"value" => 238898)) ,"value" => 473848),array("tree" => array(array("tree" => array() ,"value" => 8755),array("tree" => array() ,"value" => 129693),array("tree" => array() ,"value" => 913511),array("tree" => array() ,"value" => 657478)) ,"value" => 728637),array("tree" => array(array("tree" => array() ,"value" => 174948),array("tree" => array() ,"value" => 378063),array("tree" => array() ,"value" => 652186),array("tree" => array() ,"value" => 424169)) ,"value" => 27579)) ,"value" => 525761),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 133857),array("tree" => array() ,"value" => 628738),array("tree" => array() ,"value" => 243643),array("tree" => array() ,"value" => 751086)) ,"value" => 147941),array("tree" => array(array("tree" => array() ,"value" => 855071),array("tree" => array() ,"value" => 312419),array("tree" => array() ,"value" => 202022),array("tree" => array() ,"value" => 313485)) ,"value" => 609972),array("tree" => array(array("tree" => array() ,"value" => 502819),array("tree" => array() ,"value" => 563670),array("tree" => array() ,"value" => 865778),array("tree" => array() ,"value" => 914492)) ,"value" => 244285),array("tree" => array(array("tree" => array() ,"value" => 907175),array("tree" => array() ,"value" => 966614),array("tree" => array() ,"value" => 758735),array("tree" => array() ,"value" => 92153)) ,"value" => 282391)) ,"value" => 458045),array("tree" => array(array("tree" => array(array("tree" => array() ,"value" => 507953),array("tree" => array() ,"value" => 78413),array("tree" => array() ,"value" => 924106),array("tree" => array() ,"value" => 312767)) ,"value" => 7318),array("tree" => array(array("tree" => array() ,"value" => 556021),array("tree" => array() ,"value" => 311400),array("tree" => array() ,"value" => 821531),array("tree" => array() ,"value" => 594664)) ,"value" => 462389),array("tree" => array(array("tree" => array() ,"value" => 856255),array("tree" => array() ,"value" => 791613),array("tree" => array() ,"value" => 146135),array("tree" => array() ,"value" => 147819)) ,"value" => 525228),array("tree" => array(array("tree" => array() ,"value" => 127338),array("tree" => array() ,"value" => 287559),array("tree" => array() ,"value" => 524439),array("tree" => array() ,"value" => 747953)) ,"value" => 100602)) ,"value" => 226977)) ,"value" => 250818)) ,"value" => 429647)) ,"value" => 464263)) ,"value" => 461562);
print(DFS(726494, $data));
$executionTime=microtime(true) - $executionTime;
$stderr=fopen('php://stderr','w');
fwrite($stderr, $executionTime);
fclose($stderr);

?>