print("Content-type: text/html\n")
"""
  File: recursQuickSort.py
  Desc: Sort list contains numbers
  Author: Jan Drazil
"""

def recursQuickSort(data):
  return recursQuickSortAlg(data, 0, len(data)-1)
  
def recursQuickSortAlg(data, left, right):
  if(left<right):
    q=qsPartition(data, left, right)
    data=recursQuickSortAlg(q['data'], left, q['cut']-1)
    data=recursQuickSortAlg(data, q['cut']+1, right)
  return data
  
def qsPartition(data, left, right):
  pivot = data[right]
  i=left-1
  for j in range(left,right):
    if(data[j] <= pivot):
      i+=1
      tmp=data[i]
      data[i]=data[j]
      data[j]=tmp
  tmp=data[i+1]
  data[i+1]=data[right]
  data[right]=tmp
  return {'data':data, 'cut':i+1}


###Generated###
"""  
  File: printItems.php
  Desc: Print items in list
  Author: Jan Drazil
"""

def printItems(data):
  for i in data:
    print(i,end="\n");


data = [265, 624, 923, 529, 407, 251, 321, 241, 570, 10, 143, 32, 660, 587, 527, 298, 433, 20, 728, 673, 637, 707, 704, 933, 961, 881, 960, 0, 215, 956, 871, 576, 605, 217, 63, 569, 600, 650, 382, 17, 826, 471, 299, 709, 690, 179, 381, 774, 719, 440, 901, 903, 503, 378, 855, 773, 52, 986, 484, 940, 881, 597, 469, 525, 614, 930, 246, 121, 737, 70, 22, 235, 714, 600, 733, 219, 675, 231, 142, 25, 60, 484, 804, 729, 85, 337, 33, 286, 187, 801, 1, 194, 429, 587, 288, 39, 201, 125, 51, 390, 465, 743, 375, 195, 730, 370, 162, 117, 51, 917, 438, 157, 167, 369, 455, 655, 300, 823, 988, 415, 165, 399, 549, 719, 993, 148, 544, 205, 600, 33, 926, 119, 3, 535, 918, 950, 289, 696, 646, 120, 475, 915, 532, 798, 453, 358, 885, 531, 765, 942, 394, 111, 11, 57, 466, 379, 799, 759, 860, 636, 875, 192, 116, 206, 790, 765, 221, 951, 203, 299, 837, 795, 795, 620, 120, 673, 449, 339, 521, 90, 12, 443, 418, 360, 804, 694, 241, 159, 601, 167, 862, 629, 359, 271, 14, 608, 952, 967, 871, 185, 298, 566, 544, 512, 375, 129, 634, 456, 281, 600, 246, 827, 556, 737, 660, 554, 220, 260, 564, 859, 584, 459, 10, 298, 353, 141, 27, 89, 683, 771, 110, 461, 658, 883, 925, 185, 414, 594, 25, 256, 331, 993, 635, 309, 372, 334, 67, 645, 774, 907, 10, 322, 128, 845, 343, 915, 886, 875, 81, 869, 102, 546, 582, 881, 611, 442, 661, 563, 188, 120, 174, 214, 811, 910, 355, 746, 245, 544, 746, 452, 246, 513, 513, 799, 899, 312, 296, 579, 831, 895, 929, 141, 869, 80, 615, 627, 399, 249, 509, 478, 162, 367, 752, 557, 744, 174, 314, 395, 202, 777, 505, 134, 264, 353, 153, 259, 395, 356, 680, 791, 539, 471, 491, 131, 289, 296, 227, 997, 939, 384, 654, 393, 418, 948, 950, 723, 97, 240, 494, 118, 927, 224, 408, 724, 351, 908, 831, 449, 590, 816, 744, 103, 214, 430, 260, 295, 796, 155, 75, 335, 454, 995, 728, 843, 701, 829, 315, 494, 263, 190, 905, 717, 282, 928, 197, 953, 62, 66, 500, 84, 226, 390, 998, 437, 577, 740, 450, 549, 690, 413, 207, 116, 378, 513, 15, 138, 782, 393, 13, 677, 81, 984, 980, 526, 107, 653, 706, 83, 902, 717, 617, 601, 951, 53, 33, 789, 935, 448, 1, 816, 368, 740, 812, 253, 430, 308, 561, 423, 269, 480, 762, 301, 564, 878, 104, 698, 657, 627, 105, 801, 560, 661, 306, 470, 740, 993, 211, 322, 309, 691, 424, 890, 4, 66, 838, 259, 638, 167, 856, 171, 501, 724, 201, 372, 355, 651, 444, 578, 172, 371, 505, 654, 931, 212, 640, 528, 583, 805, 395, 277, 3, 482, 873, 959, 132, 694, 434, 524, 74, 581, 267, 807, 671, 339, 600, 302, 923, 359, 165, 286, 879, 499, 484, 162, 773, 513, 520, 9, 497, 201, 347, 673, 704, 311, 440, 797, 98, 676, 220, 681, 948, 197, 675, 133, 131, 770, 272, 840, 875, 844, 729, 460, 295, 658, 767, 397, 229, 678, 274, 995, 326, 951, 177, 316, 20, 640, 247, 409, 800, 471, 93, 110, 657, 891, 800, 114, 718, 33, 969, 224, 949, 976, 28, 738, 1, 149, 277, 168, 356, 270, 669, 636, 460, 195, 900, 647, 960, 110, 891, 356, 834, 469, 813, 661, 704, 747, 535, 454, 159, 71, 812, 558, 889, 42, 414, 541, 381, 12, 726, 74, 382, 480, 785, 921, 385, 635, 834, 344, 411, 533, 421, 136, 335, 59, 691, 679, 862, 48, 187, 593, 173, 319, 423, 279, 849, 88, 127, 758, 429, 55, 603, 976, 703, 867, 388, 566, 739, 533, 619, 728, 814, 180, 785, 342, 31, 525, 588, 837, 611, 769, 709, 590, 357, 354, 766, 857, 714, 230, 879, 982, 80, 703, 940, 172, 221, 468, 274, 310, 373, 874, 97, 139, 195, 438, 708, 739, 296, 324, 203, 673, 588, 450, 926, 877, 103, 284, 301, 356, 23, 691, 487, 328, 388, 383, 100, 702, 952, 651, 907, 156, 854, 536, 401, 128, 406, 379, 915, 64, 327, 353, 572, 606, 52, 974, 613, 662, 922, 524, 384, 932, 626, 566, 915, 13, 12, 687, 660, 779, 60, 568, 363, 812, 362, 731, 698, 290, 369, 105, 906, 937, 33, 734, 63, 724, 874, 770, 849, 131, 184, 897, 110, 703, 943, 224, 208, 77, 804, 301, 399, 683, 92, 994, 202, 636, 979, 796, 0, 221, 723, 261, 815, 301, 498, 369, 186, 223, 906, 900, 286, 836, 390, 757, 542, 612, 345, 222, 248, 196, 50, 124, 364, 588, 253, 132, 132, 117, 899, 388, 682, 986, 296, 34, 702, 661, 254, 794, 168, 913, 911, 262, 257, 386, 260, 603, 214, 48, 708, 107, 706, 31, 299, 4, 572, 511, 270, 789, 745, 831, 406, 48, 562, 483, 849, 743, 537, 487, 874, 645, 57, 41, 523, 773, 965, 305, 257, 745, 12, 30, 561, 861, 788, 566, 236, 151, 860, 943, 985, 728, 594, 690, 868, 744, 86, 336, 314, 971, 788, 386, 937, 459, 756, 356, 953, 714, 8, 199, 299, 946, 591, 986, 50, 452, 273, 188, 156, 753, 988, 322, 250, 405, 330, 811, 392, 403, 240, 378, 964, 529, 30, 98, 492, 265, 693, 633, 572, 840, 772, 414, 388, 914, 235, 422, 411, 888, 761, 71, 476, 584, 380, 618, 793, 701, 448, 500, 617, 243, 363, 894, 6, 207, 480, 353, 518, 470, 408, 607, 931, 946, 376, 608, 34, 783, 62, 150, 867, 982, 248, 405, 142, 196, 605, 327, 922, 13, 22, 842, 590, 835, 819, 625, 572, 721, 275, 817, 527, 80, 622, 3, 14, 790, 627, 468, 925, 133, 545, 206, 322, 650, 293, 911, 109, 629, 154, 902, 31, 785, 43, 595, 209, 573, 522, 549, 349, 146, 967, 956, 545, 578, 134, 568, 406, 378, 42, 366, 525, 310, 325, 393, 551, 613, 540, 223, 697, 438, 474, 568, 281, 328, 895, 541, 457, 483, 195, 376, 633, 124, 421, 769, 760, 370, 478, 299, 308, 69, 61, 807, 110, 346, 437, 871, 301, 844, 194, 441, 617, 507, 928, 333, 533, 694, 324, 408, 319, 984, 977, 53, 123, 635, 343, 740, 955, 59, 870, 404, 447, 443, 717, 812, 193, 292, 818, 214, 523, 769, 951, 441, 520, 443, 334, 865, 103, 965, 726, 517, 794, 879, 660, 401, 369, 442, 562, 522, 837, 95, 445, 822, 824, 482, 557, 163, 105, 1000, 959, 144, 944, 534, 753, 602, 533, 650, 436, 429, 670, 118, 508, 998, 408, 27, 530, 365, 300, 708, 440, 734, 476, 777, 756, 270, 771, 598, 442, 732, 421, 394, 128, 403, 388, 979, 701, 275, 424, 272, 912, 302, 434, 70, 954, 495, 699, 544, 450, 510, 448, 198, 476, 122, 341, 640, 552, 777, 540, 625, 146, 302, 637, 706, 638, 804, 47, 160, 227, 896, 967, 861, 580, 158, 184, 984, 666, 667, 675, 144, 934, 68, 146, 318, 822, 960, 24, 793, 235, 53, 328, 517, 951, 78, 681, 857, 65, 375, 907, 601, 94, 645, 694, 819, 259, 290, 120, 704, 112, 996, 516, 411, 388, 666, 759, 760, 892, 666, 276, 113, 984, 479, 344, 414, 166, 773, 665, 798, 378, 859, 898, 882, 178, 367, 688, 339, 907, 680, 546, 346, 457, 317, 1, 728, 281, 316, 967, 152, 154, 132, 949, 705, 954, 599, 509, 580, 308, 86, 657, 25, 88, 61, 877, 871, 815, 701, 309, 5, 343, 286, 118, 869, 787, 386, 279, 269, 329, 384, 526, 996, 347, 252, 688, 349, 782, 219, 953, 253, 74, 764, 816, 422, 912, 290, 713, 455, 874, 201, 480, 813, 867, 652, 999, 932, 7, 308, 299, 393, 711, 840, 49, 904, 4, 840, 209, 184, 447, 557, 987, 655, 739, 945, 980, 384, 812, 663, 223, 113, 499, 754, 651, 916, 156, 683, 638, 602, 139, 484, 10, 55, 86, 710, 206, 939, 739, 587, 750, 904, 359, 319, 529, 902, 969, 376, 811, 904, 25, 720, 154, 730, 817, 15, 976, 496, 894, 633, 244, 109, 782, 668, 298, 858, 776, 950, 443, 107, 884, 795, 814, 234, 711, 35, 999, 826, 593, 324, 67, 25, 982, 436, 533, 981, 401, 682, 786, 262, 773, 806, 431, 630, 561, 518, 512, 165, 901, 506, 9, 477, 958, 741, 573, 918, 867, 27, 415, 251, 133, 501, 442, 28, 136, 209, 297, 350, 764, 258, 344, 376, 132, 629, 968, 824, 582, 993, 71, 432, 347, 304, 965, 244, 114, 284, 831, 990, 975, 819, 183, 80, 581, 824, 426, 499, 340, 674, 739, 394, 539, 448, 945, 302, 860, 975, 316, 682, 533, 575, 649, 33, 169, 233, 704, 129, 257, 17, 446, 3, 995, 400, 504, 180, 578, 22, 244, 326, 129, 627, 823, 109, 446, 959, 234, 660, 771, 338, 409, 187, 1000, 787, 287, 58, 452, 111, 421, 723, 0, 956, 460, 289, 568, 474, 393, 649, 88, 408, 48, 319, 81, 595, 778, 467, 460, 83, 843, 68, 444, 194, 207, 679, 222, 752, 195, 320, 574, 478, 946, 702, 352, 990, 73, 273, 260, 60, 854, 513, 708, 553, 384, 192, 116, 780, 145, 703, 25, 573, 89, 1, 858, 522, 357, 208, 339, 399, 507, 501, 669, 418, 878, 808, 300, 537, 950, 564, 890, 877, 183, 238, 555, 226, 835, 941, 501, 713, 283, 31, 868, 657, 358, 840, 829, 679, 36, 979, 33, 132, 261, 31, 175, 973, 338, 312, 224, 963, 164, 120, 903, 253, 966, 635, 100, 932, 540, 312, 785, 415, 364, 88, 408, 131, 928, 300, 266, 408, 903, 47, 788, 540, 925, 641, 275, 311, 113, 904, 78, 46, 229, 530, 436, 237, 732, 232, 418, 836, 949, 377, 530, 987, 986, 971, 664, 417, 538, 224, 458, 741, 260, 719, 446, 439, 687, 719, 580, 793, 997, 881, 976, 832, 622, 689, 454, 777, 664, 517, 37, 540, 840, 428, 765, 275, 440, 469, 90, 530, 521, 390, 345, 236, 4, 877, 888, 29, 446, 974, 436, 532, 723, 520, 78, 644, 242, 463, 658, 409, 174, 742, 776, 821, 211, 124, 478, 444, 564, 668, 589, 221, 204, 342, 727, 69, 366, 400, 691, 598, 936, 460, 956, 886, 803, 661, 589, 346, 165, 343, 318, 977, 223, 234, 587, 152, 700, 730, 332, 726, 669, 102, 336, 245, 228, 486, 323, 182, 351, 432, 97, 9, 546, 391, 401, 942, 31, 58, 661, 862, 256, 649, 259, 867, 256, 396, 701, 291, 30, 899, 935, 61, 655, 156, 376, 508, 753, 205, 108, 209, 793, 798, 460, 542, 281, 142, 617, 150, 261, 838, 189, 826, 937, 377, 859, 954, 6, 418, 376, 425, 127, 298, 829, 141, 13, 795, 890, 685, 284, 59, 433, 916, 180, 625, 307, 939, 827, 464, 621, 823, 248, 513, 103, 922, 523, 190, 226, 966, 412, 161, 856, 772, 740, 422, 878, 214, 411, 358, 77, 312, 568, 350, 605, 229, 187, 812, 124, 360, 103, 268, 592, 8, 877, 446, 117, 173, 869, 535, 784, 890, 504, 186, 387, 818, 116, 710, 770, 574, 212, 783, 772, 647, 836, 750, 19, 529, 930, 71, 871, 648, 217, 221, 83, 32, 338, 320, 913, 244, 172, 838, 575, 939, 681, 882, 655, 4, 502, 214, 492, 994, 691, 976, 612, 401, 880, 356, 33, 312, 149, 599, 251, 56, 366, 91, 377, 192, 667, 485, 33, 988, 66, 999, 67, 518, 933, 151, 907, 222, 14, 317, 714, 984, 74, 713, 160, 519, 104, 687, 721, 507, 280, 434, 537, 573, 581, 937, 931, 395, 532, 846, 250, 32, 929, 255, 973, 412, 117, 937, 353, 160, 556, 727, 434, 872, 650, 198, 163, 978, 471, 839, 471, 864, 522, 822, 959, 524, 291, 801, 296, 700, 14, 752, 956, 447, 931, 898, 647, 9, 548, 361, 227, 976, 17, 833, 896, 716, 324, 412, 155, 780, 673, 965, 610, 243, 559, 532, 946, 903, 878, 61, 181, 59, 210, 886, 475, 990, 966, 730, 440, 919, 499, 441, 967, 239, 67, 190, 15, 915, 231, 493, 715, 635, 71, 81, 552, 827, 313, 784, 1, 969, 942, 126, 206, 593, 586, 898, 819, 201, 402, 273, 631, 953, 542, 60, 793, 24, 478, 26, 952, 567, 676, 692, 319, 264, 615, 24, 352, 750, 894, 518, 279, 313, 178, 974, 457, 212, 954, 852, 927, 823, 894, 278, 571, 493, 183, 6, 720, 672, 435, 484, 532, 376, 596, 734, 197, 423, 870, 694, 982, 571, 766, 421, 931, 553, 274, 57, 408, 391, 40, 788, 686, 573, 288, 889, 793, 907, 663, 483, 143, 724, 206, 789, 116, 348, 612, 278, 836, 227, 617, 723, 560, 427, 564, 603, 110, 598, 762, 644, 378, 8, 863, 991, 315, 597, 819, 189, 474, 979, 589, 870, 747, 186, 503, 908, 361, 815, 548, 532, 130, 744, 10, 434, 790, 692, 208, 578, 751, 999, 307, 603, 277, 39, 771, 194, 281, 692, 947, 812, 76, 723, 261, 796, 543, 517, 867, 280, 108, 271, 683, 326, 408, 53, 759, 820, 386, 498, 369, 761, 875, 856, 56, 746, 38, 889, 164, 336, 421, 740, 900, 380, 740, 147, 514, 934, 404, 377, 533, 997, 29, 125, 897, 837, 13, 996, 250, 177, 133, 583, 915, 244, 308, 435, 76, 945, 836, 465, 815, 887, 847, 433, 940, 349, 673, 355, 581, 872, 701, 143, 902, 652, 280, 503, 625, 908, 558, 808, 868, 70, 578, 69, 389, 419, 955, 677, 132, 764, 616, 539, 792, 271, 482, 26, 546, 634, 156, 222, 453, 947, 401, 623, 367, 904, 564, 940, 736, 221, 177, 558, 601, 388, 220, 984, 585, 546, 952, 102, 198, 906, 634, 874, 767, 591, 173, 800, 996, 471, 736, 837, 616, 171, 110, 350, 277, 244, 666, 894, 553, 63, 383, 954, 92, 436, 822, 512, 658, 767, 666, 348, 427, 763, 898, 356, 610, 240, 885, 99, 322, 996, 855, 103, 653, 857, 609, 306, 32, 174, 631, 821, 550, 5, 610, 355, 100, 271, 396, 239, 152, 357, 235, 264, 770, 496, 883, 991, 78, 351, 219, 329, 567, 430, 916, 430, 231, 814, 304, 769, 83, 238, 896, 198, 834, 416, 737, 967, 751, 134, 384, 513, 424, 783, 290, 675, 998, 844, 945, 450, 194, 415, 861, 801, 920, 34, 181, 741, 954, 322, 164, 902, 999, 475, 433, 855, 774, 71, 435, 261, 660, 673, 342, 860, 321, 426, 750, 210, 571, 607, 718, 855, 451, 793, 711, 77, 182, 792, 739, 459, 598, 393, 963, 419, 247, 968, 862, 130, 83, 146, 455, 453, 868, 774, 896, 333, 924, 97, 368, 148, 519, 127, 562, 555, 910, 738, 912, 651, 918, 641, 259, 938, 789, 610, 206, 569, 803, 411, 940, 866, 71, 273, 425, 204, 137, 213, 234, 990, 671, 196, 856, 511, 510, 284, 490, 632, 439, 916, 921, 414, 453, 921, 814, 474, 290, 96, 47, 603, 581, 16, 747, 792, 71, 512, 22, 803, 161, 284, 391, 884, 592, 173, 228, 937, 795, 224, 767, 230, 855, 380, 9, 463, 429, 268, 82, 999, 601, 565, 412, 22, 539, 90, 238, 868, 878, 831, 87, 147, 121, 843, 532, 867, 705, 54, 740, 487, 403, 754, 155, 559, 898, 957, 795, 183, 637, 960, 71, 410, 826, 467, 139, 31, 808, 574, 651, 169, 118, 977, 927, 833, 266, 735, 878, 872, 305, 912, 706, 635, 389, 363, 145, 422, 257, 841, 315, 297, 574, 806, 571, 70, 531, 297, 764, 15, 663, 669, 127, 111, 706, 803, 270, 151, 375, 169, 262, 185, 702, 11, 422, 81, 325, 878, 557, 891, 125, 761, 944, 572, 255, 740, 90, 406, 113, 600, 664, 98, 555, 191, 131, 859, 610, 960, 360, 881, 848, 299, 124, 293, 621, 432, 548, 784, 732, 198, 275, 205, 299, 975, 738, 346, 474, 443, 664, 446, 14, 518, 423, 189, 716, 205, 352, 812, 706, 690, 888, 958, 617, 64, 894, 475, 518, 90, 657, 479, 217, 82, 919, 98, 419, 132, 622, 518, 80, 473, 464, 869, 613, 120, 808, 734, 80, 295, 29, 617, 924, 299, 548, 800, 704, 705, 76, 621, 643, 159, 335, 606, 576, 277, 181, 55, 332, 691, 912, 333, 963, 892, 176, 43, 711, 626, 694, 859, 50, 856, 71, 287, 616, 891, 325, 919, 159, 154, 615, 684, 539, 472, 419, 257, 463, 160, 608, 409, 45, 781, 341, 249, 492, 66, 581, 604, 980, 965, 471, 262, 232, 304, 524, 725, 70, 192, 94, 238, 291, 133, 824, 229, 892, 734, 186, 496, 463, 716, 249, 149, 389, 137, 725, 812, 868, 214, 76, 886, 765, 210, 511, 888, 7, 405, 696, 175, 405, 682, 92, 799, 591, 458, 796, 793, 333, 353, 160, 610, 595, 809, 927, 339, 729, 714, 504, 456, 721, 644, 524, 982, 267, 10, 264, 440, 482, 459, 404, 20, 48, 430, 863, 0, 512, 205, 861, 945, 799, 824, 505, 5, 842, 246, 513, 580, 843, 909, 576, 222, 656, 858, 943, 278, 97, 511, 528, 995, 326, 51, 485, 488, 556, 295, 926, 433, 116, 758, 265, 246, 880, 937, 216, 871, 186, 324, 284, 308, 915, 924, 882, 471, 786, 477, 914, 980, 663, 643, 997, 857, 945, 649, 507, 548, 596, 759, 596, 548, 164, 62, 547, 44, 776, 485, 649, 53, 170, 476, 668, 370, 968, 477, 846, 40, 393, 701, 592, 230, 74, 263, 287, 508, 753, 955, 210, 36, 795, 348, 935, 545, 387, 149, 681, 37, 726, 824, 487, 107, 398, 929, 45, 184, 173, 164, 753, 12, 612, 979, 941, 416, 725, 398, 138, 921, 877, 718, 420, 869, 913, 877, 955, 734, 320, 832, 884, 211, 940, 385, 913, 462, 793, 919, 658, 178, 150, 195, 539, 588, 565, 995, 955, 113, 25, 905, 265, 642, 507, 109, 184, 64, 346, 566, 664, 697, 551, 900, 754, 871]
printItems(recursQuickSort(data))
