/*!
 * \file axi_tsu_util.c
 * \brief Tool to control timestamp unit
 * \author      Vladimir Smotlacha <vs@cesnet.cz>
 * \author      Vojtech Vitek (V-Teq) <vojtech.vitek@gmail.com>
 * \author      Jan Stourac <xstour03@stud.fit.vutbr.cz>
 * \author Tomas Fukac  <xfukac00@stud.fit.vutbr.cz>
 * \date 2012
 *
 * Copyright (C) 2012 Brno University of Technology
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 */


#include "tsu_util.h"

#define EXP2_32 4294967296.

void get_systime(l_fp *fp) {

	struct timeval tv;
	double tmp;

	gettimeofday (&tv,NULL);

	tmp = tv.tv_usec / 1000000.;
	fp->l_uf = (unsigned) (tmp * EXP2_32);
	fp->l_ui = tv.tv_sec;

}

void set_systime(l_fp *fp) {

	struct timeval tv;
	struct timeval now;
	double tmp;
	int32_t dsec, dusec;

	gettimeofday(&now, NULL);

	tmp = fp->l_uf / EXP2_32;
	tv.tv_usec = (unsigned) (tmp * 1000000);
	tv.tv_sec = fp->l_ui;

	dsec = tv.tv_sec - now.tv_sec;
	if (dsec > 1 || dsec < -1) {
	/* offset higher than 1s */
		settimeofday(&tv,NULL);
	} else {
	   dusec = 1000000*dsec + tv.tv_usec - now.tv_usec;
	   if (dusec > 128000 || dusec < -128000)
	/* offset out of range of adjtimex() */
		settimeofday(&tv,NULL);
	   else
	/* adjtimex() should be utilized */
	/*   however, it doesnt work !?
		adj_systime (dusec);
	 */	settimeofday(&tv,NULL);

	}
}

int write_drift(double drf, char *name) {

	int file;
	char str[80];

	sprintf(str, "%.3f", drf);

	unlink(name);
	file = creat(name, 0644);
	if (file < 0) {
		return (-1);
	}
	write (file, str, strlen(str));
	close (file);
	return (0);
}

int read_drift(double *drf, char *name) {

	int file;
	int n;
	char str[80];

	*drf = 0;
	file = open(name, O_RDONLY);
	if (file < 0) {
		return (-1);
	}
	n = read(file, str, sizeof(str)-1);
	if (n < 0) {
		close(file);
		return (-1);
	}
	close(file);
	str[n] = '\0';
	*drf = atof(str);
	return (0);
}
