/*!
 * \file tsu_ntp.h
 * \brief Header file for tsu_ntp.c file with NTP functions
 * \author Vladimir Smotlacha <vs@cesnet.cz>
 * \date 2007-2010
 */

/*
 * Copyright (C) 2007-2010 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id: tsu_ntp.h 7ce87c5 on Wed Nov 14 11:06:55 2012 +0100 by Mgr. Krej Radek $
 *
 */

#ifndef TSU_NTP_H
#define TSU_NTP_H

#include "tsu.h"
#include "hwio.h"
#include "hwio_tool.h"
#include "hwio_comp_spec.h"

/*
 *  Function returns time of NTP server
 */
int get_ntptime(struct hwio_comp *c, hwio_tool_comp_err_t err,
    const struct hwio_tool_params *params, char * arg_ntp_name, l_fp *fp);

#endif //TSU_NTP_H

