/*!
 * \file ethctl_cmd.h
 * \brief Tool for controlling axi-ethernet - header file: Axi-ethernet control 
 *         and communication commands
 * \author Vlastimil Kosar <ikosar@fit.vutbr.cz>
 * \date 2012
 *
 * Copyright (C) 2012 Brno University of Technology
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id: filterctl.c 1469 2012-05-23 15:59:18Z xkekel00 $
 *
 */

#ifndef ETHCTL_CMD_H_INCLUDED
#define ETHCTL_CMD_H_INCLUDED

/// Default path to device tree
#define DTREE_PATH "/proc/device-tree"
/// Default path to mem device
#define MEM_PATH "/dev/mem"
/// Default name of axi-ethernet
#define ETHERNET_NAME "axi-ethernet"

/// Used adresses of axi-ethernet
#define RAF        0x000
#define RXBL       0x200
#define RXBU       0x204
#define TXBL       0x208
#define TXBU       0x20C
#define RXFL       0x290
#define RXFU       0x294
#define RXFCSERL   0x298
#define RXFCSERU   0x29C
#define TXFL       0x2D8
#define TXFU       0x2DC
#define RCW1       0x404
#define TC         0x408
#define EMMC       0x410
#define RXFC       0x414
#define TXFC       0x418
#define ID         0x4F8
#define AR         0x4FC
#define FMI        0x708
#define MAC0       0x710
#define MAC1       0x714
#define STAT_START 0x200
#define STAT_END   0x3FC


/// Access masks
#define MAC_MASK         0x400
#define STAT_MASK        0x100
#define MASK_1000        0x4
#define MASK_100         0x2
#define MASK_10          0x1
#define SPEED_MASK       0xC0000000
#define JUMBO_MASK       0x40000000
#define FCS_MASK         0x20000000
#define ENABLE_MASK      0x10000000
#define VLAN_MASK        0x8000000
#define LTC_MASK         0x2000000
#define MTU_DEFAULT_MASK 0x10000
#define MTU_MASK         0x7FFF
#define PROM_MASK        0x80000000
#define INDEX_MASK       0x3
#define PATCH_MASK       0xFF
#define TYPE_MASK        0xFF00
#define MINOR_MASK       0xFF0000
#define MAJOR_MASK       0xFF000000
#define BAD_MASK         0x4000

#define ETH_NO_DEV -3
#define ETH_ERR -2
#define ETH_UNSUP -1
#define ETH_UP  0
#define ETH_DOWN 1

typedef struct{
    uint32_t major;
    uint32_t minor;
    uint32_t patch;
    uint32_t type;
} version_t;

/// This structure is used to store status and configuration of axi-ethernet
typedef struct{
    uint32_t  id;             /// id of axi ethernet
    version_t version;        /// version of the core
    uint32_t ability;         /// core capabilities
    uint32_t emmc;            /// EMMC register
    uint32_t raf;             /// RAF register
    uint32_t rx_cfg;          /// RX port configuration
    uint32_t rx_mtu;          /// RX port MTU
    uint32_t tx_cfg;          /// TX port configuration
    uint32_t tx_mtu;          /// TX port MTU
    uint32_t fmi;             /// Promiscuous mode/address filtering
    uint8_t  mac[4][6];       /// Filter MAC addresses
    uint64_t rx_bytes;        /// Number of accepted bytes
    uint64_t tx_bytes;        /// Number of transmited bytes
    uint64_t rx_frames_ok;    /// Number of correct received frames
    uint64_t tx_frames_ok;    /// Number of corectly transmited frames
    uint64_t rx_frames_bad;   /// Number of frames (>=64B) discarded because of 
                              /// FCS error
    int32_t  link_state;      /// Link state determinated via ethtool interface
    char *   driver_data;     /// Driver name and version determinated via 
                              /// ethtool interface
} stat_t;

/**
 * \brief Perform commands
 * \param params Command line parameters
 * \return EXIT_FAILURE if parameters are not sane,  EXIT_SUCCESS otherwise.
 */
int perform_commands(params_t *params);

#endif // ETHCTL_CMD_H_INCLUDED
