#include "xaxidma.h"
#include "xaxiethernet.h"
#include "loopback.h"


/*
 * Local MAC address
 */
char AxiEthernetMAC[6] = { 0x00, 0x0A, 0x35, 0x01, 0x02, 0x03 };
char MyMAC[6] = { 0x00, 0x0A, 0x35, 0x03, 0x02, 0x01 };
int bufLen = 200;


/**
 * Generates IP header
 */
void GenIPHeader(char* Header, short unsigned int dataLength){
	Header[0] = (4<<4) | 5;  //IPversion and Header length
	Header[1] = 0;           //Differentiated Services code point and Explicit Congestion Notification
	short unsigned int* Tmp = (short unsigned int*)(Header+2);
	*Tmp = Xil_Htons(dataLength + 28);  //Length of entire packet
	Header[4] = 0;
	Header[5] = 0;
	Header[6] = 0;
	Header[7] = 0;
	Header[8] = 255;  //TTL
	Header[9] = 17;   //Following packet belongs to UDP protocol
    Tmp = (short unsigned int*) (Header+10);
    Tmp[0] = Xil_Htons(0x0);  //Checksum, could be implemented in HW
    u32* Addr = (u32*) (Header+16);
    Addr[0] = Xil_Htons(1);
    Addr[1] = Xil_Htons(2);
}

/**
 * Generates UDP header
 */
void GenUDPHeader(char* Header, short unsigned length){
   short unsigned int* Tmp = (short unsigned int*) Header;
   Tmp[0] = Xil_Htons(6212);
   Tmp[1] = Xil_Htons(6313);
   Tmp[2] = Xil_Htons(length+80);
   Tmp[3] = 0x0000;
}


int GenRxRing(XAxiDma_BdRing* RxRingPtr, int RingLen , int SegLen, int CoalLen, char* Data ) {
   int Status;
   XAxiDma_Bd *Bd1Ptr;
   XAxiDma_Bd *currBd;
   int i;
   Status = XAxiDma_BdRingAlloc(RxRingPtr,RingLen,&Bd1Ptr);
   currBd = Bd1Ptr;
   //Moyno pouyit CloneRing
   for(i=0;i<RingLen;i++){
      XAxiDma_BdSetBufAddr(currBd, (u32)(Data+i*SegLen));
      XAxiDma_BdSetLength(currBd, SegLen);
      XAxiDma_BdSetCtrl(currBd, 0);
      currBd = XAxiDma_BdRingNext(RxRingPtr,currBd);
   }

	Status = XAxiDma_BdRingSetCoalesce(RxRingPtr, CoalLen, 255);
	if (Status != XST_SUCCESS) {
		AxiEthernetUtilErrorTrap("Error setting coalescing settings");
	    return XST_FAILURE;
	}
	Status = XAxiDma_BdRingToHw(RxRingPtr, RingLen, Bd1Ptr);
	if (Status != XST_SUCCESS) {
		AxiEthernetUtilErrorTrap("SSError committing RxBD to HW");
		return XST_FAILURE;
	}
	return XST_SUCCESS;
}

int GenTxRing(XAxiDma_BdRing* TxRingPtr, XAxiDma_BdRing* RxRingPtr, int packets, EthernetFrame* TxFrame, XAxiDma_Bd *BdCurPtr) {
	int Status;
	XAxiDma_Bd *Bd1Ptr;
	XAxiDma_Bd *Bd2Ptr;
	XAxiDma_Bd *SendStart;
	int i;
	Status = XAxiDma_BdRingAlloc(TxRingPtr, 2*packets, &Bd1Ptr);
	SendStart = Bd1Ptr;
	if (Status != XST_SUCCESS) {
	   AxiEthernetUtilErrorTrap("Error allocating TxBD\n");
	   if(Status == XST_FAILURE) xil_printf("Not enough TxBDs\n");
	   if(Status == XST_INVALID_PARAM) xil_printf("Packet number is not possitive - %d\n",packets);
	   return XST_FAILURE;
	}
	int sendPacket = 0;
	for(i=0;i<packets;i++){
	   int RxFrameLength = (XAxiDma_BdRead(BdCurPtr,XAXIDMA_BD_USR4_OFFSET)) & 0x0000FFFF;
	   if(RxFrameLength == 0) {
		   RxFrameLength = 80;
	   }
	   XAxiDma_BdSetBufAddr(Bd1Ptr, (u32)(TxFrame));
	   XAxiDma_BdSetLength(Bd1Ptr, XAE_HDR_SIZE+28);
	   XAxiDma_BdSetCtrl(Bd1Ptr, XAXIDMA_BD_CTRL_TXSOF_MASK);
	   Status = XAxiDma_BdSetAppWord(Bd1Ptr, BD_USR0_OFFSET, FULL_CSUM_ENABLE);
	   Bd2Ptr = XAxiDma_BdRingNext(TxRingPtr, Bd1Ptr);
	   sendPacket++;
	   XAxiDma_BdSetBufAddr(Bd2Ptr, XAxiDma_BdGetBufAddr(BdCurPtr));
	   XAxiDma_BdSetLength(Bd2Ptr, 80);
	   XAxiDma_BdSetCtrl(Bd2Ptr, XAXIDMA_BD_CTRL_TXEOF_MASK);
	   Bd1Ptr = XAxiDma_BdRingNext(TxRingPtr,Bd2Ptr);
	   BdCurPtr = XAxiDma_BdRingNext(RxRingPtr,BdCurPtr);
	   sendPacket++;

	}
	sendPacket = 2*packets;
	if(Status != XST_SUCCESS) {
		AxiEthernetUtilErrorTrap("Error in enabling full csum offloading");
		return XST_FAILURE;
	}
	//xil_printf("Sending %d packets\n",sendPacket);
	Status = XAxiDma_BdRingToHw(TxRingPtr, sendPacket, SendStart);
	if (Status != XST_SUCCESS) {
		XAxiDma_BdRingUnAlloc(TxRingPtr, sendPacket, SendStart);
		AxiEthernetUtilErrorTrap("Error committing TxBD to HW Failed");
		if(Status == XST_FAILURE) AxiEthernetUtilErrorTrap("Error committing TxBD to HW:XST_FAILURE");
		if(Status == XST_INVALID_PARAM) AxiEthernetUtilErrorTrap("Error committing TxBD to HW:XST_INVALID_PARAM");
		if(Status == XST_DMA_SG_LIST_ERROR) AxiEthernetUtilErrorTrap("Error committing TxBD to HW:XST_DMA_SG_LIST_ERROR");
		return XST_FAILURE;
	}
	Status = XAxiDma_BdRingStart(TxRingPtr);
	if (Status != XST_SUCCESS) {
		return XST_FAILURE;
	}
    return XST_SUCCESS;
	//print("Data Send\n");
}

int UDPRepeater(XAxiEthernet *AxiEthernetInstancePtr, XAxiDma *DmaInstancePtr)
{
	int Status;
	XAxiDma_BdRing *RxRingPtr = XAxiDma_GetRxRing(DmaInstancePtr);
	XAxiDma_BdRing *TxRingPtr = XAxiDma_GetTxRing(DmaInstancePtr);
	XAxiDma_Bd *Bd1Ptr;
	u32 BdSts;

	/*
	 * Clear variables shared with callbacks
	 */
	FramesRx = 0;
	FramesTx = 0;
	bufLen = 200;
	DeviceErrors = 0;
	memset(Data,0,2000000);

	Xil_DCacheInvalidateRange((u32)TxFrame, sizeof(TxFrame));
	Xil_DCacheInvalidateRange((u32)Data, 2000000);

	Status = XAxiEthernet_SetOptions(AxiEthernetInstancePtr,XAE_RECEIVER_ENABLE_OPTION | XAE_TRANSMITTER_ENABLE_OPTION);
	if (Status != XST_SUCCESS) {
		AxiEthernetUtilErrorTrap("Error setting options");
		return XST_FAILURE;
	}
	XAxiEthernet_Start(AxiEthernetInstancePtr);
	XAxiEthernet_IntEnable(AxiEthernetInstancePtr, XAE_INT_RECV_ERROR_MASK);
	//Prepare receive BD ring with 100 parts
	int SegLen = 80;
	int CoalLen = 120;
    GenRxRing(RxRingPtr,8000,SegLen,CoalLen,(char*)Data);
    int packets = 10;
    //TODO: Asi zbytecny radek - odstranit a overit korektni chovani
	XAxiDma_BdRingIntEnable(TxRingPtr, XAXIDMA_IRQ_ALL_MASK);
	char MyMAC[6] = { 0x00, 0x0A, 0x35, 0x03, 0x02, 0x01 };
    AxiEthernetUtilFrameHdrFormatMAC(TxFrame,MyMAC);  //TxFrame will contain the header for the UDP
	GenIPHeader(((char*)TxFrame)+XAE_HDR_SIZE,10);
    GenUDPHeader(((char*)TxFrame)+XAE_HDR_SIZE+20,10);
	xil_printf("READY\n");
    Status = XAxiDma_BdRingStart(RxRingPtr);
    	    if (Status != XST_SUCCESS) {
    		    return XST_FAILURE;
    	    }
	while(1){
	    GenRxRing(RxRingPtr,packets,SegLen,CoalLen,(char*)Data);
	    if ((packets = XAxiDma_BdRingFromHw(RxRingPtr, READ_LIMIT, &Bd1Ptr)) == 0) {
		    continue;   //Provadime poling, proto je mozne, ze nevycteme zadny paket
		}
	   BdSts = XAxiDma_BdGetSts(Bd1Ptr);
	   if ((BdSts & XAXIDMA_BD_STS_ALL_ERR_MASK) || (!(BdSts & XAXIDMA_BD_STS_COMPLETE_MASK))) {
		  AxiEthernetUtilErrorTrap("Rx Error");
		  return XST_FAILURE;
	   }
	   else {
		   u32 CntTest = 0;
		   u32 TmrTest = 0;
		   XAxiDma_BdRingGetCoalesce(RxRingPtr,&CntTest,&TmrTest);
		   //xil_printf("%d\n",packets);  //Vypise pocet prijatych paketu
		   if (GenTxRing(TxRingPtr,RxRingPtr,packets,&TxFrame, Bd1Ptr) == XST_FAILURE){
			   return XST_FAILURE;
	   	   }
	       Status = XAxiDma_BdRingFree(RxRingPtr, packets, Bd1Ptr);
	  		   if (Status == XST_DMA_SG_LIST_ERROR) {
	  			   AxiEthernetUtilErrorTrap("Error freeing up RxBDs");
	  			   return XST_FAILURE;
	  		   }
	}
	   int sendPackets = XAxiDma_BdRingFromHw(TxRingPtr, READ_LIMIT, &Bd1Ptr);
	   if (sendPackets == 0) {
		  continue;
	   }
	   else{
		   Status = XAxiDma_BdRingFree(TxRingPtr, sendPackets, Bd1Ptr);
		   if (Status != XST_SUCCESS) {
			   AxiEthernetUtilErrorTrap("Error freeing up TxBDs");
			   return XST_FAILURE;
		    }
	   }
	}  //while(1)
	//Sem bych nikdy nemel dojit
	XAxiEthernet_Stop(AxiEthernetInstancePtr);
	return XST_SUCCESS;
}

