/*
 * loopback.h
 *
 *  Created on: 21.2.2012
 *      Author: ikastil
 */

#include "../xaxiethernet_example.h"

#include "xaxidma.h"
#include "xintc.h"
#include "xil_cache.h"
#include "xil_exception.h"
#include "stdio.h"		/* stdio */

#ifndef LOOPBACK_H_
#define LOOPBACK_H_

/*
 * Counters to be incremented by callbacks
 */
static volatile int FramesRx;	/* Num of frames that have been received */
static volatile int FramesTx;	/* Num of frames that have been sent */
static volatile int DeviceErrors;/* Num of errors detected in the device */

#ifndef TESTAPP_GEN
#define AXIETHERNET_DEVICE_ID	XPAR_AXIETHERNET_0_DEVICE_ID
#define AXIDMA_DEVICE_ID	XPAR_AXIDMA_0_DEVICE_ID
#define INTC_DEVICE_ID		XPAR_INTC_0_DEVICE_ID
#define AXIETHERNET_IRPT_INTR	XPAR_INTC_0_AXIETHERNET_0_VEC_ID
#define DMA_RX_IRPT_INTR	XPAR_AXIETHERNET_0_CONNECTED_DMARX_INTR
#define DMA_TX_IRPT_INTR	XPAR_AXIETHERNET_0_CONNECTED_DMATX_INTR
#endif


#define RXBD_CNT	10000	/* Number of RxBDs to use */
#define TXBD_CNT	20000	/* Number of TxBDs to use */
#define BD_ALIGNMENT	XAXIDMA_BD_MINIMUM_ALIGNMENT/* Byte alignment of BDs */
#define PAYLOAD_SIZE	1000	/* Payload size used in examples */
#define BD_USR0_OFFSET	0	/* AXI4-Stream Control Word offset from
				 * the start of app user words in BD. Offset
				 * 0 means, Control Word 0, used for enabling
				 * checksum offloading.
				 */
#define BD_USR1_OFFSET	1	/* AXI4-Stream Control Word offset from
				 * the start of app user words in BD. Offset
				 * 1 means, Control Word 1, used for mentioning
				 * checksum begin and checksum insert points
				 */
#define BD_USR2_OFFSET	2	/* AXI4-Stream Control Word offset from
				 * the start of app user words in BD. Offset
				 * 2 means, Control Word 2, used for mentioning
				 * checksum seed.
				 */

#define PARTIAL_CSUM_ENABLE	0x00000001	/* Option for partial csum enable */
#define FULL_CSUM_ENABLE	0x00000002	/* Option for full csum enable */
#define TX_CS_INIT_OFFSET	16	/* Offset in the control word where
					 * byte offset in the ethernet frame
					 * to start CSUM calculation need to
					 * be inserted
					 */
#define RCV_FRM_NOT_CORRUPTED	0xFFFF	/* If the received frame is not
					 * corrupted, for partial csum
					 * offloading case, the control
					 * word 3 would return 0xFFFF
					 */

#define IP_VERSION_4		0x800	/* For IPV4, the Ethernet frame
					 * type/length field will have a
					 * value of 0x800
					 */
#define IP_HEADER_VERSION	0x04	/* For IPv4, the version entry in
					 * IP header is always 4
					 */
#define IP_HEADER_LEN_IN_WORDS	0x05	/* For our case, the header length
					 * is always 20 bytes (5 words
					 */
#define IP_HEADER_LENGTH	20	/* IP header length in bytes. Used
					 * as offset to kigure out the start
					 * of TCP header.
					 */
#define IP_HEADER_PROTOCOL_TCP	0x6	/* IP header protocol entry. For TCP
					 * packets, it is 6.
					 */
#define IP_HEADER_PROTOCOL_UDP	0x17	/* IP header protocol entry. For UDP
					 * packets, it is 17.
					 */
#define TCP_HEADER_LEN_IN_WORDS	0x5	/* For our case, the header length
					 * is always 20 bytes (5 words)
					 */
#define TCP_HEADER_LENGTH	20	/* IP header length in bytes. Used
					 * as offset to kigure out the start
					 * of TCP header.
					 */
#define FULL_CSUM_STATUS_MASK	0x00000038 /* Mask to extract full checksum
					    * status field from AXI4 Stream
					    * Status Word 2.
					    */

#define FULL_CSUM_VALIDATED	0x00000002 /* If bits 3-5 in AXI4 Status word
					    * have a value of 0x010, it means
					    * both IP and TCP checksums have
					    * been found to be correct.
					    */
#define IP_TCP_CSUMS_NOT_CHECKED			0x00000000
#define IP_CSUM_OK_TCP_NOT_CHECKED			0x00000001
#define TCP_CSUM_NOT_CHECKED_IP_NOT_OK		0x00000005
#define IP_CSUM_OK_TCP_NOT_OK				0x00000006

#define DUMMY_TCP_PORT_1	0x1111
#define DUMMY_TCP_PORT_2	0x1112
/*
 * Number of bytes to reserve for BD space for the number of BDs desired
 */
#define RXBD_SPACE_BYTES (XAxiDma_BdRingMemCalc(BD_ALIGNMENT, RXBD_CNT))
#define TXBD_SPACE_BYTES (XAxiDma_BdRingMemCalc(BD_ALIGNMENT, TXBD_CNT))

#define READ_LIMIT 1000000

static EthernetFrame TxFrame;	/* Transmit buffer */
static char Data[2000000];



XAxiEthernet AxiEthernetInstance;
XAxiDma DmaInstance;
/*
 * Aligned memory segments to be used for buffer descriptors
 */
char RxBdSpace[RXBD_SPACE_BYTES] __attribute__ ((aligned(BD_ALIGNMENT)));
char TxBdSpace[TXBD_SPACE_BYTES] __attribute__ ((aligned(BD_ALIGNMENT)));

/*
 * Generate new BD into he TxBD Ring and fills them with the received data.
 */
int GenTxRing(XAxiDma_BdRing* TxRingPtr,   //Pointer to Ring for sending the data
		      XAxiDma_BdRing* RxRingPtr,   //Pointer to the Ring with Received data. It takes packets
		                                   //from this ring, add UDP header and put them into TxBdRing
		      int packets,                 //Number of packets to be processed
		      EthernetFrame* TxFrame,      //Template of the UDP packet
		      XAxiDma_Bd *BdCurPtr;        //Pointer to the current possition into the RxRing
              );
/*
 * Generate new BD into RxRing
 * Since the size of the Ring is limited, it is necessary to add same
 * number of BD as the number of BDs that were used to transport packets.
 * Setting the correct number of BD is the responsibility of the caller.
 */
int GenRxRing(XAxiDma_BdRing* RxRingPtr,   //Pointer to the ring for adding packets
		      int RingLen ,    //Number of the BD descriptors which will be added into he ring
		      int SegLen,      //The length of one DB. Longer packets will be divided to
		                       // blocks of this length a shorter packet will consume the same
		                       //amount of memory as if their length was equal to SegLen.
		      int CoalLen,     //Number of packets to produce one interrupt
		                       //Make sense only if the interrupts are used.
		                       //Recommanded value is 255 because interrupt routines are slow.
		      char* Data       //Pointer to the block of the memory where the new buffer will
		                       //be placed. This memory must be allocated.
		      );

/*
 * Main function for repeating and encapsulating the network traffic.
 * This function uses polling to know, when the new packets arrives
 * and scatter/gather DMA transfers for the encapsulation.
 * The computation of the checksum in outgoing packets is offloaded
 * into he hardware. Therefore full checksum offload has to be activated
 * in the ethernet device.
 * The function answers on the same ethernet port where it listens.
 * This limitation is implemented because ML605 has only one ethernet port.
 * If there is several ethernet port, this function may be used, however,
 * if the input and output interface differs, the new function should be implemented.
 * The GenTX and GenRx may be used in both cases.
 */
int UDPRepeater(XAxiEthernet *AxiEthernetInstancePtr,   //Pointer to the AXI_ethernet used as an input/output
				XAxiDma *DmaInstancePtr   //Pointer to the DMA controller used for the Ethernet from previous parameter
				);


#endif /* LOOPBACK_H_ */
