/*
 * Sec6net XILINX AXI DMA driver. User space header file.
 */

#ifndef SEC6NET_XAXIDMA_H
#define SEC6NET_XAXIDMA_H


#define DESC_SOF        0x08000000 /* SOF in descriptor */
#define DESC_EOF        0x04000000 /* EOF in descriptor */
#define DESC_SOF_EOF    0x0C000000 /* Both SOF and EOF in descriptor */
#define LEN_MASK        0x007FFFFF /* Length mask for status and control */
#define DSC_COMPLETE    0x80000000 /* Descriptor is processed - complete */

/* This structure defines DMA descriptor */
struct dma_ring {
    uint32_t next;           /* Physical address of next buffer descriptor */
    uint32_t res0;           /* Reserved */
    uint32_t buffer;         /* Physical address of buffer */
    uint32_t res1[3];        /* Reserved */
    uint32_t control;        /* Control word */
    uint32_t status;         /* Status word */
    uint32_t application[5]; /* Application atributes */
    uint32_t res2[3];        /* Reserved */
} __attribute__((aligned(64))); /* Descriptor must be aligned to 64B */

#define RING_ALIGNMENT    0x40 /* Descriptor must be aligned to 64B */

/* Settings of dma channels */
struct dma_settings {
    uint32_t rx_act_timeout;   /* RX Active timeout */
    uint32_t rx_inact_timeout; /* RX Inctive timeout */
    uint32_t tx_act_timeout;   /* TX Active timeout */
    uint32_t tx_inact_timeout; /* TX Inctive timeout */
    uint32_t rx_ring_len;      /* RX Ring length */
    uint32_t tx_ring_len;      /* TX Ring length */
    uint32_t rx_buffer_len;    /* RX Buffer length */
    uint32_t tx_buffer_len;    /* TX Buffer length */
    uint32_t rx_mode;          /* RX Channel settings */
    uint32_t tx_mode;          /* TX Channel settings */
    uint32_t rx_desc_len;      /* RX Descriptor ring length */
    uint32_t tx_desc_len;      /* TX Descriptor ring length */
    uint32_t allocation_size;  /* Allocation size for kernel buffer allocation 
                             form userspace */
};

struct dma_status {
	uint32_t rx_control;
	uint32_t rx_status;
	uint32_t rx_current;
	uint32_t rx_tail;
	uint32_t tx_control;
	uint32_t tx_status;
	uint32_t tx_current;
	uint32_t tx_tail;
};

#define TX_COPY   0x00000000
#define TX_DIRECT 0x00000001
#define TX_MMAP   0x00000002

#define RX_COPY   0x80000000
#define RX_DIRECT 0x80000001
#define RX_MMAP   0x80000002

struct mmaped_dma {
    uint32_t start;
    uint32_t len;
};

#define MAX_DELAY       0x000000FF /* Maximal delay for to active and inactive timeouts. */
#define THRES_MASK      0x00FF0000 /* Threshold mask */
#define DELAY_MASK      0xFF000000 /* Delay mask */
#define MAX_RING        0x00100000 /* Maximal length of each ring - 16MB*/
#define MAX_BUFFER      0x00100000 /* Maximal length of each buffer - same as max size of ring */
#define MIN_BUFFER      0x00000400 /* Minimal size of each buffer - 1kB */
#define POINTER_SIZE    0x00010000 /* Size of ring pointer array - 64kB */

#define DIR_RX 1 /* RX direction */
#define DIR_TX 2 /* TX direction */

// TODO: Rework
#define IOCTL_MAGIC 0xDE                      /* IOCTL magic number*/
#define START_RX_DMA  _IO(IOCTL_MAGIC, 0xA0)   /* Start RX DMA */
#define START_TX_DMA  _IO(IOCTL_MAGIC, 0xA1)   /* Start TX DMA */ 
#define STOP_RX_DMA   _IO(IOCTL_MAGIC, 0xA2)   /* Stop RX DMA */
#define STOP_TX_DMA   _IO(IOCTL_MAGIC, 0xA3)   /* Stop TX DMA */
#define RESET_RX_DMA  _IO(IOCTL_MAGIC, 0xA4)   /* Reset RX DMA */
#define RESET_TX_DMA  _IO(IOCTL_MAGIC, 0xA5)   /* Reset TX DMA */
#define GET_SETTINGS  _IOR(IOCTL_MAGIC, 0xA6, struct dma_settings *) /* Get DMA settings */
#define SET_SETTINGS  _IOW(IOCTL_MAGIC, 0xA7, struct dma_settings *) /* Set DMA settings */
#define RX_PERF       _IOW(IOCTL_MAGIC, 0xA8, int) /* Run DMA in RX performance mode */
#define TX_PERF       _IOW(IOCTL_MAGIC, 0xA9, int) /* Run DMA in TX performance mode */
#define RX_MMAP_GET   _IOR(IOCTL_MAGIC, 0xAA, struct mmaped_dma *) /* Get start position in RX ring 
                                                                    and length */
#define RX_MMAP_FREE  _IOW(IOCTL_MAGIC, 0xAB, struct mmaped_dma *) /* Inform driver that operations 
                                                                    on N items are finished, Ring 
                                                                    items can be reused.*/ 
#define TX_MMAP_ALLOC _IOR(IOCTL_MAGIC, 0xAC, struct mmaped_dma *) /* Get start position in TX ring 
                                                                    and number of free buffers */
#define TX_MMAP_PUT   _IOW(IOCTL_MAGIC, 0xAD, struct mmaped_dma *) /* Inform driver than N buffers 
                                                                    can be transmited */
#define GET_STATUS    _IOR(IOCTL_MAGIC, 0xAE, struct dma_status *) /* Get DMA settings */

#define DRIVER_NAME "sec6net_dma_driver" /* Driver name */

#define RUN 1  /* DMA channel is running */
#define STOP 0 /* DMA channel is stopped */

/* MMAP page offsets for mapping data to userspace: kernel variant */
#define MMAP_RX_DESC_UOFFSET (0x00000000 * sysconf(_SC_PAGESIZE)) /* RX descriptor ring */
#define MMAP_TX_DESC_UOFFSET (0x00020000 * sysconf(_SC_PAGESIZE)) /* TX decriptor ring */
#define MMAP_RX_RING_UOFFSET (0x00040000 * sysconf(_SC_PAGESIZE)) /* RX buffer ring */
#define MMAP_TX_RING_UOFFSET (0x00060000 * sysconf(_SC_PAGESIZE)) /* TX buffer ring */
#define MMAP_ALLOC_UOFFSET   (0x00010000 * sysconf(_SC_PAGESIZE)) /* Allocation */

#endif /* SEC6NET_XAXIDMA_H */
