#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdint.h>
#include "axi_dma.h"

int main(int argc, char **argv)
{
    struct dma_status status;
    int f = open(argv[1], O_RDWR);

    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    
    ioctl(f, GET_STATUS, &status);

    printf("RX Control: %8x\n", status.rx_control);
    printf("RX Status:  %8x\n", status.rx_status);
    printf("RX Current: %8x\n", status.rx_current);
    printf("RX Tail:    %8x\n", status.rx_tail);
    printf("TX Control: %8x\n", status.tx_control);
    printf("TX Status:  %8x\n", status.tx_status);
    printf("TX Current: %8x\n", status.tx_current);
    printf("TX Tail:    %8x\n", status.tx_tail);
    
    close(f);
}
