#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <sys/mman.h>
#include <stdint.h>
#include <termios.h>
#include "axi_dma.h"
#include "libaio.h"
#include "stb_image.c"

uint8_t* buffer[1000];
struct iovec iov[1000];
struct iocb viocb;
struct io_event event;
struct termios initial_settings, new_settings;

int compare_uint8_t (const void * a, const void * b)
{
  if ( *(uint8_t*)a <  *(uint8_t*)b ) return -1;
  if ( *(uint8_t*)a == *(uint8_t*)b ) return 0;
  if ( *(uint8_t*)a >  *(uint8_t*)b ) return 1;
}

uint32_t get_val_rgb(uint32_t* data, int x, int y, int maxx, int maxy)
{
	x = abs(x);
	y = abs(y);
	if (x >= maxx)
		x = (maxx - 1) - (x - maxx - 1);
	if (y >= maxy)
		y = (maxy - 1) - (y - maxy - 1);
	return data[y*maxx + x];
}

#define RED(n) ((n >> 16) & 0x000000FF)
#define GREEN(n) ((n >> 8) & 0x000000FF)
#define BLUE(n) (n & 0x000000FF)

uint32_t to_rgb(uint32_t r, uint32_t g, uint32_t b)
{
	uint32_t ret = 0;
	ret = (r << 16) | (g << 8) | b;
	return ret;
}

uint32_t median_rgb_9(uint32_t* data, int x, int y, int maxx, int maxy)
{
	uint8_t r[9];
	uint8_t g[9];
	uint8_t b[9];
	int i,j, k, cnt = 0;
	uint32_t rgb;

	for (j = y - 1; j <= y + 1; j++)
		for (i = x - 1; i <= x + 1; i++)
		{
			rgb = get_val_rgb(data, i, j, maxx, maxy);
			r[cnt] = RED(rgb);
			g[cnt] = GREEN(rgb);
			b[cnt] = BLUE(rgb);
			cnt++;
		}
	
	qsort(r, 9, sizeof(uint8_t), compare_uint8_t);
	qsort(g, 9, sizeof(uint8_t), compare_uint8_t);
	qsort(b, 9, sizeof(uint8_t), compare_uint8_t);
	
	return to_rgb(r[4], g[4], b[4]);
}

void median_9(uint32_t *dst_data, uint32_t* src_data, int maxx, int maxy)
{
	int i,j, cnt;
	cnt = 0;
	for (j = 0; j < maxy; j++)
		for (i = 0; i < maxx; i++)
		{
			dst_data[cnt] = median_rgb_9(src_data, i , j, maxx, maxy);
			cnt++;
		}
}

int main(int argc, char **argv)
{
    int f = open(argv[1], O_RDWR);
    int i;
	int j;
    int k;
	int c;
	int len;
	int ret;
	uint64_t val = 0;
	uint8_t *ptr;
	uint8_t *ptr2;
	struct iocb *pviocb;
	struct dma_settings settings;
	unsigned char key;
    int fd;
    int x,y,n;
    unsigned char *data = stbi_load(argv[2], &x, &y, &n, 0);
    uint32_t * sw_filter;
	uint32_t state;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    fd = open("/dev/mem", O_RDWR);
	if (fd == -1)
	{
		fprintf(stderr, "Failed to open file /dev/mem\n");
        return 1;
	}
	
	sw_filter = (uint32_t *)mmap(0, 4096, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0x41220000);
	state = 0;
	
    io_context_t ctx;
    memset(&ctx, 0, sizeof(ctx));
    ret = io_queue_init(1, &ctx);
	if (ret < 0)
	{
		fprintf(stderr, "Failed to init io queue\n");
        return 1;
	}

    ioctl(f, GET_SETTINGS, &settings);
	settings.tx_act_timeout = 1;
	settings.tx_inact_timeout = 0;
    settings.allocation_size = 0x384000;
    settings.tx_mode = TX_DIRECT;
    ioctl(f, SET_SETTINGS, &settings);
	
    for (i = 0; i < 2; i++)
	{
		buffer[i] = mmap(NULL, 0x384000, PROT_WRITE, MAP_SHARED, f, MMAP_ALLOC_UOFFSET);
		if (!buffer[i])
		{
			fprintf(stderr, "Failed to mmap memory at %x\n", MMAP_ALLOC_UOFFSET);
            return 1;
		}
		iov[i].iov_base = buffer[i];
		iov[i].iov_len = 0x384000;
	}

	ptr = (uint8_t *)buffer[1];
	ptr2 = (uint8_t *)data;
    for (i = 0; i < 720; i++)
	for (j = 0; j < 1280; j++)
	{
		if ((i < y) && (j < x))
		{
			ptr[0] = ptr2[2];
			ptr[1] = ptr2[1];
			ptr[2] = ptr2[0];
			ptr[3] = 0;
			ptr2 += 3;
		}
		ptr += 4;
	}
	
	median_9((uint32_t*)buffer[0], (uint32_t*)buffer[1], 1280, 720);
	
	fprintf(stderr, "Start setting attr\n");
	tcgetattr(0,&initial_settings);
 
	new_settings = initial_settings;
	new_settings.c_lflag &= ~ICANON;
	new_settings.c_lflag &= ~ECHO;
	new_settings.c_lflag &= ~ISIG;
	new_settings.c_cc[VMIN] = 0;
	new_settings.c_cc[VTIME] = 0;
	
	tcsetattr(0, TCSANOW, &new_settings);
    fprintf(stderr, "Done setting attr\n");
    ioctl(f, START_TX_DMA, 0);

    for(;;)
	{
        io_prep_pwritev(&viocb, f, iov, 1, 0);
		pviocb = &viocb;
		if (io_submit(ctx, 1, &pviocb) < 0)
		{
			fprintf(stderr, "AIO writev failed\n");
		}
// 		fprintf(stderr, "TX AIO loop %d\n", i);
        c = getchar();
		if (c != EOF)
		{
			key = c;
			if (key == 'q' || key == 'Q')
			{
				break;
			}
			else
			{
				if (state == 0)
					state = 0xffffffff;
				else
					state = 0;
				*(sw_filter + 1) = state;
			}
		}
		ret = io_getevents(ctx, 1, 1, &event, NULL);
		if (ret < 1)
		{
			fprintf(stderr, "AIO get event failed\n");
		}
	}
	io_queue_release(ctx);
    close(f);
	for (i = 0; i < 1; i++)
	{
		if(munmap(buffer[i], 0x384000))
			fprintf(stderr, "Failed to unmap buffer %d\n", i);
	}
	tcsetattr(0, TCSANOW, &initial_settings);
}