#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <stdint.h>
#include "axi_dma.h"

char buffer[100000*1024] __attribute__((aligned(4)));

int main(int argc, char **argv)
{
    int f = open(argv[1], O_RDONLY);
    int i;
	uint32_t *ptr;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }


    ioctl(f, START_RX_DMA, 0);
    for(i = 0; i < 100000; i++)
	{
        read(f, &(buffer[i*1024]), 1024);
		fprintf(stderr, "Read RX buffer %d\n", i);
	}
	
    ptr = (uint32_t *)buffer;
    for (i = 0; i < 100000*1024/4; i++)
	{
		if (*ptr != i)
		{
			fprintf(stderr, "Error in frame %d Possition: %d\n", i*4/1024, i*4%1024);
		}
		ptr++;
	}

    close(f);
}

