#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <stdint.h>
#include "axi_dma.h"

#define IOV_LEN 1000
#define BUFFER_COUNT 100000

char buffer[BUFFER_COUNT*1024] __attribute__((aligned(4)));
struct iovec iov[IOV_LEN];

int min(int procesed, int req)
{
	if (BUFFER_COUNT - procesed < req)
	{
		return BUFFER_COUNT - procesed;
	}
	else
	{
		return req;
	}
}

int main(int argc, char **argv)
{
    int f = open(argv[1], O_RDONLY);
    int i,j;
	int len;
	uint32_t *ptr;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }


    ioctl(f, START_RX_DMA, 0);
    while (i < BUFFER_COUNT)
    {
		for (j = 0; j < min(i, IOV_LEN); j++)
		{
			iov[j].iov_base = buffer + (i + j) * 1024;
			iov[j].iov_len = 1024;
		}
        len = readv(f, iov, min(i, IOV_LEN));
        i+= len / 1024;
		fprintf(stderr, "Read Partial Total: %d\n", i);
    }
	
    ptr = (uint32_t *)buffer;
    for (i = 0; i < BUFFER_COUNT*1024/4; i++)
	{
		if (*ptr != i)
		{
			fprintf(stderr, "Error in frame %d Possition: %d\n", i*4/1024, i*4%1024);
		}
		ptr++;
	}

    close(f);
}
