#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <stdint.h>
#include "axi_dma.h"

char buffer[100000*1024] __attribute__((aligned(4)));

int main(int argc, char **argv)
{
    int f = open(argv[1], O_WRONLY);
    int i;
	uint32_t *ptr;
	int ret;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    ptr = (uint32_t *)buffer;
    for (i = 0; i < 100000*1024/4; i++)
	{
		*ptr = i;
		ptr++;
	}

    ioctl(f, START_TX_DMA, 0);
    for(i = 0; i < 100000; i++)
	{
        ret = write(f, &(buffer[i*1024]), 1024);
		if (ret != 1024)
		{
			fprintf(stderr, "Error while writing %d\n", i);
		}
		fprintf(stderr, "Write TX buffer %d\n", i);
	}
    sleep(10);
    close(f);
}
