#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <stdint.h>
#include "axi_dma.h"

char buffer[1000*1024];
struct iovec iov[1000];

int main(int argc, char **argv)
{
    int f = open(argv[1], O_WRONLY);
    int i;
	
    if (f == -1)
    {
        fprintf(stderr, "Failed to open file %s\n", argv[1]);
        return 1;
    }

    for (i = 0; i < 1000; i++)
	{
		iov[i].iov_base = buffer + i * 1024;
		iov[i].iov_len = 1024;
	}

    ioctl(f, START_TX_DMA, 0);

    for(i = 0; i < 1000; i++)
        writev(f, iov, 1000);
    close(f);
}
