#! /bin/sh

###
# Generates DTS file needed for Linux kernel compilation.
# Prerequisities: known FPGA type, downloaded BSP (device-tree),
#                 MSS, MHS files, target processor id
# The generation occures in a tmp directory.
#
# All logging is prefixed by "[DTS-GEN]" string (not the Xilinx's output!).
#
# Usage: ./gen-dts.sh <tmp-dir> <bsp-dir> <mhs> <mss> <fpga> <dts-src> <dts-dst>
#
#   <dts-src> is path to the DTS file generated by the given BSP (each BSP can
#             generate different file names...)
#   <dts-dst> destination, where to put the generated DTS file
###

dts_generate()
{
	tmp_dir="$1"
	shift
	bsp_dir="$1"
	shift
	processor="$1"
	shift
	mhs_file="$1"
	shift
	mss_file="$1"
	shift
	fpga_type="$1"
	shift
	dts_src="$1"
	shift
	dts_dst="$1"
	shift

	echo "[DTS-GEN] Generating DTS file ($fpga_type, $processor, $bsp_dir)" > /dev/stderr

	check=`grep '^[^#]*PARAMETER.*OS.*standalone' $mss_file | wc -l`
	if [ $check != 0 ]; then
		echo "[DTS-GEN] The MSS file $mss_file seems to be incorrect (OS standalone)" > /dev/stderr
		sleep 2
	fi

	mkdir -p "$tmp_dir"
	libgen -od "$tmp_dir" -lp "$bsp_dir" -mhs "$mhs_file" -p "$fpga_type" -pe "$processor" "$mss_file"
	
	if [ "$?" != "0" ]; then
		exit 1
	fi

	cp "$dts_src" "$dts_dst"
#	rm -Rf "$tmp_dir"
	ls -lh "$dts_dst"
}

dts_generate "$@"
