#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# strip_ini3.py: Strips INI3 cover of packet
# Copyright (C) 2013 
# Author: Vlastimil Kosar <ikosar@fit.vutbr.cz>
#
#

import sys
import struct

if len(sys.argv) != 3:
  print("Convert PCAP file to PCAP file. Removes ETH/IP/UDP/INI3 headers to get sniffed packets.")
  print("Usage:")
  print("unpack_ini3_pcap.py in.pcap out.pcap")
  exit()

#pcap = pcapy.open_offline(sys.argv[1])
fpcap = open(sys.argv[1],"rb")
fsim = open(sys.argv[2], "wb")
code = fpcap.read(4)

if code == "\xa1\xb2\xc3\xd4":
    endianity = ">"
elif code == "\xd4\xc3\xb2\xa1":
    endianity = "<"

wrapper_len = 58

stopFlag = 0

fsim.write(struct.pack("IHHIIII", 0xa1b2c3d4L, 2, 4, 0, 0, 1600, 1))

pcapHeader = fpcap.read(20)
packetHeader = fpcap.read(16)
if len(packetHeader) < 16:
  stopFlag = 1
else:
  seconds,useconds,captureLength,wireLength = struct.unpack(endianity + "IIII", packetHeader)
  packet = fpcap.read(captureLength)

#pkt = pcap.next()
g = str()
while (stopFlag == 0):
  fsim.write(struct.pack("IIII", seconds, useconds, captureLength - wrapper_len, wireLength-wrapper_len))
  fsim.write(packet[wrapper_len:])
  
  packetHeader = fpcap.read(16)
  if len(packetHeader) < 16:
    stopFlag = 1
  else:
    seconds,useconds,captureLength,wireLength = struct.unpack(endianity + "IIII", packetHeader)
    packet = fpcap.read(captureLength)

fpcap.close()
fsim.write(g)
fsim.close()