--[[
  File: ceaser.lua
  Desc: Ceaser's encoding/decoding algorithm
  Author: Jan Drazil
]]

function ceasarEncode(key, str)
  letters={}
  for i=1,str:len() do
    table.insert(letters, string.byte(str, i))
  end
  for i=1,#letters do
    letters[i]=string.char((tonumber(letters[i]) + key)%128)
  end
  return table.concat(letters, '')
end

function ceasarDecode(key, str)
  letters={}
  for i=1,str:len() do
    table.insert(letters, string.byte(str, i))
  end
  for i=1,#letters do
    letters[i]=string.char((tonumber(letters[i]) - key)%128)
  end
  return table.concat(letters, '')
end

--Example of use
--[[
str="Hello World!";
key   = 12;
cypher=ceasarEncode(key, str)
decoded=ceasarDecode(key, cypher)
print(cypher)
print(decoded)
]]
