--[[
  File: heapSort.lua
  Desc: Sort list contains numbers
  Author: Jan Drazil
]]

function heapSort(data)
  size=#data
  for i=math.floor(size/2),1,-1 do
    data=makeHeap(data, size, i)
  end
  for i=size,1,-1 do
    tmp=data[1]
    data[1]=data[i]
    data[i]=tmp
    data=makeHeap(data, i-1, 1)
  end
  return data
end

function makeHeap(data, bottom, topIndex)
  tmp = data[topIndex]
  succ = topIndex*2
  if (succ < bottom and data[succ] < data[succ+1]) then
    succ=succ+1
  end

  while (succ <= bottom and tmp < data[succ]) do
    data[topIndex] = data[succ]
    topIndex = succ;
    succ = succ*2
    if (succ < bottom and data[succ] < data[succ+1]) then
      succ=succ+1
    end
  end
  data[topIndex] = tmp
  return data
end
