--[[
  File: quickSort.lua
  Desc: Sort list contains numbers
  Author: Jan Drazil
]]

function quickSort(data)
  stack={1,#data}
  while(#stack ~= 0) do
    right=table.remove(stack, #stack)
    left=table.remove(stack, #stack)
    while(left<right) do
      q=qsPartition(data, left, right)
      data=q['data']
      table.insert(stack,q['cut'])
      table.insert(stack,right)
      right=q['cut']-1;
    end
  end
  return data
end

function qsPartition(data, left, right)
  pivot = data[right]
  i=left-1
  for j=left,right-1 do
    if(data[j] <= pivot) then
      i=i+1
      tmp=data[i]
      data[i]=data[j]
      data[j]=tmp
    end
  end
  tmp=data[i+1]
  data[i+1]=data[right]
  data[right]=tmp
  return {['data']=data, ['cut']=i+1}
end
