--[[
  File: recursQuickSort.lua
  Desc: Sort list contains numbers
  Author: Jan Drazil
]]

function recursQuickSort(data)
  return recursQuickSortAlg(data, 1, #data)
end

function recursQuickSortAlg(data, left, right)
  if(left<right) then
    q=qsPartition(data, left, right)
    data=recursQuickSortAlg(q['data'], left, q['cut']-1)
    data=recursQuickSortAlg(data, q['cut']+1, right)
  end
  return data
end

function qsPartition(data, left, right)
  pivot = data[right]
  i=left-1
  for j=left,right-1 do
    if(data[j] <= pivot) then
      i=i+1
      tmp=data[i]
      data[i]=data[j]
      data[j]=tmp
    end
  end
  tmp=data[i+1]
  data[i+1]=data[right]
  data[right]=tmp
  return {['data']=data, ['cut']=i+1}
end
