<?php
/**
  File: vernam.py
  Desc: Vernams's cypher
  Author: Jan Drazil
*/

function vernamEncode($key, $string)
{
  $letters=str_split($string);
  $keys=explode(';', $key);
  $size=count($letters);
  for($i=0 ; $i<$size ; $i++)
    $letters[$i]=ord($letters[$i]) ^ (int) $keys[$i];
  return implode(';', $letters);
}
  
function vernamDecode($key, $cypher)
{
  $letters=explode(';',$cypher);
  $keys=explode(';',$key);
  $size=count($letters);
  for($i=0 ; $i<$size ; $i++)
    $letters[$i]=chr((int) $letters[$i] ^ (int) $keys[$i]);
  return implode('',$letters);
}
  
#Example of use
#$string="Hello World!";
#$key   ="97;74;81;81;238;210;156;221;16;227;168;133;212;";
#$cypher=vernamEncode($string, $key);
#$decoded=vernamDecode($cypher, $key);
#print($cypher . "\n");
#print($decoded);

?>