<?php 
/**
  File: binaryRecursiveSearch.php
  Desc: Return index of item by given value
  Author: Jan Drazil
*/

function binaryRecursiveSearch($value,$data)
{
  return binaryRecursiveSupport($value,$data,0,count($data)-1);
}
  
function binaryRecursiveSupport($value,$data,$left,$right)
{
  if($left == $right && $data[$left] != $value)
    return -1;
    
  $middle=floor(($left+$right)/2);
  if($data[$middle] == $value)
    return $middle;
  elseif($data[$middle] < $value)
    return binaryRecursiveSupport($value,$data,$middle+1,$right);
  else
    return binaryRecursiveSupport($value,$data,$left,$middle-1);
}
?>