<?php
/**
  File: heapSort.php
  Desc: Sort list contains numbers
  Author: Jan Drazil
*/

function heapSort($data)
{
  $size=count($data);
  for($i = round($size/2) - 1; $i >= 0; $i--)
    $data=makeHeap($data, $size - 1, $i);
  for($i = $size - 1; $i > 0; $i--)
  {
    $tmp=$data[0];
    $data[0]=$data[$i];
    $data[$i]=$tmp;
    $data=makeHeap($data, $i - 1, 0);
  }
  return $data;
}
  
function makeHeap($data, $bottom, $topIndex)
{
  $tmp = $data[$topIndex];
  $succ = $topIndex*2 + 1;
  if ($succ < $bottom and $data[$succ] < $data[$succ+1])
    $succ++;
    
  while ($succ <= $bottom and $tmp < $data[$succ])
  {
    $data[$topIndex] = $data[$succ];
    $topIndex = $succ;
    $succ = $succ*2 + 1;
    if ($succ < $bottom and $data[$succ] < $data[$succ+1])
      $succ++;
  $data[$topIndex] = $tmp; 
  }
  return $data;
}
?>