<?php
/**
  File: arrayToTree.php
  Desc: Convert list to tree
  Author: Jan Drazil
*/

/*
Create structure:
      root={'value':value, 'tree':[child_1, child_2, ... ,child_n]} for n>=0
      child_n = {'value':value, 'tree':[child_1, child_2, ... ,child_n]} for n>=0
*/
function arrayToTree($data)
{
  $result=createTree($data, 0);
  return $result['tree']; 
}

function createTree($data, $actualIndex)
{
  $args = explode(";",$data[$actualIndex]);
  if($args[0]==0)
  {
    return array('tree'=>array('value'=>$args[1], 'tree'=>array()), 'lastIndex'=>$actualIndex);
  }
  else
  {
    $tree['value']=$args[1];
    for($i=0; $i<$args[0]; $i++)
    {
      $newTree=createTree($data,$actualIndex+1);
      $tree['tree'][]=$newTree['tree'];
      $actualIndex=$newTree['lastIndex'];
    }
    return array('tree'=>$tree, 'lastIndex'=>$actualIndex);
  }
}
?>