"""
  File: RSA.py
  Desc: RSA encoding/decoding algorithm
  Author: Jan Drazil
"""

def gcd(a, b):
  """Euclidean Algorithm for greatest common divisor"""  
  while(b!=0):
    tmp = a % b
    a = b
    b = tmp
  return a;

def EEA(a,b):
  """Extended Euclidean Algorithm"""
  if(a<b):
    tmp=a
    a=b
    b=tmp
    
  alfa1,alfa2,beta1,beta2 = 0,1,1,0
  q,r=0,0
  while(b>0):
    q=int(a/b)
    r=a-q*b
    a,b=b,r
    tmp=alfa2
    alfa2=alfa1
    alfa1=tmp-q*alfa1
    tmp=beta2
    beta2=beta1
    beta1=tmp-q*beta1
  return [a, alfa2, beta2]
    
  
  
  
def RSAcreateKey(prime1, prime2):
  """Create public and private key"""
  n=prime1*prime2
  eulerTotient=(prime1-1)*(prime2-1)
  for i in reversed(range(2,eulerTotient-1)):
    if(gcd(i, eulerTotient) == 1):
      exponent=i
      break;
  d=EEA(exponent,eulerTotient)
  d=d[2] #multiplicative inverse
  if(d<0):
    d+=eulerTotient #fix negative value in Z_eulerTotient
  return {'privateKey': {'exponent': exponent, 'modulus': n}, 'publicKey': {'exponent': d, 'modulus': n}}
  

def RSAencode(publicKey, string):
  letters = list(string)
  for i in range(len(letters)):
    letters[i]=RSAUseKey(publicKey, ord(letters[i]))
  return letters;
  
def RSAdecode(privateKey, intList):
  for i in range(len(intList)):
    intList[i]=chr(RSAUseKey(privateKey, intList[i]))
  return ''.join(intList);
  
def RSAUseKey(key, number):
  """Apply key to number"""
  modulus,exponent=key['modulus'],key['exponent']
  # (a * b) mod c = ((a mod c)(b mod c)) mod c
  # x^y mod z = (x*x*x*x*...*x) mod z
  parcMod = number % modulus
  result = parcMod
  
  for i in range(exponent-1):
    result = (result * parcMod) % modulus
  return result;

#Example of use
#keys=RSAcreateKey(907, 997)
#cypher=RSAencode(keys['publicKey'],"Hello World!")
#print(cypher)
#print(RSAdecode(keys['privateKey'],cypher))