"""
  File: vernam.py
  Desc: Vernams's cypher
  Author: Jan Drazil
"""

def vernamEncode(key, string):
  letters=list(string)
  keys=key.split(';')
  for i in range(len(letters)):
    letters[i]=str(ord(letters[i]) ^ int(keys[i]))
  return ';'.join(letters)
  
def vernamDecode(key, cypher):
  letters=cypher.split(';')
  keys=keys=key.split(';')
  for i in range(len(letters)):
    letters[i]=chr(int(letters[i]) ^ int(keys[i]))
  return ''.join(letters)  
  
#Example of use
#string="Hello World!";
#key   ="97;74;81;81;238;210;156;221;16;227;168;133;212;";
#cypher=vernamEncode(string, key)
#decoded=vernamDecode(cypher, key)
#print(cypher)
#print(decoded)