"""
  File: recursQuickSort.py
  Desc: Sort list contains numbers
  Author: Jan Drazil
"""

def recursQuickSort(data):
  return recursQuickSortAlg(data, 0, len(data)-1)
  
def recursQuickSortAlg(data, left, right):
  if(left<right):
    q=qsPartition(data, left, right)
    data=recursQuickSortAlg(q['data'], left, q['cut']-1)
    data=recursQuickSortAlg(data, q['cut']+1, right)
  return data
  
def qsPartition(data, left, right):
  pivot = data[right]
  i=left-1
  for j in range(left,right):
    if(data[j] <= pivot):
      i+=1
      tmp=data[i]
      data[i]=data[j]
      data[j]=tmp
  tmp=data[i+1]
  data[i+1]=data[right]
  data[right]=tmp
  return {'data':data, 'cut':i+1}