"""
  File: generateCeasar.py
  Desc: Generate file for Vernam's cypher
  Author: Jan Drazil
  
  File format:
    first line string in plain text
    second line generated key 
"""

import random
import sys
from optparse import OptionParser

parser = OptionParser()
parser.add_option("-f", "--file", type="string", dest="filename", help="Name of generated file")
parser.add_option("-s", "--string", type="string", dest="string", help="Generate key to this string")
(options, args) = parser.parse_args()
filename,string=options.filename,options.string,

if(filename is None):
  sys.stderr.write("Option -f is required.\n");
  exit(1);

if(string is None):
  string = ""
  for line in sys.stdin:
    string += line.rstrip()

try:
  f = open(filename, 'w');
except IOError:
  sys.stderr.write("Cannot open file " + filename + " for writing.")
  exit(1)

with f:  
  f.write(string + "\n")
  f.write(str(random.randrange(1000)) + "\n");
    
exit(0);