"""
  File: generatePHP.py
  Desc: Create PHP script combine data and function
  Author: Jan Drazil
"""
import sys, io, os, re
from optparse import OptionParser

scriptPath=os.path.dirname(os.path.realpath(sys.argv[0]))
sys.path.append(os.path.realpath(scriptPath + "/../Python3/support"))
sys.path.append(os.path.realpath(scriptPath + "/../Python3/tree/"))
from readItems import readItems
from printItems import printItems
from arrayToTree import arrayToTree

def createDataStructure(name, data):
  """Transfer python structures to PHP structures"""
  structure = io.StringIO();
  if(type(data) is list):
    transferList(data, structure)
  elif(type(data) is dict):
    transferDict(data, structure)
  result = "$" + name + " = " + structure.getvalue() + ";"; 
  structure.close()
  return result

def transferList(data, buffer):
  """Transfer python list to PHP array"""
  buffer.write("array(")
  firstItem=True
  for item in data:
    if(not firstItem):
      buffer.write(",")
    firstItem=False
      
    if(type(item) is list):
      transferList(item, buffer)
    elif(type(item) is dict):
      transferDict(item, buffer)
    elif(type(item) is int):
      buffer.write(str(item))
    else:
      buffer.write("\""+ str(item) +"\"")
    
  buffer.write(")")  
    
def transferDict(data, buffer):
  """Transfer python dict to PHP associative array"""
  buffer.write("array(")
  firstItem=True
  for item in data:
    if(not firstItem):
      buffer.write(" ,")
    firstItem=False
      
    buffer.write("\""+ str(item) +"\" => ")
    if(type(data[item]) is list):
      transferList(data[item], buffer)
    elif(type(data[item]) is dict):
      transferDict(data[item], buffer)
    elif(type(data[item]) is int):
      buffer.write(str(data[item]))
    else:
      buffer.write("\""+ str(data[item]) +"\"")
    
  buffer.write(")")  

  
parser = OptionParser()
parser.add_option("-f", "--file", type="string", dest="filename", help="Name of generated file.")
parser.add_option("-s", "--script", type="string", dest="script", help="Script file")
parser.add_option("-d", "--data", type="string", dest="data", help="Data file")
parser.add_option("--find", type="string", dest="find", help="Data to find")
parser.add_option("-t", "--time", action="store_true", dest="time", help="Add to script execution time", default=False)
(opt, args) = parser.parse_args()

if(opt.filename is None or opt.script is None or opt.data is None):
  sys.stderr.write("Options -f, -s and -d are required.\n");
  sys.exit(1);

### Open files, copy script to destination and prepare data
try:
  scriptFile=open(opt.script, "r")
  destFile=open(opt.filename, "w")
  #destFile=io.StringIO()
  destFile.write("<?php\n")
  if opt.time:
    destFile.write("$executionTime=microtime(true);\n");
  startPHP=True
  #Remove <?php and ?>
  for line in scriptFile:
    if(startPHP and not re.match(r"^(\s*)<\?php(.*)", line) is None):
      destFile.write(re.sub(r"^(\s*)<\?php(.*)", r'\1\2', line, flags=re.ASCII))
      startPHP=False
    elif(not startPHP and not re.match(r"^(\s*)\?>(.*)", line) is None):
      destFile.write(re.sub(r"^(\s*)\?>(.*)", r'\1\2', line, flags=re.ASCII))
      startPHP=True
    else:
      destFile.write(line)
    
  destFile.write("\n\n\n###Generated###\n")
  scriptFile.close()
  data=readItems(opt.data)
except IOError:
  sys.stderr.write("Cannot open one of given files"); 
  
scriptType = os.path.split(os.path.split(os.path.realpath(opt.script))[0])[1] #get last dir name in path to script
scriptName = os.path.splitext(os.path.split(os.path.realpath(opt.script))[1])[0]
exitCode=0

#Specilization
if scriptName == "RSA":
  #data[0] => fist prime
  #data[1] => second prime
  #data[2] => string
  destFile.write("$keys=RSAcreateKey("+ str(data[0]) +", "+ str(data[1]) +");\n")
  destFile.write("print(RSAdecode($keys['publicKey'], RSAencode($keys['privateKey'], \""+ data[2] +"\")));")
  
elif scriptName == "manyVarialbes":
  destFile.write("manyVariables();\n")

elif scriptName == "arrayToTree":
  try:
    printItemsFile=open(scriptPath + "/../PHP/support/printTree.php", "r")
    #remove <?php and ?> from printItems and include into new file
    startPHP=True
    for line in printItemsFile:
      if(startPHP and not re.match(r"^(\s*)<\?php(.*)", line) is None):
        destFile.write(re.sub(r"^(\s*)<\?php(.*)", r'\1\2', line, flags=re.ASCII))
        startPHP=False
      elif(not startPHP and not re.match(r"^(\s*)\?>(.*)", line) is None):
        destFile.write(re.sub(r"^(\s*)\?>(.*)", r'\1\2', line, flags=re.ASCII))
        startPHP=True
      else:
        destFile.write(line)
    
    destFile.write("\n\n\n" + createDataStructure("data", data) + "\n") #insert foramted data
    destFile.write("printTree(" + scriptName + "($data));") #run test and print result
  except IOError:
    exitCode=1
    sys.stderr.write("printTree.php can't open!");
  
#Generalization
elif scriptType == "sort":
  try:
    printItemsFile=open(scriptPath + "/../PHP/support/printItems.php", "r")
    #remove <?php and ?> from printItems and include into new file
    startPHP=True
    for line in printItemsFile:
      if(startPHP and not re.match(r"^(\s*)<\?php(.*)", line) is None):
        destFile.write(re.sub(r"^(\s*)<\?php(.*)", r'\1\2', line, flags=re.ASCII))
        startPHP=False
      elif(not startPHP and not re.match(r"^(\s*)\?>(.*)", line) is None):
        destFile.write(re.sub(r"^(\s*)\?>(.*)", r'\1\2', line, flags=re.ASCII))
        startPHP=True
      else:
        destFile.write(line)
    
    destFile.write("\n\n\n" + createDataStructure("data", data) + "\n") #insert foramted data
    destFile.write("printItems(" + scriptName + "($data));") #run test and print result
  except IOError:
    exitCode=1
    sys.stderr.write("printItems.py can't open!");
    
elif scriptType == "tree":
  try:
    destFile.write(createDataStructure("data", arrayToTree(data)) + "\n") #insert foramted data
    destFile.write("print(" + scriptName + "("+ opt.find +", $data));") #run test and print result
  except TypeError:
    exitCode=1
    sys.stderr.write("Find value isn't integer");
    
elif scriptType == "cryptography":
  #data[0] => string
  #data[1] => key
  if(str(data[1]).isdigit()): #check if key is string or integer
    key=str(data[1])
  else:
    key="\""+ str(data[1]) + "\""
  destFile.write("print("+ scriptName +"Decode("+ key +", "+ scriptName +"Encode("+ key +", \""+ data[0] +"\")));") #run test and print result

elif scriptType == "search":
  search = data.pop()
  data.sort()
  destFile.write("\n\n\n" + createDataStructure("data", data) + "\n") #insert foramted data  
  destFile.write("print(" + scriptName + "("+ str(search) +", $data));") #run test and print result
  
else:
  exitCode=1
  sys.stderr.write("Unknown script");

if opt.time:  
  destFile.write("\n$executionTime=microtime(true) - $executionTime;\n");
  destFile.write("$stderr=fopen('php://stderr','w');\n");
  destFile.write("fwrite($stderr, $executionTime);\n");
  destFile.write("fclose($stderr);\n");
destFile.write("\n?>")
destFile.close()
sys.exit(exitCode)
  


  