﻿# -*- coding: utf-8 -*-
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl


def createGraph(filename, *args, title=None, picSize=(11,4)):
  """
    Create graph and save it in filename. Format of image is PNG.
    filename - path to new file with graph
    args - dictionary contain name, color (optionaly), values (list).
    title - title of graph
    picSize - size of graph in inches
  """
  
  #list of predefined colors
  colors=["#FF8800", "#1CED77", "#F00C0C", "#D1DB00", "#1A9E00", "#1CCAED"]
  groupCount=0
  
  #check parameters
  if(len(args) == 0):
    raise TypeError("Missing 1 required positional argument!")
  if(type(picSize) is not tuple):
    raise TypeError("Expecting tuple for picSize parameter.")
  if(len(picSize) != 2):
    raise ValueError("picSize must have 2 items")
  if(type(filename) is not str):
    raise TypeError("Expecting string for filename")
    
  for arg in args:
    if(type(arg) is not dict):
      raise TypeError("Expecting in params dictionary")
    if("values" not in arg):
      raise ValueError("Dictionary with data must contain \"values\" item.")
    if("name" not in arg):
      raise ValueError("Dictionary with data must contain \"name\" item.")
    if(type(arg["name"]) is not str):
      raise TypeError("Expecting string for \"name\" item")
    if(type(arg["values"]) is not list):
      raise TypeError("Expecting list for \"values\" item")
    
    #prepare color
    if("color" in arg):
      if(type(arg["color"]) is not str):
        raise TypeError("Expecting string for \"color\" item")
    elif (len(colors)>0):
      arg["color"]=colors.pop()
    else:
      arg["color"]="#0066ff"
      
  #create new figure
  fig=plt.figure(figsize=picSize, dpi=100)
  
  mpl.rcParams['font.family'] = "Arial"
  
  if(title):
    fig.suptitle(title)
  #cycle over all data
  for i,data in zip(range(len(args)),args):
    #create bar
    if(len(data["values"]) == 1):
      plt.plot([0,0], [data["values"][0],data["values"][0]], color=data["color"], label=data["name"], linewidth=2)
      plt.plot([0,0], [data["values"][0],data["values"][0]], color=data["color"], label=None, marker='o')
    else:
      plt.plot(range(len(data["values"])), data["values"], color=data["color"], label=data["name"], linewidth=2)
    
  #remove ticks from Y axis
  #plt.yticks([])
  
  #set black border for graph
  ax=plt.gca()
  ax.spines['right'].set_color('black')
  ax.spines['left'].set_color('black')
  ax.spines['top'].set_color('black')
  ax.spines['bottom'].set_color('black')
  plt.ylabel("Použitá pamět [KB]")
  plt.xlabel("Doba běhu [s]")
  plt.grid(True, color="#7F7F7F")
  
  #replace number with description (if set)
  #if(xdesc is not None and len(xdesc) == groupCount):
  #  plt.xticks(X+groupWidth/2,xdesc, size=9)
  #else:
  #  plt.xticks(X+groupWidth/2, size=9)
  
  lgd=plt.legend(bbox_to_anchor=(0., 1.02, 1., .102), loc=3,
       ncol=2, mode="expand", borderaxespad=0., borderpad=1, fontsize=10)
  
  #set limit for X and Y axis
  #plt.ylim(0,maxVal*1.2)
  #plt.xlim(-groupSpace,(groupWidth+groupSpace)*groupCount)
  #save graph
  plt.savefig(filename, bbox_extra_artists=(lgd, ), bbox_inches='tight', format="svg")

#Example data  
#createGraph("a.svg",{"name":"PHP", "values":[3.5,3.4,3.3,1.2,3.5]},{"name":"Python2", "values":[3.6,4.4,2.3,3.2,1.1]},{"name":"Pytho3", "values":[3.8,2.4,3.9,4.4,2.5]},{"name":"Lua", "values":[3.1,2.34,3.32,4.21,3.1]}, title="Graph")
