#ifndef CALIB_CHECKER_DETECTOR_H
#define CALIB_CHECKER_DETECTOR_H

#include "Helper\Cvh.h"
#include <Vector2D.h>
namespace CALIB {
#if 0
}
#endif // emacs indention fix ;-)

/**
 * Detects a projected checker board using a camera.
 */
class CheckerDetector
{
	protected:
		/** Number of rows to be detected. */
		int rows;
		/** Number of columns to be detected. */
		int columns;
		std::vector<geometry::Vector2Df> points;
		CvPoint2D32f* cvCorners;		
	public:
		/**
		 *   Constructor.
		 */
		CheckerDetector();
		std::vector<geometry::Vector2Df> * GetPoints()	{	return &this->points;	}
				
		/**
		 *   Sets the camera and adds a grayscale filter to
		 *   the filter chain.
		 * @param camera The camera to be used to detect the
		 * checker board.
		 * @return Returns true.
		 */
		 //bool SetCamera(Camera* camera);
		/**
		 *   Parses the incoming string vector that contains
		 *   2 or 3 entries. Rows and columns will be set.
		 * @param parameter The parameter string vector.
		 * @return Returns true if rows and columns were set
		 * to a value > 0 respectivly.
		 */
		bool Init(std::vector<std::string> parameter);
		bool Init(int rows,int cols,int border);
		void InitPoints(int rows,int cols);
		/**
		 *   Calls the OpenCV FindChessBoardCorner and, if
		 *   successful, the FindCornerSubPix methods. Tries
		 *   different thresholds to find the checker board.
		 * @return Returns true if all points were found and
		 * saved, otherwise false. The chessboard detector can
		 * only find all or none features.
		 */
		//bool Detect();
		bool Detect(IplImage * cvImage, int rows = -1,int cols = -1);
		bool DrawCorners(IplImage* cvImage, int rows = -1,int cols = -1);
		bool DetectCircles(IplImage* cvImage);
  		void Print();
  		int GetRows() { return this->rows; };
  		int GetColumns() { return this->columns; };
};

} // namespace DKT

#endif

