#ifndef CALIB_COMMON_H
#define CALIB_COMMON_H

#include <string>
#include <iostream>
#include <fstream>
#include <windows.h>
#include <gdiplus.h>
#include <dirent.h>
#include "Helper\Cvh.h"

using namespace Gdiplus;
using namespace Gdiplus::DllExports;
using namespace std;

#define CHAR_LENGHT 256
namespace CALIB
{
	enum ProjectorIndex 
	{
		UPPER_LEFT = 0,
		UPPER_RIGHT = 1,
		BOTTOM_LEFT = 2,
		BOTTOM_RIGHT = 3,
		FULLSCREEN,
		MULTI 
	};

	class Common{
		
		public: 
			/**
			 * Converts input integer number into string.
			 * @param i Input integer number.
			 * @return Input number as string.
			 */
			/*static std::string intToString(int i);*/
			static int doubleNum(int num,bool up);
			static void countCoordinates(int index,int srcX,int srcY,int * dstX,int *dstY,bool inverseY);
			static float convertUnsignedCharToFloat(unsigned char value);
//			static void TakeScreenShot(char* filename);
			static int GetEncoderClsid(WCHAR *format, CLSID *pClsid);
			static IplImage * GetScreeny(LPWSTR lpszFilename, ULONG uQuality);
			static vector<string> GetDir (string dir, vector<string> files);
		private: 						
			Common(); 
			~Common(); 			
	}; 	
}; 

#endif
