#ifndef CALIB_RENDERING_UNIT_H
#define CALIB_RENDERING_UNIT_H

#include "Calibration\Projector.h"
#include "Helper\GL.h"

using namespace std;
using namespace CALIB;
using namespace PROJ;

namespace CALIB
{	
	class RenderingUnit
	{
		public:
			RenderingUnit(int projectorsCount,int projectorsInRow,int projectorWidth,int projectorHeight,int cameraImageWidth,int cameraImageHeight);
			~RenderingUnit();

			void DrawTextureOnMesh(Projector * p,GLuint textureId);
			void DrawTextureOnMesh(int meshRows,int meshCols,GLuint textureId,std::vector<geometry::Vector2Df> * meshPoints,std::vector<geometry::Vector2Df> * texturePoints);

		protected:
			int cameraImageWidth;
			int cameraImageHeight;
			int projectorImageWidth;
			int projectorImageHeight;
			int dispalyImageWidth;
			int displayImageHeight;
			int count;
			int cols;
			int rows;
	};
}; 

#endif
		
