//#include "resource.h"
#include <iostream>

#include "CameraController.h"
#include "CameraModel.h"
#include "EDSDK.h"
#include "EDSDKTypes.h"
#include "CameraModelLegacy.h"
#include "CameraEventListener.h"

class CameraControl
{
	protected:
		bool isSDKLoaded;

	public:
		CameraControl();
		~CameraControl();
		
		void takePicture();
		char* getImageName();
		//bool openSession();
		
		CameraModel*		_model;
		CameraController*	_controller;

	protected:
		EdsError Init();
		bool openSession();
		bool closeSession();
		void releaseSources();
		CameraModel* cameraModelFactory(EdsCameraRef camera, EdsDeviceInfo deviceInfo);

	private:
		void fireEvent(std::string command, void* arg = 0);				
};