# Modules.tcl: Local include Modules tcl script
# Copyright (c) 2012 Brno University of Technology 
# Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id: Modules.tcl 822 2011-11-03 20:20:20Z xkekel00 $
#

# Set paths
set COMP_BASE           "$ENTITY_BASE/../comp"
set BMEM_BASE           "$COMP_BASE/base/mem/dp_bmem"
set FIFO_BASE           "$COMP_BASE/base/fifo/fifo"

set PACKAGES       "$PACKAGES $COMP_BASE/base/pkg/math_pack.vhd"
set PACKAGES       "$PACKAGES $ENTITY_BASE/comp/prefix_search_tree/tree_func.vhd"
set PACKAGES       "$PACKAGES $ENTITY_BASE/filter_core_config.vhd"

set MOD "$MOD $ENTITY_BASE/comp/key_filter.vhd"
set MOD "$MOD $ENTITY_BASE/comp/key_unfilter.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_24.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_32.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_48.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_56.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_64.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_104.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_128.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_152.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16_296.vhd"
set MOD "$MOD $ENTITY_BASE/comp/crc/crc16.vhd"
set MOD "$MOD $ENTITY_BASE/comp/cuckoo_hash/init_box.vhd"
set MOD "$MOD $ENTITY_BASE/comp/cuckoo_hash/reg_cmp.vhd"
set MOD "$MOD $ENTITY_BASE/comp/cuckoo_hash/cuckoo_hash.vhd"
set MOD "$MOD $ENTITY_BASE/filter_core_ent.vhd"
set MOD "$MOD $ENTITY_BASE/filter_core.vhd"

set COMPONENTS [list \
                   [ list "BMEM"             $BMEM_BASE                             "FULL" ]\
                   [ list "FIFO"             $FIFO_BASE                             "FULL" ]\
                   [ list "SEARCH_TREE"      "$ENTITY_BASE/comp/prefix_search_tree" "FULL" ] \
               ] 
