-- crc16_24.vhd: A 16-bit CRC table for processing 48 bits in parallel
-- Copyright (C) 2013 Brno University of Technology
-- Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: crc16_48.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity crc16_48 is
   port(
      DI    : in  std_logic_vector(48-1 downto 0);
      DO    : out std_logic_vector(15 downto 0)
   );
end entity;

-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ansi of crc16_48 is
begin
-- 16-bit CRC equations processing 48 bits in parallel (VHDL code)
-- Generator polynomial: 0x18005
   DO(0) <= DI(5) XOR DI(3) XOR DI(18) XOR DI(33) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(14) XOR DI(29) XOR DI(13) XOR DI(28) XOR DI(12) XOR DI(27) XOR DI(11) XOR DI(26) XOR DI(10) XOR DI(25) XOR DI(9) XOR DI(24) XOR DI(8) XOR DI(23) XOR DI(7) XOR DI(22) XOR DI(21) XOR DI(35) XOR DI(36) XOR DI(37) XOR DI(38) XOR DI(39) XOR DI(40) XOR DI(41) XOR DI(42) XOR DI(43) XOR DI(44) XOR DI(45) XOR DI(46) XOR DI(47);
   DO(1) <= DI(7) XOR DI(6) XOR DI(21) XOR DI(5) XOR DI(4) XOR DI(19) XOR DI(34) XOR DI(35);
   DO(2) <= DI(8) XOR DI(7) XOR DI(22) XOR DI(6) XOR DI(5) XOR DI(20) XOR DI(35) XOR DI(36);
   DO(3) <= DI(9) XOR DI(8) XOR DI(23) XOR DI(7) XOR DI(6) XOR DI(21) XOR DI(36) XOR DI(37);
   DO(4) <= DI(10) XOR DI(9) XOR DI(24) XOR DI(8) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(38);
   DO(5) <= DI(11) XOR DI(10) XOR DI(25) XOR DI(9) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(39);
   DO(6) <= DI(12) XOR DI(11) XOR DI(26) XOR DI(10) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(40);
   DO(7) <= DI(13) XOR DI(12) XOR DI(27) XOR DI(11) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(41);
   DO(8) <= DI(0) XOR DI(14) XOR DI(13) XOR DI(28) XOR DI(12) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(42);
   DO(9) <= DI(1) XOR DI(15) XOR DI(14) XOR DI(29) XOR DI(13) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(43);
   DO(10) <= DI(2) XOR DI(16) XOR DI(15) XOR DI(30) XOR DI(14) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(44);
   DO(11) <= DI(3) XOR DI(17) XOR DI(16) XOR DI(31) XOR DI(15) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(45);
   DO(12) <= DI(4) XOR DI(18) XOR DI(17) XOR DI(32) XOR DI(16) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(46);
   DO(13) <= DI(5) XOR DI(19) XOR DI(18) XOR DI(33) XOR DI(17) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(47);
   DO(14) <= DI(3) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(14) XOR DI(29) XOR DI(13) XOR DI(28) XOR DI(12) XOR DI(27) XOR DI(11) XOR DI(26) XOR DI(10) XOR DI(25) XOR DI(9) XOR DI(24) XOR DI(8) XOR DI(23) XOR DI(7) XOR DI(22) XOR DI(6) XOR DI(21) XOR DI(5) XOR DI(20) XOR DI(19) XOR DI(33) XOR DI(34) XOR DI(35) XOR DI(36) XOR DI(37) XOR DI(38) XOR DI(39) XOR DI(40) XOR DI(41) XOR DI(42) XOR DI(43) XOR DI(44) XOR DI(45) XOR DI(46);
   DO(15) <= DI(4) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(14) XOR DI(29) XOR DI(13) XOR DI(28) XOR DI(12) XOR DI(27) XOR DI(11) XOR DI(26) XOR DI(10) XOR DI(25) XOR DI(9) XOR DI(24) XOR DI(8) XOR DI(23) XOR DI(7) XOR DI(22) XOR DI(6) XOR DI(21) XOR DI(20) XOR DI(34) XOR DI(35) XOR DI(36) XOR DI(37) XOR DI(38) XOR DI(39) XOR DI(40) XOR DI(41) XOR DI(42) XOR DI(43) XOR DI(44) XOR DI(45) XOR DI(46) XOR DI(47);
end architecture;




-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ccitt of crc16_48 is
begin
-- 16-bit CRC equations processing 48 bits in parallel (VHDL code)
-- Generator polynomial: 0x11021
   DO(0) <= DI(13) XOR DI(21) XOR DI(0) XOR DI(6) XOR DI(20) XOR DI(28) XOR DI(15) XOR DI(26) XOR DI(29) XOR DI(37) XOR DI(16) XOR DI(22) XOR DI(36) XOR DI(40) XOR DI(44);
   DO(1) <= DI(0) XOR DI(14) XOR DI(22) XOR DI(1) XOR DI(7) XOR DI(21) XOR DI(29) XOR DI(16) XOR DI(27) XOR DI(30) XOR DI(38) XOR DI(17) XOR DI(23) XOR DI(37) XOR DI(41) XOR DI(45);
   DO(2) <= DI(1) XOR DI(15) XOR DI(23) XOR DI(2) XOR DI(8) XOR DI(22) XOR DI(30) XOR DI(17) XOR DI(28) XOR DI(31) XOR DI(39) XOR DI(18) XOR DI(24) XOR DI(38) XOR DI(42) XOR DI(46);
   DO(3) <= DI(0) XOR DI(2) XOR DI(16) XOR DI(24) XOR DI(3) XOR DI(9) XOR DI(23) XOR DI(31) XOR DI(18) XOR DI(29) XOR DI(32) XOR DI(40) XOR DI(19) XOR DI(25) XOR DI(39) XOR DI(43) XOR DI(47);
   DO(4) <= DI(1) XOR DI(16) XOR DI(3) XOR DI(17) XOR DI(25) XOR DI(4) XOR DI(10) XOR DI(24) XOR DI(28) XOR DI(32) XOR DI(36) XOR DI(6) XOR DI(13) XOR DI(21) XOR DI(19) XOR DI(22) XOR DI(30) XOR DI(15) XOR DI(29) XOR DI(33) XOR DI(37) XOR DI(41);
   DO(5) <= DI(2) XOR DI(17) XOR DI(4) XOR DI(18) XOR DI(26) XOR DI(5) XOR DI(11) XOR DI(25) XOR DI(29) XOR DI(33) XOR DI(37) XOR DI(7) XOR DI(0) XOR DI(14) XOR DI(22) XOR DI(20) XOR DI(23) XOR DI(31) XOR DI(16) XOR DI(30) XOR DI(34) XOR DI(38) XOR DI(42);
   DO(6) <= DI(3) XOR DI(18) XOR DI(5) XOR DI(19) XOR DI(27) XOR DI(6) XOR DI(12) XOR DI(26) XOR DI(30) XOR DI(34) XOR DI(38) XOR DI(8) XOR DI(1) XOR DI(15) XOR DI(23) XOR DI(21) XOR DI(24) XOR DI(32) XOR DI(17) XOR DI(31) XOR DI(35) XOR DI(39) XOR DI(43);
   DO(7) <= DI(4) XOR DI(19) XOR DI(6) XOR DI(20) XOR DI(28) XOR DI(7) XOR DI(13) XOR DI(27) XOR DI(31) XOR DI(35) XOR DI(39) XOR DI(9) XOR DI(2) XOR DI(16) XOR DI(24) XOR DI(22) XOR DI(25) XOR DI(33) XOR DI(18) XOR DI(32) XOR DI(36) XOR DI(40) XOR DI(44);
   DO(8) <= DI(5) XOR DI(20) XOR DI(7) XOR DI(21) XOR DI(29) XOR DI(8) XOR DI(14) XOR DI(28) XOR DI(32) XOR DI(36) XOR DI(40) XOR DI(10) XOR DI(3) XOR DI(17) XOR DI(25) XOR DI(23) XOR DI(26) XOR DI(34) XOR DI(19) XOR DI(33) XOR DI(37) XOR DI(41) XOR DI(45);
   DO(9) <= DI(6) XOR DI(21) XOR DI(8) XOR DI(22) XOR DI(30) XOR DI(9) XOR DI(15) XOR DI(29) XOR DI(33) XOR DI(37) XOR DI(41) XOR DI(11) XOR DI(4) XOR DI(18) XOR DI(26) XOR DI(24) XOR DI(27) XOR DI(35) XOR DI(20) XOR DI(34) XOR DI(38) XOR DI(42) XOR DI(46);
   DO(10) <= DI(7) XOR DI(0) XOR DI(22) XOR DI(9) XOR DI(23) XOR DI(31) XOR DI(10) XOR DI(16) XOR DI(30) XOR DI(34) XOR DI(38) XOR DI(42) XOR DI(12) XOR DI(5) XOR DI(19) XOR DI(27) XOR DI(25) XOR DI(28) XOR DI(36) XOR DI(21) XOR DI(35) XOR DI(39) XOR DI(43) XOR DI(47);
   DO(11) <= DI(8) XOR DI(16) XOR DI(1) XOR DI(15) XOR DI(23) XOR DI(10) XOR DI(21) XOR DI(24) XOR DI(32) XOR DI(11) XOR DI(17) XOR DI(31) XOR DI(35) XOR DI(39) XOR DI(43);
   DO(12) <= DI(9) XOR DI(17) XOR DI(2) XOR DI(16) XOR DI(24) XOR DI(11) XOR DI(22) XOR DI(25) XOR DI(33) XOR DI(12) XOR DI(18) XOR DI(32) XOR DI(36) XOR DI(40) XOR DI(44);
   DO(13) <= DI(10) XOR DI(18) XOR DI(3) XOR DI(17) XOR DI(25) XOR DI(12) XOR DI(23) XOR DI(26) XOR DI(34) XOR DI(13) XOR DI(19) XOR DI(33) XOR DI(37) XOR DI(41) XOR DI(45);
   DO(14) <= DI(11) XOR DI(19) XOR DI(4) XOR DI(18) XOR DI(26) XOR DI(13) XOR DI(24) XOR DI(27) XOR DI(35) XOR DI(14) XOR DI(20) XOR DI(34) XOR DI(38) XOR DI(42) XOR DI(46);
   DO(15) <= DI(12) XOR DI(20) XOR DI(5) XOR DI(19) XOR DI(27) XOR DI(14) XOR DI(25) XOR DI(28) XOR DI(36) XOR DI(15) XOR DI(21) XOR DI(35) XOR DI(39) XOR DI(43) XOR DI(47);
end architecture;