-- crc16_64.vhd: A 16-bit CRC table for processing 64 bits in parallel
-- Copyright (C) 2012 Brno University of Technology
-- Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: crc16_64.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity crc16_64 is
   port(
      DI    : in  std_logic_vector(64-1 downto 0);
      DO    : out std_logic_vector(15 downto 0)
   );
end entity;

-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ansi of crc16_64 is
begin
-- 16-bit CRC equations processing 64 bits in parallel (VHDL code)
-- Generator polynomial: 0x18005
   DO(0) <= DI(21) XOR DI(4) XOR DI(19) XOR DI(34) XOR DI(49) XOR DI(3) XOR DI(18) XOR DI(33) XOR DI(48) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(47) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(23) XOR DI(38) XOR DI(37) XOR DI(51) XOR DI(52) XOR DI(53) XOR DI(54) XOR DI(55) XOR DI(56) XOR DI(57) XOR DI(58) XOR DI(59) XOR DI(60) XOR DI(61) XOR DI(62) XOR DI(63);
   DO(1) <= DI(9) XOR DI(23) XOR DI(22) XOR DI(37) XOR DI(21) XOR DI(5) XOR DI(20) XOR DI(35) XOR DI(50) XOR DI(51);
   DO(2) <= DI(10) XOR DI(24) XOR DI(23) XOR DI(38) XOR DI(22) XOR DI(6) XOR DI(21) XOR DI(36) XOR DI(51) XOR DI(52);
   DO(3) <= DI(11) XOR DI(25) XOR DI(24) XOR DI(39) XOR DI(23) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(52) XOR DI(53);
   DO(4) <= DI(12) XOR DI(26) XOR DI(25) XOR DI(40) XOR DI(24) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(53) XOR DI(54);
   DO(5) <= DI(13) XOR DI(27) XOR DI(26) XOR DI(41) XOR DI(25) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(54) XOR DI(55);
   DO(6) <= DI(0) XOR DI(14) XOR DI(28) XOR DI(27) XOR DI(42) XOR DI(26) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(55) XOR DI(56);
   DO(7) <= DI(1) XOR DI(0) XOR DI(15) XOR DI(29) XOR DI(28) XOR DI(43) XOR DI(27) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(57);
   DO(8) <= DI(2) XOR DI(1) XOR DI(16) XOR DI(30) XOR DI(29) XOR DI(44) XOR DI(28) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(58);
   DO(9) <= DI(3) XOR DI(2) XOR DI(17) XOR DI(31) XOR DI(30) XOR DI(45) XOR DI(29) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(58) XOR DI(59);
   DO(10) <= DI(4) XOR DI(3) XOR DI(18) XOR DI(32) XOR DI(31) XOR DI(46) XOR DI(0) XOR DI(30) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(59) XOR DI(60);
   DO(11) <= DI(5) XOR DI(4) XOR DI(19) XOR DI(33) XOR DI(32) XOR DI(47) XOR DI(1) XOR DI(31) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(60) XOR DI(61);
   DO(12) <= DI(6) XOR DI(5) XOR DI(20) XOR DI(34) XOR DI(33) XOR DI(48) XOR DI(2) XOR DI(32) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(61) XOR DI(62);
   DO(13) <= DI(7) XOR DI(6) XOR DI(21) XOR DI(35) XOR DI(34) XOR DI(49) XOR DI(3) XOR DI(33) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(47) XOR DI(62) XOR DI(63);
   DO(14) <= DI(19) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(47) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(21) XOR DI(36) XOR DI(35) XOR DI(49) XOR DI(50) XOR DI(51) XOR DI(52) XOR DI(53) XOR DI(54) XOR DI(55) XOR DI(56) XOR DI(57) XOR DI(58) XOR DI(59) XOR DI(60) XOR DI(61) XOR DI(62);
   DO(15) <= DI(20) XOR DI(3) XOR DI(18) XOR DI(33) XOR DI(48) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(47) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(22) XOR DI(37) XOR DI(36) XOR DI(50) XOR DI(51) XOR DI(52) XOR DI(53) XOR DI(54) XOR DI(55) XOR DI(56) XOR DI(57) XOR DI(58) XOR DI(59) XOR DI(60) XOR DI(61) XOR DI(62) XOR DI(63);

end architecture;




-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ccitt of crc16_64 is
begin
-- 16-bit CRC equations processing 64 bits in parallel (VHDL code)
-- Generator polynomial: 0x11021
   DO(0) <= DI(13) XOR DI(0) XOR DI(6) XOR DI(15) XOR DI(29) XOR DI(37) XOR DI(16) XOR DI(22) XOR DI(36) XOR DI(44) XOR DI(31) XOR DI(42) XOR DI(1) XOR DI(45) XOR DI(53) XOR DI(9) XOR DI(12) XOR DI(32) XOR DI(38) XOR DI(8) XOR DI(52) XOR DI(56) XOR DI(60);
   DO(1) <= DI(0) XOR DI(14) XOR DI(1) XOR DI(7) XOR DI(16) XOR DI(30) XOR DI(38) XOR DI(17) XOR DI(23) XOR DI(37) XOR DI(45) XOR DI(32) XOR DI(43) XOR DI(2) XOR DI(46) XOR DI(54) XOR DI(10) XOR DI(13) XOR DI(33) XOR DI(39) XOR DI(9) XOR DI(53) XOR DI(57) XOR DI(61);
   DO(2) <= DI(1) XOR DI(15) XOR DI(2) XOR DI(8) XOR DI(17) XOR DI(31) XOR DI(39) XOR DI(18) XOR DI(24) XOR DI(38) XOR DI(46) XOR DI(33) XOR DI(44) XOR DI(0) XOR DI(3) XOR DI(47) XOR DI(55) XOR DI(11) XOR DI(14) XOR DI(34) XOR DI(40) XOR DI(10) XOR DI(54) XOR DI(58) XOR DI(62);
   DO(3) <= DI(2) XOR DI(16) XOR DI(3) XOR DI(9) XOR DI(18) XOR DI(32) XOR DI(40) XOR DI(19) XOR DI(25) XOR DI(39) XOR DI(47) XOR DI(34) XOR DI(45) XOR DI(1) XOR DI(4) XOR DI(48) XOR DI(56) XOR DI(12) XOR DI(15) XOR DI(35) XOR DI(41) XOR DI(0) XOR DI(11) XOR DI(55) XOR DI(59) XOR DI(63);
   DO(4) <= DI(3) XOR DI(17) XOR DI(4) XOR DI(10) XOR DI(32) XOR DI(19) XOR DI(33) XOR DI(41) XOR DI(0) XOR DI(20) XOR DI(26) XOR DI(40) XOR DI(44) XOR DI(48) XOR DI(52) XOR DI(6) XOR DI(8) XOR DI(22) XOR DI(9) XOR DI(15) XOR DI(29) XOR DI(37) XOR DI(35) XOR DI(38) XOR DI(46) XOR DI(2) XOR DI(5) XOR DI(31) XOR DI(45) XOR DI(49) XOR DI(53) XOR DI(57);
   DO(5) <= DI(4) XOR DI(18) XOR DI(5) XOR DI(11) XOR DI(33) XOR DI(20) XOR DI(34) XOR DI(42) XOR DI(1) XOR DI(21) XOR DI(27) XOR DI(41) XOR DI(45) XOR DI(49) XOR DI(53) XOR DI(7) XOR DI(0) XOR DI(9) XOR DI(23) XOR DI(10) XOR DI(16) XOR DI(30) XOR DI(38) XOR DI(36) XOR DI(39) XOR DI(47) XOR DI(3) XOR DI(6) XOR DI(32) XOR DI(46) XOR DI(50) XOR DI(54) XOR DI(58);
   DO(6) <= DI(5) XOR DI(19) XOR DI(6) XOR DI(12) XOR DI(34) XOR DI(21) XOR DI(35) XOR DI(43) XOR DI(2) XOR DI(22) XOR DI(28) XOR DI(42) XOR DI(46) XOR DI(50) XOR DI(54) XOR DI(8) XOR DI(1) XOR DI(10) XOR DI(24) XOR DI(11) XOR DI(17) XOR DI(31) XOR DI(39) XOR DI(37) XOR DI(40) XOR DI(48) XOR DI(4) XOR DI(7) XOR DI(33) XOR DI(47) XOR DI(51) XOR DI(55) XOR DI(59);
   DO(7) <= DI(6) XOR DI(20) XOR DI(7) XOR DI(13) XOR DI(35) XOR DI(22) XOR DI(36) XOR DI(44) XOR DI(0) XOR DI(3) XOR DI(23) XOR DI(29) XOR DI(43) XOR DI(47) XOR DI(51) XOR DI(55) XOR DI(9) XOR DI(2) XOR DI(11) XOR DI(25) XOR DI(12) XOR DI(18) XOR DI(32) XOR DI(40) XOR DI(38) XOR DI(41) XOR DI(49) XOR DI(5) XOR DI(8) XOR DI(34) XOR DI(48) XOR DI(52) XOR DI(56) XOR DI(60);
   DO(8) <= DI(7) XOR DI(21) XOR DI(8) XOR DI(14) XOR DI(36) XOR DI(23) XOR DI(37) XOR DI(45) XOR DI(1) XOR DI(4) XOR DI(24) XOR DI(30) XOR DI(0) XOR DI(44) XOR DI(48) XOR DI(52) XOR DI(56) XOR DI(10) XOR DI(3) XOR DI(12) XOR DI(26) XOR DI(13) XOR DI(19) XOR DI(33) XOR DI(41) XOR DI(39) XOR DI(42) XOR DI(50) XOR DI(6) XOR DI(9) XOR DI(35) XOR DI(49) XOR DI(53) XOR DI(57) XOR DI(61);
   DO(9) <= DI(8) XOR DI(22) XOR DI(9) XOR DI(15) XOR DI(37) XOR DI(24) XOR DI(38) XOR DI(46) XOR DI(2) XOR DI(5) XOR DI(25) XOR DI(31) XOR DI(1) XOR DI(45) XOR DI(49) XOR DI(53) XOR DI(57) XOR DI(11) XOR DI(4) XOR DI(13) XOR DI(27) XOR DI(14) XOR DI(20) XOR DI(34) XOR DI(42) XOR DI(40) XOR DI(43) XOR DI(51) XOR DI(7) XOR DI(10) XOR DI(36) XOR DI(50) XOR DI(54) XOR DI(58) XOR DI(62);
   DO(10) <= DI(9) XOR DI(23) XOR DI(10) XOR DI(16) XOR DI(38) XOR DI(25) XOR DI(39) XOR DI(47) XOR DI(3) XOR DI(6) XOR DI(26) XOR DI(32) XOR DI(2) XOR DI(46) XOR DI(50) XOR DI(54) XOR DI(58) XOR DI(12) XOR DI(5) XOR DI(14) XOR DI(28) XOR DI(15) XOR DI(21) XOR DI(35) XOR DI(43) XOR DI(41) XOR DI(44) XOR DI(52) XOR DI(8) XOR DI(11) XOR DI(37) XOR DI(51) XOR DI(55) XOR DI(59) XOR DI(63);
   DO(11) <= DI(8) XOR DI(1) XOR DI(10) XOR DI(24) XOR DI(32) XOR DI(11) XOR DI(17) XOR DI(31) XOR DI(39) XOR DI(26) XOR DI(37) XOR DI(40) XOR DI(48) XOR DI(4) XOR DI(7) XOR DI(27) XOR DI(33) XOR DI(3) XOR DI(47) XOR DI(51) XOR DI(55) XOR DI(59);
   DO(12) <= DI(9) XOR DI(2) XOR DI(11) XOR DI(25) XOR DI(33) XOR DI(12) XOR DI(18) XOR DI(32) XOR DI(40) XOR DI(27) XOR DI(38) XOR DI(41) XOR DI(49) XOR DI(5) XOR DI(8) XOR DI(28) XOR DI(34) XOR DI(4) XOR DI(48) XOR DI(52) XOR DI(56) XOR DI(60);
   DO(13) <= DI(10) XOR DI(3) XOR DI(12) XOR DI(26) XOR DI(34) XOR DI(13) XOR DI(19) XOR DI(33) XOR DI(41) XOR DI(28) XOR DI(39) XOR DI(42) XOR DI(50) XOR DI(6) XOR DI(9) XOR DI(29) XOR DI(35) XOR DI(5) XOR DI(49) XOR DI(53) XOR DI(57) XOR DI(61);
   DO(14) <= DI(11) XOR DI(4) XOR DI(13) XOR DI(27) XOR DI(35) XOR DI(14) XOR DI(20) XOR DI(34) XOR DI(42) XOR DI(29) XOR DI(40) XOR DI(43) XOR DI(51) XOR DI(7) XOR DI(10) XOR DI(30) XOR DI(36) XOR DI(6) XOR DI(50) XOR DI(54) XOR DI(58) XOR DI(62);
   DO(15) <= DI(12) XOR DI(5) XOR DI(14) XOR DI(28) XOR DI(36) XOR DI(15) XOR DI(21) XOR DI(35) XOR DI(43) XOR DI(30) XOR DI(41) XOR DI(0) XOR DI(44) XOR DI(52) XOR DI(8) XOR DI(11) XOR DI(31) XOR DI(37) XOR DI(7) XOR DI(51) XOR DI(55) XOR DI(59) XOR DI(63);

end architecture;