# Modules.tcl: Local include Modules tcl script
# Copyright (c) 2013 Brno University of Technology 
# Author(s): Lukas Kekely <ikekely@fit.vutbr.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id: Modules.tcl 822 2011-11-03 20:20:20Z xkekel00 $
#

# Set paths
set COMP_BASE           "$ENTITY_BASE/../../../comp"
set BMEM_BASE           "$COMP_BASE/base/mem/dp_bmem"
set DISTMEM_BASE        "$COMP_BASE/base/mem/dp_distmem"
set QP_DISTMEM_BASE     "$COMP_BASE/base/mem/qp_distmem"

set PACKAGES       "$PACKAGES $COMP_BASE/base/pkg/math_pack.vhd"
set PACKAGES       "$PACKAGES $ENTITY_BASE/tree_func.vhd"

set MOD "$MOD $ENTITY_BASE/tree_stage_ent.vhd"
set MOD "$MOD $ENTITY_BASE/tree_stage.vhd"
set MOD "$MOD $ENTITY_BASE/tree_final_stage_ent.vhd"
set MOD "$MOD $ENTITY_BASE/tree_final_stage.vhd"
set MOD "$MOD $ENTITY_BASE/tree_final_stage_fixed_ent.vhd"
set MOD "$MOD $ENTITY_BASE/tree_final_stage_fixed.vhd"
set MOD "$MOD $ENTITY_BASE/tree_3stages_distmem_ent.vhd"
set MOD "$MOD $ENTITY_BASE/tree_3stages_distmem.vhd"
set MOD "$MOD $ENTITY_BASE/tree_config_memory_adc_ent.vhd"
set MOD "$MOD $ENTITY_BASE/tree_config_memory_adc.vhd"
set MOD "$MOD $ENTITY_BASE/tree_config_ent.vhd"
set MOD "$MOD $ENTITY_BASE/tree_config.vhd"
set MOD "$MOD $ENTITY_BASE/tree_ent.vhd"
set MOD "$MOD $ENTITY_BASE/tree.vhd"

set COMPONENTS [list \
                   [ list "BMEM"             $BMEM_BASE         "FULL" ]\
                   [ list "DISTMEM"          $DISTMEM_BASE      "FULL" ]\
                   [ list "QP_DISTMEM"       $QP_DISTMEM_BASE   "FULL" ]\
               ] 
