/*
 * cfg_module.sv: Tested design configuration module
 * Copyright (C) 2013 Brno University of Technology
 * Author: Lukas Kekely <ikekely@fit.vutbr.cz> 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 */
 
class ConfigModule #(int pKeyWidth=128, int pLengthWidth=7, int pDataWidth=32);
  
  string    inst;                    // Module identification
  virtual   ConfigInterface.tb #(pKeyWidth, pLengthWidth, pDataWidth) ifc;  // Configuration interface

  function new ( string inst, virtual ConfigInterface.tb #(pKeyWidth, pLengthWidth, pDataWidth) ifc );      
    this.inst       = inst;         // Store driver identifier
    this.ifc        = ifc;          // Store pointer interface 
    this.ifc.cb.add_vld <= 0;
    this.ifc.cb.rem_vld <= 0;
    this.ifc.cb.clr_vld <= 0;
  endfunction: new          

  task removeRule(FilterRuleTransaction tr);
    waitWhileBusy();
    for (int i=0,j=tr.key.size-1; i < pKeyWidth; i+=8,j--)
      ifc.cb.key[i +: 8] <= tr.key[j];
    ifc.cb.keylen  <= tr.keylen;  
    ifc.cb.rem_vld <= 1;
    @(ifc.cb);      
    ifc.cb.rem_vld <= 0;
    @(ifc.cb);
  endtask : removeRule
  
  task addRule(FilterRuleTransaction tr);
    waitWhileBusy();
    for (int i=0,j=tr.key.size-1; i < pKeyWidth; i+=8,j--)
      ifc.cb.key[i +: 8] <= tr.key[j];
    ifc.cb.keylen  <= tr.keylen; 
    for (int i=0,j=0; i < pDataWidth; i+=8,j++)
      ifc.cb.data[i +: 8] <= tr.data[j];  
    ifc.cb.add_vld <= 1;
    @(ifc.cb);      
    ifc.cb.add_vld <= 0;
    @(ifc.cb);        
  endtask : addRule
  
  task clearRules();
    waitWhileBusy();
    ifc.cb.clr_vld <= 1;
    @(ifc.cb);      
    ifc.cb.clr_vld <= 0;
    @(ifc.cb);        
  endtask : clearRules
   
  task waitWhileBusy();
    while (ifc.cb.busy) 
      @(ifc.cb);
  endtask : waitWhileBusy
  
  function bit checkFull();
    checkFull = ifc.cb.full; 
  endfunction : checkFull  
    
endclass : ConfigModule

