/*
 * dir_module.sv: Tested design dirrect memory access module
 * Copyright (C) 2013 Brno University of Technology
 * Author: Lukas Kekely <ikekely@fit.vutbr.cz> 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 */
 
class DirrectModule #(int pTreeStages=10, int pKeyWidth=128, int pLengthWidth=7, int pDataWidth=32);
  
  string    inst;                     // Module identification
  virtual   DirrectInterface.tb #(pTreeStages, pKeyWidth, pLengthWidth, pDataWidth) ifc;  // Configuration interface

  function new ( string inst, virtual DirrectInterface.tb #(pTreeStages, pKeyWidth, pLengthWidth, pDataWidth) ifc );      
    this.inst       = inst;         // Store driver identifier
    this.ifc        = ifc;          // Store pointer interface 
    this.ifc.cb.rd  <= 0;
  endfunction: new          

  task readRule(input int unsigned addr, output FilterRuleTransaction tr, output bit valid, output bit isend);
    ifc.cb.addr <= addr;
    ifc.cb.rd   <= 1;
    @(ifc.cb);      
    ifc.cb.rd   <= 0;
    waitForDrdy();
    tr = new;
    tr.key = new[pKeyWidth/8];
    for (int i=0,j=tr.key.size-1; i < pKeyWidth; i+=8,j--)
      tr.key[j] = ifc.cb.key[i +: 8];
    tr.keylen = ifc.cb.keylen;
    tr.data = new[pDataWidth/8];
    tr.data = {<< byte{ifc.cb.data}};
    valid = ifc.cb.keyvld;
    isend = ifc.cb.isend; 
    @(ifc.cb);  
  endtask : readRule
  
  task readRules(output string sa[]);
    int size=1<<pTreeStages;
    FilterRuleTransaction tr;
    bit valid, isend;
    string tmp;
    sa={};
    for(int i=1; i<size; i++) begin
      readRule(i,tr,valid,isend);
      if(!valid)
        break;
      if(isend)
        tmp="END: ";
      else
        tmp="BEG: ";
      for (integer j=0; j < tr.key.size; j++)
        $swrite(tmp, "%s%x ", tmp, tr.key[j]);  
      $swrite(tmp, "%s/ %0d  => ", tmp, tr.keylen+1);
      for (integer j=0; j < tr.data.size; j++)
        $swrite(tmp, "%s %x", tmp, tr.data[j]);
      sa=new[i](sa);
      sa[i-1]=tmp;
    end
  endtask
   
  task waitForDrdy();
    while (!ifc.cb.drdy) 
      @(ifc.cb);
  endtask : waitForDrdy 
    
endclass : DirrectModule

