/*
 * DUT.sv: Design under test
 * Copyright (C) 2013 Brno University of Technology
 * Author: Lukas Kekely <ikekely@fit.vutbr.cz>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 */

import test_pkg::*;

module DUT (
  input logic CLK,
  input logic RESET,
  InputInterface.dut IN,
  OutputInterface.dut OUT,
  ConfigInterface.dut CFG,
  DirrectInterface.dut DIR
);

// -------------------- Module body -------------------------------------------
  TOP_VER #(
    .TREE_STAGES   (TREE_STAGES),
    .KEY_WIDTH     (KEY_WIDTH),
    .DATA_WIDTH    (DATA_WIDTH)
  ) VHDL_DUT_U  (
    .CLK               (CLK),
    .RESET             (RESET),
    .IN_KEY            (IN.data),
    .IN_VLD            (IN.vld),
    .OUT_DATA          (OUT.data),
    .OUT_LENGTH        (OUT.length),
    .OUT_FOUND         (OUT.found),
    .OUT_VLD           (OUT.vld),
    .CFG_KEY           (CFG.key),
    .CFG_KEYLEN        (CFG.keylen),
    .CFG_DATA          (CFG.data),
    .CFG_ADD_VLD       (CFG.add_vld),
    .CFG_REM_VLD       (CFG.rem_vld),
    .CFG_CLR_VLD       (CFG.clr_vld),
    .CFG_BUSY          (CFG.busy),
    .CFG_FULL          (CFG.full),
    .DIR_ADDR          (DIR.addr),
    .DIR_RD            (DIR.rd),
    .DIR_KEY           (DIR.key),
    .DIR_KEYLEN        (DIR.keylen),
    .DIR_ISEND         (DIR.isend),
    .DIR_KEYVLD        (DIR.keyvld),
    .DIR_DATA          (DIR.data),
    .DIR_DRDY          (DIR.drdy)
  );

endmodule : DUT
