/*
 * filter_ruleset.sv: Set of prefix rules in filter
 * Copyright (C) 2013 Brno University of Technology
 * Author: Lukas Kekely <ikekely@fit.vutbr.cz>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 */
 
typedef string stringArray[]; 
typedef FilterRuleTransaction ruleArray[];
 
class FilterRuleSetNode;
  FilterRuleTransaction rule;
  FilterRuleSetNode childs[$];
  
  function bit lower(FilterRuleSetNode n);
    for(int i=0; i < rule.key.size; i++) begin
      if (rule.key[i] < n.rule.key[i])
        return 1;
      if (rule.key[i] > n.rule.key[i])
        return 0;
    end
    return 0;
  endfunction
  
  task add(FilterRuleTransaction r, ref bit status);
    int i;
    string dummy;
    FilterRuleSetNode newNode;
    status = 1;
    foreach(childs[i])
      if(childs[i].rule.coverRule(r,dummy)) begin // some rule covers new one
        if(childs[i].rule.coveredByRule(r,dummy)) // covering rule is the same as the new rule
          status = 0;
        else
          childs[i].add(r,status); // add new rule under this child
        return;
      end
    newNode = new;  // new rule under this node
    newNode.rule = new;
    r.copy(newNode.rule);
    for(i=0; i < childs.size; i++)  // move all rules covered by the new rule under it
      if (r.coverRule(childs[i].rule,dummy)) begin
        newNode.childs.push_back(childs[i]);
        childs.delete(i);
        i--;
      end
    for(i=0; i < childs.size; i++) // insert new rule (sorted)
      if (newNode.lower(childs[i]))
        break;
    childs.insert(i,newNode);
  endtask
  
  task remove(FilterRuleTransaction r, ref bit status);
    string dummy;
    FilterRuleSetNode tmpNode;
    status = 0;
    foreach(childs[i])
      if(childs[i].rule.coverRule(r,dummy)) begin // some rule covers removed one
        if(childs[i].rule.coveredByRule(r,dummy)) begin // covering rule is the same as the removed rule
          tmpNode = childs[i];
          status = 1;
          childs.delete(i);
          for(int i=0,j=0; i<tmpNode.childs.size; i++,j++) begin // add removed node childs into childs of this node (sorted)
            while(j<childs.size && childs[j].lower(tmpNode.childs[i]))
              j++;
            childs.insert(j,tmpNode.childs[i]); 
          end
        end else
          childs[i].remove(r,status); // removed rule is under this child
        return;
      end
  endtask
  
  task display(int level);
    for(int i=0; i < level; i++)
      $write("..");
    rule.display();
    foreach(childs[i])
      childs[i].display(level+1);
  endtask
  
  function OutputTransaction lpm(FilterRuleTransaction r);
    string dummy;
    OutputTransaction o;
    foreach(childs[i])
      if(childs[i].rule.coverRule(r,dummy))
        return childs[i].lpm(r);
    o = new;
    o.found = 1;
    o.length = rule.keylen;
    o.data = rule.data;
    return o; 
  endfunction

  function stringArray traverse(string end_data);
    string tmp,e,ed,s;
    string ret[];
    byte unsigned db;
    tmp="BEG: ";
    for (integer i=0; i < rule.key.size; i++) begin
      if(rule.keylen/8 == i)
        db=rule.key[i] & FilterRuleTransaction::mask[rule.keylen&7];
      else if (rule.keylen/8 > i)
        db=rule.key[i];
      else
        db=0; 
      $swrite(tmp, "%s%x ", tmp, db);  
    end
    $swrite(tmp, "%s/ %0d  => ", tmp, rule.keylen+1);
    ed="";
    for (integer i=0; i < rule.data.size; i++)
      $swrite(ed, "%s %x", ed, rule.data[i]);
    $swrite(s, "%s%s", tmp, ed);
    tmp="END: ";
    for (integer i=0; i < rule.key.size; i++) begin
      if(rule.keylen/8 == i)
        db=rule.key[i] | ~(FilterRuleTransaction::mask[rule.keylen&7]);
      else if (rule.keylen/8 > i)
        db=rule.key[i];
      else
        db=255; 
      $swrite(tmp, "%s%x ", tmp, db);  
    end
    $swrite(tmp, "%s/ %0d  => ", tmp, rule.keylen+1);
    $swrite(e, "%s%s", tmp, end_data);
    ret={s};
    foreach(childs[i])
      ret={ret,childs[i].traverse(ed)};
    ret={ret,e};
    return ret;  
  endfunction
  
  function ruleArray traverseR();
    ruleArray ret={rule};
    foreach(childs[i])
      ret={ret,childs[i].traverseR()};
    return ret;
  endfunction
  
endclass

class FilterRuleSet;
  
  //FilterRuleTransaction set[$];
  FilterRuleSetNode root;
  
  function new ();
    root = new;
  endfunction
    
  // Add item to the set
  task add(FilterRuleTransaction r, ref bit status);
    root.add(r,status);
//    string dummy;
//    status = 1;
//    for(int i=0; i < set.size; i++)
//      if (r.compareKey(set[i],dummy)) begin
//        status = 0;
//        break;
//      end
//    if (status)
//      set.push_back(r);
  endtask: add
  
 //Remove item from the set
  task remove(FilterRuleTransaction r, ref bit status);
    root.remove(r,status);
//    string dummy;
//    status=0;
//    for(integer i=0; i < set.size; i++) 
//      if (r.compareKey(set[i],dummy)) begin
//        set.delete(i);
//        status = 1;
//        break;
//      end      
  endtask: remove 
  
  // Display the actual state of transaction table
  task display(integer full=1, string inst = "");
    $write("------------------------------------------------------------\n");
    $write("-- %s RULE SET\n", inst);
    $write("------------------------------------------------------------\n");
//    $write("Size: %d\n", set.size);
    if (full)
      foreach(root.childs[i])
        root.childs[i].display(0);
//      foreach(set[i]) 
//        set[i].display();
    $write("------------------------------------------------------------\n");
  endtask: display
  
  // Longest prefix match
  function OutputTransaction lpm(FilterRuleTransaction r);
    string dummy;
    OutputTransaction o;
    o = new;
    o.found = 0;
    o.length = 0;
    foreach(root.childs[i]) begin
      if(root.childs[i].rule.coverRule(r,dummy))
        o=root.childs[i].lpm(r);
    end
//    foreach(set[i])
//      if (set[i].coverRule(r,dummy) && set[i].keylen>=o.length) begin
//        o.found = 1;
//        o.length = set[i].keylen;
//        o.data = set[i].data;
//      end
    lpm = o;
  endfunction: lpm
  
  // Write tree nodes in pre-post order
  function stringArray traverse();
    string ret[]={};
    string end_string;
    foreach(root.childs[i]) begin
    end_string="";
      for (integer j=0; j < root.childs[i].rule.data.size; j++)
        $swrite(end_string, "%s 00", end_string);
      ret={ret,root.childs[i].traverse(end_string)};
    end
    return ret;
  endfunction
  
  function ruleArray traverseR();
    return root.traverseR();
  endfunction
  
endclass: FilterRuleSet