/*
 * out_interface.sv: Tested design output interface
 * Copyright (C) 2013 Brno University of Technology
 * Author: Lukas Kekely <ikekely@fit.vutbr.cz>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 */
 
interface OutputInterface #(int pDataWidth=32, int pLengthWidth=5) (input logic CLK, RESET);  
  
  // Interface signals 
  logic [pDataWidth-1:0] data;
  logic [pLengthWidth-1:0] length;
  logic found;
  logic vld;
  
  // Clocking blocks  
  clocking cb @(posedge CLK);
    input data, length, found, vld;
  endclocking: cb;

  // Control Modport
  modport dut (output data, output length, output found, output vld);
  modport tb  (clocking cb);
  
  // While RESET is active, VLD is inactive
  property RESETVLD;
    @(posedge CLK) (RESET)|->!(vld); 
  endproperty   
  assert property (RESETVLD)
     else $error("Output valid during reset.");

endinterface : OutputInterface 
 
