-- top_ver.vhd: Verification wrapper
-- Copyright (C) 2013 Brno University of Technology
-- Author(s): Lukas Kekely <ikekely@fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
use WORK.tree_func.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity top_ver is
  generic(
    -- number of non-leaf tree stages (levels) (capacity is 2**(TS-1) prefixes)
    TREE_STAGES    : integer := 10;
    -- width of keys inside tree nodes
    KEY_WIDTH      : integer := 128;
    -- width of data inside leaf nodes
    DATA_WIDTH     : integer := 32
  );
  port(
    CLK           : in  std_logic;
    RESET         : in  std_logic;
    
    -- input interface
    IN_KEY        : in  std_logic_vector(KEY_WIDTH-1 downto 0);
    IN_VLD        : in  std_logic;
--    IN_CHANGE_EN  : in  std_logic;
    
    -- output interface
    OUT_DATA      : out std_logic_vector(DATA_WIDTH-1 downto 0);
    OUT_LENGTH    : out std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    OUT_FOUND     : out std_logic;
    OUT_VLD       : out std_logic;
    
    -- configuration interface
    CFG_KEY       : in  std_logic_vector(KEY_WIDTH-1 downto 0);
    CFG_KEYLEN    : in  std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    CFG_DATA      : in  std_logic_vector(DATA_WIDTH-1 downto 0);
    CFG_ADD_VLD   : in  std_logic;
    CFG_REM_VLD   : in  std_logic;
    CFG_CLR_VLD   : in  std_logic;
    CFG_BUSY      : out std_logic;
    CFG_FULL      : out std_logic;
    DIR_ADDR      : in  std_logic_vector(TREE_STAGES-1 downto 0);
    DIR_RD        : in  std_logic;
    DIR_KEY       : out std_logic_vector(KEY_WIDTH-1 downto 0);
    DIR_KEYLEN    : out std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    DIR_ISEND     : out std_logic;
    DIR_KEYVLD    : out std_logic;
    DIR_DATA      : out std_logic_vector(DATA_WIDTH-1 downto 0);
    DIR_DRDY      : out std_logic
  );
end entity; 



library IEEE;
use IEEE.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.math_pack.all;
use WORK.tree_func.all;

architecture full of TOP_VER is
  constant USE_STAGES : STAGE_TYPE_ARRAY(0 to 31) := (STAGE_TYPE_REGARRAY, STAGE_TYPE_REGARRAY, STAGE_TYPE_REGARRAY, STAGE_TYPE_DIST3MEM, STAGE_TYPE_NOTHING, 
                                                      STAGE_TYPE_NOTHING,  STAGE_TYPE_DISTMEM,  STAGE_TYPE_DISTMEM,  STAGE_TYPE_BMEM,     STAGE_TYPE_BMEM,
                                                      STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                      STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                      STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                      STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                      STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING);
  constant USE_STAGE_LEAF : MEMORY_TYPE := mem_bmem;
  constant USE_REGS       : std_logic_vector(0 to 32*3) := "0010010010010010010010010010011000000000000000000000000000000000000000000000000000000000000000000";  
begin
  dut : entity work.tree
    generic map(
      TREE_STAGES    => TREE_STAGES,
      KEY_WIDTH      => KEY_WIDTH,
      DATA_WIDTH     => DATA_WIDTH,
      USE_STAGES     => USE_STAGES,
      USE_STAGE_LEAF => USE_STAGE_LEAF,
      USE_REGS       => USE_REGS
    ) port map (
      CLK           => CLK,
      RESET         => RESET,
      IN_KEY        => IN_KEY,
      IN_VLD        => IN_VLD,
      IN_CHANGE_EN  => '1',
      IN_FOUNDABLE  => IN_VLD,
      OUT_DATA      => OUT_DATA,
      OUT_LENGTH    => OUT_LENGTH,
      OUT_FOUND     => OUT_FOUND,
      OUT_VLD       => OUT_VLD,
      CFG_KEY       => CFG_KEY,
      CFG_KEYLEN    => CFG_KEYLEN,
      CFG_DATA      => CFG_DATA,
      CFG_ADD_VLD   => CFG_ADD_VLD,
      CFG_REM_VLD   => CFG_REM_VLD,
      CFG_CLR_VLD   => CFG_CLR_VLD,
      CFG_BUSY      => CFG_BUSY,
      CFG_FULL      => CFG_FULL,
      DIR_ADDR      => DIR_ADDR,
      DIR_RD        => DIR_RD,
      DIR_KEY       => DIR_KEY,
      DIR_KEYLEN    => DIR_KEYLEN,
      DIR_ISEND     => DIR_ISEND,
      DIR_KEYVLD    => DIR_KEYVLD,
      DIR_DATA      => DIR_DATA,
      DIR_DRDY      => DIR_DRDY
    );
  
end architecture;
