package convert.relaxng.output;

import convert.relaxng.translate.util.ParamProcessor;
import convert.relaxng.translate.util.EncodingParam;
import convert.relaxng.translate.util.IntegerParam;
import convert.relaxng.translate.util.Param;

public class OutputDirectoryParamProcessor extends ParamProcessor {
  private final OutputDirectory od;
  private static final int MAX_INDENT = 16;

  public OutputDirectoryParamProcessor(OutputDirectory od) {
    this.od = od;
    super.declare("encoding",
                  new EncodingParam() {
                    protected void setEncoding(String encoding) {
                      OutputDirectoryParamProcessor.this.od.setEncoding(encoding);
                    }
                  });
    super.declare("indent",
                  new IntegerParam(0, MAX_INDENT) {
                    protected void setInteger(int value) {
                      OutputDirectoryParamProcessor.this.od.setIndent(value);
                    }
                  });
  }
}
