package convert.relaxng.output.dtd;

import convert.relaxng.output.OutputFormat;
import convert.relaxng.output.OutputDirectory;
import convert.relaxng.output.OutputFailedException;
import convert.relaxng.output.OutputDirectoryParamProcessor;
import convert.relaxng.output.common.ErrorReporter;
import convert.relaxng.edit.SchemaCollection;
import convert.relaxng.translate.util.InvalidParamsException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.io.File;

public class DtdOutputFormat implements OutputFormat {
  public void output(SchemaCollection sc, final OutputDirectory od, String[] params, String inputFormat, ErrorHandler eh)
          throws SAXException, IOException, OutputFailedException, InvalidParamsException {
    new OutputDirectoryParamProcessor(od).process(params, eh);
    Simplifier.simplify(sc);
    try {
      ErrorReporter er = new ErrorReporter(eh, DtdOutputFormat.class);
      Analysis analysis = new Analysis(sc, er);
      if (!er.getHadError())
        DtdOutput.output(!inputFormat.equals("xml"), analysis, od, er);
      if (er.getHadError())
        throw new OutputFailedException();
    }
    catch (ErrorReporter.WrappedSAXException e) {
      throw e.getException();
    }
  }
}
