package convert.relaxng.parse.sax;

import convert.relaxng.parse.ParseReceiver;
import convert.relaxng.parse.ParsedPatternFuture;
import convert.relaxng.parse.SchemaBuilder;
import convert.relaxng.parse.Scope;
import convert.xml.sax.XMLReaderCreator;
import org.xml.sax.XMLReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SAXParseReceiver extends SAXSubParser implements ParseReceiver {
  public SAXParseReceiver(XMLReaderCreator xrc, ErrorHandler eh) {
    super(xrc, eh);
  }

  public ParsedPatternFuture installHandlers(XMLReader xr, SchemaBuilder schemaBuilder, Scope scope)
          throws SAXException {
    return new SchemaParser(xr, eh, schemaBuilder, null, scope);
  }
}
